/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy.template.internal;

import io.netty.buffer.ByteBuf;
import io.netty.util.CharsetUtil;
import java.io.IOException;

public class TextTemplateParser {
    private static final byte[] LESS_THAN = TextTemplateParser.bytes("<");
    private static final byte[] DOLLAR_BRACE = TextTemplateParser.bytes("${");
    private static final byte[] PERCENT = TextTemplateParser.bytes("%");
    private static final byte[] START_OUTPUT = TextTemplateParser.bytes("$(\n\"\"\"");
    private static final byte[] START_CODE = TextTemplateParser.bytes("\"\"\"\n);");
    private static final byte[] CLOSE_BRACE = TextTemplateParser.bytes("}");
    private static final byte[] DOLLAR = TextTemplateParser.bytes("$");
    private static final byte[] BACKSLASH = TextTemplateParser.bytes("\\");
    private static final byte[] SEMICOLON = TextTemplateParser.bytes(";");

    private static byte[] bytes(String s) {
        return s.getBytes(CharsetUtil.UTF_8);
    }

    public void parse(ByteBuf input, ByteBuf output) throws IOException {
        this.startScript(output);
        while (input.isReadable()) {
            byte c = input.readByte();
            if (c == 60) {
                input.markReaderIndex();
                c = input.readByte();
                if (c != 37) {
                    output.writeBytes(LESS_THAN);
                    input.resetReaderIndex();
                    continue;
                }
                input.markReaderIndex();
                c = input.readByte();
                if (c == 61) {
                    this.groovyExpression(input, output);
                    continue;
                }
                input.resetReaderIndex();
                this.groovySection(input, output);
                continue;
            }
            if (c == 36) {
                input.markReaderIndex();
                c = input.readByte();
                if (c != 123) {
                    output.writeBytes(DOLLAR);
                    input.resetReaderIndex();
                    continue;
                }
                input.markReaderIndex();
                this.processGSstring(input, output);
                continue;
            }
            if (c == 34) {
                output.writeBytes(BACKSLASH);
            }
            if (c == 10 || c == 13) {
                if (c == 13) {
                    input.markReaderIndex();
                    c = input.readByte();
                    if (c != 10) {
                        input.resetReaderIndex();
                    }
                }
                output.writeByte(10);
                continue;
            }
            output.writeByte((int)c);
        }
        this.endScript(output);
    }

    private void startScript(ByteBuf output) {
        output.writeBytes(START_OUTPUT);
    }

    private void endScript(ByteBuf output) {
        output.writeBytes(START_CODE);
    }

    private void processGSstring(ByteBuf input, ByteBuf output) throws IOException {
        output.writeBytes(DOLLAR_BRACE);
        while (input.isReadable()) {
            byte c = input.readByte();
            if (c != 10 && c != 13) {
                output.writeByte((int)c);
            }
            if (c != 125) continue;
            break;
        }
    }

    private void groovyExpression(ByteBuf input, ByteBuf output) throws IOException {
        output.writeBytes(DOLLAR_BRACE);
        while (input.isReadable()) {
            byte c = input.readByte();
            if (c == 37) {
                c = input.readByte();
                if (c == 62) break;
                output.writeBytes(PERCENT);
            }
            if (c == 10 || c == 13) continue;
            output.writeByte((int)c);
        }
        output.writeBytes(CLOSE_BRACE);
    }

    private void groovySection(ByteBuf input, ByteBuf output) throws IOException {
        output.writeBytes(START_CODE);
        output.writeByte(10);
        while (input.isReadable()) {
            byte c = input.readByte();
            if (c == 37) {
                c = input.readByte();
                if (c == 62) break;
                output.writeBytes(PERCENT);
            }
            output.writeByte((int)c);
        }
        output.writeByte(10);
        output.writeBytes(SEMICOLON);
        output.writeBytes(START_OUTPUT);
    }
}

