/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy.template.internal;

import groovy.text.markup.MarkupTemplateEngine;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class CachingTemplateResolver
extends MarkupTemplateEngine.DefaultTemplateResolver {
    private final ConcurrentMap<String, URL> urlCache = new ConcurrentHashMap<String, URL>();
    private final Path templatesDir;

    private URL doLoad(String key) {
        try {
            return this.templatesDir.resolve(key).toUri().toURL();
        }
        catch (MalformedURLException e) {
            throw new UncheckedIOException(e);
        }
    }

    public CachingTemplateResolver(Path templatesDir) {
        this.templatesDir = templatesDir;
    }

    public URL resolveTemplate(String templatePath) throws IOException {
        return this.urlCache.computeIfAbsent(templatePath, this::doLoad);
    }
}

