/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy.internal;

import groovy.lang.Closure;
import groovy.lang.GroovySystem;
import java.nio.file.Path;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import ratpack.func.Action;
import ratpack.groovy.Groovy;
import ratpack.groovy.internal.ClosureUtil;
import ratpack.groovy.internal.GroovyVersionCheck;
import ratpack.groovy.internal.RatpackClosureConfigurer;
import ratpack.server.RatpackServer;

public class StandaloneScriptBacking
implements Action<Closure<?>> {
    private final Lock lock = new ReentrantLock();
    private RatpackServer running;
    public static final StandaloneScriptBacking INSTANCE = new StandaloneScriptBacking();

    private StandaloneScriptBacking() {
    }

    public void execute(Closure<?> closure) throws Exception {
        GroovyVersionCheck.ensureRequiredVersionUsed(GroovySystem.getVersion());
        this.lock.lock();
        try {
            Path scriptFile;
            if (this.running != null) {
                this.running.stop();
                this.running = null;
            }
            this.running = (scriptFile = ClosureUtil.findScript(closure)) == null ? RatpackServer.start((Action)new RatpackClosureConfigurer(closure, false)) : RatpackServer.start(Groovy.Script.app(scriptFile));
        }
        finally {
            this.lock.unlock();
        }
    }
}

