/*
 * Decompiled with CFR 0.152.
 */
package ratpack.server.internal;

import com.google.common.collect.ImmutableSet;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.SslContext;
import java.net.InetAddress;
import java.net.URI;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Optional;
import javax.net.ssl.SSLContext;
import ratpack.api.Nullable;
import ratpack.config.ConfigData;
import ratpack.config.ConfigObject;
import ratpack.config.internal.DelegatingConfigData;
import ratpack.file.FileSystemBinding;
import ratpack.server.NoBaseDirException;
import ratpack.server.ServerConfig;
import ratpack.server.internal.ServerConfigData;

public class DefaultServerConfig
extends DelegatingConfigData
implements ServerConfig {
    private final ServerConfigData serverConfigData;
    private final Optional<FileSystemBinding> baseDir;
    private final ImmutableSet<ConfigObject<?>> requiredConfig;

    public DefaultServerConfig(ConfigData configData, ImmutableSet<ConfigObject<?>> requiredConfig) {
        super(configData);
        this.requiredConfig = requiredConfig;
        this.serverConfigData = this.get("/server", ServerConfigData.class);
        this.baseDir = Optional.ofNullable(this.serverConfigData.getBaseDir());
    }

    @Override
    public int getPort() {
        return this.serverConfigData.getPort();
    }

    @Override
    @Nullable
    public InetAddress getAddress() {
        return this.serverConfigData.getAddress();
    }

    @Override
    public ImmutableSet<ConfigObject<?>> getRequiredConfig() {
        return this.requiredConfig;
    }

    @Override
    public boolean isDevelopment() {
        return this.serverConfigData.isDevelopment();
    }

    @Override
    public int getThreads() {
        return this.serverConfigData.getThreads();
    }

    @Override
    public boolean isRegisterShutdownHook() {
        return this.serverConfigData.isRegisterShutdownHook();
    }

    @Override
    public URI getPublicAddress() {
        return this.serverConfigData.getPublicAddress();
    }

    @Override
    @Nullable
    public SSLContext getSslContext() {
        SslContext sslContext = this.serverConfigData.getSslContext();
        if (sslContext instanceof JdkSslContext) {
            return ((JdkSslContext)sslContext).context();
        }
        throw new UnsupportedOperationException("Cannot provide sslContext as JDK type");
    }

    @Override
    public SslContext getNettySslContext() {
        return this.serverConfigData.getSslContext();
    }

    @Override
    public boolean isRequireClientSslAuth() {
        return this.serverConfigData.isRequireClientSslAuth();
    }

    @Override
    public int getMaxContentLength() {
        return this.serverConfigData.getMaxContentLength();
    }

    @Override
    public boolean isHasBaseDir() {
        return this.serverConfigData.getBaseDir() != null;
    }

    @Override
    public int getMaxChunkSize() {
        return this.serverConfigData.getMaxChunkSize();
    }

    @Override
    public int getMaxInitialLineLength() {
        return this.serverConfigData.getMaxInitialLineLength();
    }

    @Override
    public int getMaxHeaderSize() {
        return this.serverConfigData.getMaxHeaderSize();
    }

    @Override
    public Duration getIdleTimeout() {
        return this.serverConfigData.getIdleTimeout();
    }

    @Override
    public FileSystemBinding getBaseDir() throws NoBaseDirException {
        return this.baseDir.orElseThrow(() -> new NoBaseDirException("No base dir has been set"));
    }

    @Override
    public Optional<Integer> getConnectTimeoutMillis() {
        return this.serverConfigData.getConnectTimeoutMillis();
    }

    @Override
    public Optional<Integer> getMaxMessagesPerRead() {
        return this.serverConfigData.getMaxMessagesPerRead();
    }

    @Override
    public Optional<Integer> getReceiveBufferSize() {
        return this.serverConfigData.getReceiveBufferSize();
    }

    @Override
    public Optional<Integer> getConnectQueueSize() {
        return this.serverConfigData.getConnectQueueSize();
    }

    @Override
    public Optional<Integer> getWriteSpinCount() {
        return this.serverConfigData.getWriteSpinCount();
    }

    @Override
    public Optional<Path> getPortFile() {
        return this.serverConfigData.getPortFile();
    }
}

