/*
 * Decompiled with CFR 0.152.
 */
package ratpack.http.internal;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import io.netty.handler.codec.http.HttpHeaders;
import java.time.Instant;
import java.util.Date;
import ratpack.http.Headers;
import ratpack.http.MutableHeaders;
import ratpack.http.internal.HttpHeaderDateFormat;
import ratpack.http.internal.NettyHeadersBackedHeaders;

public class NettyHeadersBackedMutableHeaders
extends NettyHeadersBackedHeaders
implements MutableHeaders {
    private static final Function<Object, Object> CONVERT_VALUE = v -> v instanceof Instant ? new Date(((Instant)v).toEpochMilli()) : v;

    public NettyHeadersBackedMutableHeaders(HttpHeaders headers) {
        super(headers);
    }

    @Override
    public MutableHeaders add(CharSequence name, Object value) {
        this.headers.add(name, CONVERT_VALUE.apply(value));
        return this;
    }

    @Override
    public MutableHeaders set(CharSequence name, Object value) {
        this.headers.set(name, CONVERT_VALUE.apply(value));
        return this;
    }

    @Override
    public MutableHeaders setDate(CharSequence name, Date value) {
        this.headers.set(name, (Object)HttpHeaderDateFormat.get().format(value));
        return this;
    }

    @Override
    public MutableHeaders set(CharSequence name, Iterable<?> values) {
        this.headers.set(name, Iterables.transform(values, CONVERT_VALUE));
        return this;
    }

    @Override
    public MutableHeaders remove(CharSequence name) {
        this.headers.remove(name);
        return this;
    }

    @Override
    public MutableHeaders clear() {
        this.headers.clear();
        return this;
    }

    @Override
    public MutableHeaders copy(Headers headers) {
        this.headers.add(headers.getNettyHeaders());
        return this;
    }
}

