/*
 * Decompiled with CFR 0.152.
 */
package ratpack.file.internal;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.concurrent.ExecutionException;
import ratpack.file.BaseDirRequiredException;
import ratpack.file.FileSystemBinding;
import ratpack.handling.Context;
import ratpack.handling.Handler;
import ratpack.handling.internal.ChainHandler;
import ratpack.registry.Registry;
import ratpack.server.ServerConfig;

public class FileSystemBindingHandler
implements Handler {
    private final String path;
    private final Handler[] handler;
    private static final Cache<FileSystemBinding, Registry> CACHE = Caffeine.newBuilder().build();

    public FileSystemBindingHandler(ServerConfig serverConfig, String path, Handler handler) {
        if (!serverConfig.isHasBaseDir()) {
            throw new BaseDirRequiredException("An application base directory is required to use this handler");
        }
        this.path = path;
        this.handler = ChainHandler.unpack(handler);
    }

    @Override
    public void handle(Context context) throws ExecutionException {
        FileSystemBinding parentBinding = (FileSystemBinding)context.get(FileSystemBinding.class);
        FileSystemBinding binding = parentBinding.binding(this.path);
        if (binding == null) {
            context.clientError(404);
        } else {
            context.insert((Registry)CACHE.get((Object)binding, FileSystemBindingHandler::registry), this.handler);
        }
    }

    private static Registry registry(FileSystemBinding binding) {
        return Registry.single(FileSystemBinding.class, (Object)binding);
    }
}

