/*
 * Decompiled with CFR 0.152.
 */
package ratpack.file.internal;

import com.google.common.collect.ImmutableList;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import ratpack.file.internal.FileRenderer;
import ratpack.func.Action;
import ratpack.handling.Context;
import ratpack.handling.Handler;
import ratpack.http.Request;
import ratpack.path.PathBinding;
import ratpack.path.internal.PathBindingStorage;

public class FileHandler
implements Handler {
    private final ImmutableList<String> indexFiles;
    private final boolean cacheMetadata;

    public FileHandler(ImmutableList<String> indexFiles, boolean cacheMetadata) {
        this.indexFiles = indexFiles;
        this.cacheMetadata = cacheMetadata;
    }

    @Override
    public void handle(Context context) throws Exception {
        String path = ((PathBinding)((PathBindingStorage)context.getExecution().get(PathBindingStorage.TYPE)).peek()).getPastBinding();
        String decodedPath = FileHandler.decodeComponent(path, CharsetUtil.UTF_8);
        Path asset = context.file(decodedPath);
        if (asset == null) {
            context.clientError(404);
        } else {
            this.servePath(context, asset);
        }
    }

    private void servePath(Context context, Path file) throws Exception {
        FileRenderer.readAttributes(file, this.cacheMetadata, (Action<? super BasicFileAttributes>)((Action)attributes -> {
            if (attributes == null) {
                context.next();
            } else if (attributes.isRegularFile()) {
                if (context.getRequest().getMethod().isGet()) {
                    FileRenderer.sendFile(context, file, attributes);
                } else {
                    context.clientError(405);
                }
            } else if (attributes.isDirectory()) {
                if (context.getRequest().getMethod().isGet()) {
                    this.maybeSendFile(context, file, 0);
                } else {
                    context.clientError(405);
                }
            } else {
                context.next();
            }
        }));
    }

    private void maybeSendFile(Context context, Path file, int i) throws Exception {
        if (i == this.indexFiles.size()) {
            context.next();
        } else {
            String name = (String)this.indexFiles.get(i);
            Path indexFile = file.resolve(name);
            FileRenderer.readAttributes(indexFile, this.cacheMetadata, (Action<? super BasicFileAttributes>)((Action)attributes -> {
                if (attributes != null && attributes.isRegularFile()) {
                    String path = context.getRequest().getPath();
                    if (path.endsWith("/") || path.isEmpty()) {
                        FileRenderer.sendFile(context, indexFile, attributes);
                    } else {
                        context.redirect(this.currentUriWithTrailingSlash(context));
                    }
                } else {
                    this.maybeSendFile(context, file, i + 1);
                }
            }));
        }
    }

    private String currentUriWithTrailingSlash(Context context) {
        Request request = context.getRequest();
        String redirectUri = "/" + request.getPath() + "/";
        String query = request.getQuery();
        if (!query.isEmpty()) {
            redirectUri = redirectUri + "?" + query;
        }
        return redirectUri;
    }

    private static String decodeComponent(String s, Charset charset) {
        if (s == null) {
            return "";
        }
        int size = s.length();
        boolean modified = false;
        for (int i = 0; i < size; ++i) {
            char c = s.charAt(i);
            if (c != '%') continue;
            modified = true;
            break;
        }
        if (!modified) {
            return s;
        }
        byte[] buf = new byte[size];
        int pos = 0;
        block4: for (int i = 0; i < size; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '%': {
                    if (i == size - 1) {
                        throw new IllegalArgumentException("unterminated escape sequence at end of string: " + s);
                    }
                    if ((c = s.charAt(++i)) == '%') {
                        buf[pos++] = 37;
                        continue block4;
                    }
                    if (i == size - 1) {
                        throw new IllegalArgumentException("partial escape sequence at end of string: " + s);
                    }
                    c = FileHandler.decodeHexNibble(c);
                    char c2 = FileHandler.decodeHexNibble(s.charAt(++i));
                    if (c == '\uffff' || c2 == '\uffff') {
                        throw new IllegalArgumentException("invalid escape sequence `%" + s.charAt(i - 1) + s.charAt(i) + "' at index " + (i - 2) + " of: " + s);
                    }
                    c = (char)(c * 16 + c2);
                }
                default: {
                    buf[pos++] = (byte)c;
                }
            }
        }
        return new String(buf, 0, pos, charset);
    }

    private static char decodeHexNibble(char c) {
        if ('0' <= c && c <= '9') {
            return (char)(c - 48);
        }
        if ('a' <= c && c <= 'f') {
            return (char)(c - 97 + 10);
        }
        if ('A' <= c && c <= 'F') {
            return (char)(c - 65 + 10);
        }
        return '\uffff';
    }
}

