/*
 * Decompiled with CFR 0.152.
 */
package ratpack.util.internal;

import com.google.common.collect.Iterables;
import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Environment {
    public static final Environment INSTANCE = new Environment(System.getenv(), System.getProperties());
    public static final String DEVELOPMENT_PROPERTY = "ratpack.development";
    public static final String INTELLIJ_MAIN = "com.intellij.rt.execution.application.AppMain";
    public static final String INTELLIJ_JUNIT = "com.intellij.rt.execution.junit.JUnitStarter";
    public static final String GROOVY_MAIN = "org.codehaus.groovy.tools.GroovyStarter";
    public static final String SUN_JAVA_COMMAND = "sun.java.command";
    private static final Logger LOGGER = LoggerFactory.getLogger(Environment.class);
    private final Map<String, String> env;
    private final Properties properties;

    public Environment(Map<String, String> env, Properties properties) {
        this.env = env;
        this.properties = properties;
    }

    public static Environment env() {
        return INSTANCE;
    }

    @SafeVarargs
    protected static <T> T get(T defaultValue, Predicate<? super T> accept, Supplier<T> ... suppliers) {
        return (T)Iterables.find((Iterable)Iterables.transform(Arrays.asList(suppliers), Supplier::get), accept::test, defaultValue);
    }

    public Map<String, String> getenv() {
        return this.env;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public boolean isDevelopment() {
        return Boolean.parseBoolean(Environment.get("false", i -> i != null, () -> this.properties.getProperty(DEVELOPMENT_PROPERTY), () -> this.env.get("RATPACK_DEVELOPMENT"), () -> {
            String command = this.properties.getProperty(SUN_JAVA_COMMAND, "");
            return command.startsWith(INTELLIJ_MAIN) && !command.contains(INTELLIJ_JUNIT) ? "true" : null;
        }, () -> {
            String command = this.properties.getProperty(SUN_JAVA_COMMAND, "");
            return command.startsWith(GROOVY_MAIN) ? "true" : null;
        }, () -> Environment.isDebuggerAttached() ? "true" : null));
    }

    protected static boolean isDebuggerAttached() {
        return ManagementFactory.getRuntimeMXBean().getInputArguments().toString().indexOf("-agentlib:jdwp") > 0;
    }
}

