/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.proxy.callback;

import io.r2dbc.proxy.callback.CallbackHandlerSupport;
import io.r2dbc.proxy.callback.MutableBindInfo;
import io.r2dbc.proxy.callback.MutableQueryExecutionInfo;
import io.r2dbc.proxy.callback.ProxyConfig;
import io.r2dbc.proxy.core.Binding;
import io.r2dbc.proxy.core.Bindings;
import io.r2dbc.proxy.core.BoundValue;
import io.r2dbc.proxy.core.ConnectionInfo;
import io.r2dbc.proxy.core.ExecutionType;
import io.r2dbc.proxy.core.QueryInfo;
import io.r2dbc.proxy.core.R2dbcProxyException;
import io.r2dbc.proxy.core.StatementInfo;
import io.r2dbc.proxy.listener.BindParameterConverter;
import io.r2dbc.proxy.util.Assert;
import io.r2dbc.spi.Result;
import io.r2dbc.spi.Statement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;

public final class StatementCallbackHandler
extends CallbackHandlerSupport {
    private final Statement statement;
    private final ConnectionInfo connectionInfo;
    private final StatementInfo statementInfo;
    private final List<Bindings> bindings = new ArrayList<Bindings>();
    private int currentBindingsIndex = 0;

    public StatementCallbackHandler(Statement statement, StatementInfo statementInfo, ConnectionInfo connectionInfo, ProxyConfig proxyConfig) {
        super(proxyConfig);
        this.statement = Assert.requireNonNull(statement, "statement must not be null");
        this.statementInfo = Assert.requireNonNull(statementInfo, "originalQuery must not be null");
        this.connectionInfo = Assert.requireNonNull(connectionInfo, "connectionInfo must not be null");
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Assert.requireNonNull(proxy, "proxy must not be null");
        Assert.requireNonNull(method, "method must not be null");
        String methodName = method.getName();
        if ("unwrap".equals(methodName)) {
            return this.statement;
        }
        if ("unwrapConnection".equals(methodName)) {
            return this.connectionInfo.getOriginalConnection();
        }
        if ("bind".equals(methodName) || "bindNull".equals(methodName)) {
            BoundValue boundValue = "bind".equals(methodName) ? BoundValue.value(args[1]) : BoundValue.nullValue((Class)args[1]);
            boolean isIndexBinding = args[0] instanceof Integer;
            Comparable<Bindings.NamedBinding> binding = isIndexBinding ? Bindings.indexBinding((Integer)args[0], boundValue) : Bindings.namedBinding((String)args[0], boundValue);
            BindParameterConverter.BindOperation onBind = () -> this.lambda$invoke$0(method, args, methodName, isIndexBinding, (Binding)((Object)binding), proxy);
            MutableBindInfo bindInfo = new MutableBindInfo();
            bindInfo.setStatementInfo(this.statementInfo);
            bindInfo.setBinding((Binding)((Object)binding));
            this.proxyConfig.getBindParameterConverter().onBind(bindInfo, (Statement)proxy, onBind);
            return proxy;
        }
        Object result = this.proceedExecution(method, this.statement, args, this.proxyConfig.getListeners(), this.connectionInfo, null);
        if ("add".equals(methodName)) {
            ++this.currentBindingsIndex;
            return proxy;
        }
        if ("execute".equals(methodName)) {
            QueryInfo queryInfo = new QueryInfo(this.statementInfo.getUpdatedQuery());
            queryInfo.getBindingsList().addAll(this.bindings);
            List<QueryInfo> queries = Stream.of(queryInfo).collect(Collectors.toList());
            MutableQueryExecutionInfo execInfo = new MutableQueryExecutionInfo();
            execInfo.setType(ExecutionType.STATEMENT);
            execInfo.setQueries(queries);
            execInfo.setBindingsSize(this.bindings.size());
            execInfo.setMethod(method);
            execInfo.setMethodArgs(args);
            execInfo.setConnectionInfo(this.connectionInfo);
            Publisher publisher = (Publisher)result;
            return this.interceptQueryExecution((Publisher<? extends Result>)publisher, execInfo);
        }
        if ("returnGeneratedValues".equals(methodName)) {
            return proxy;
        }
        return result;
    }

    private /* synthetic */ Statement lambda$invoke$0(Method method, Object[] args, String methodName, boolean isIndexBinding, Binding binding, Object proxy) {
        try {
            this.proceedExecution(method, this.statement, args, this.proxyConfig.getListeners(), this.connectionInfo, null);
        }
        catch (Throwable throwable) {
            throw new R2dbcProxyException("Failed to perform " + methodName, throwable);
        }
        if (this.bindings.size() <= this.currentBindingsIndex) {
            this.bindings.add(new Bindings());
        }
        Bindings bindings = this.bindings.get(this.currentBindingsIndex);
        if (isIndexBinding) {
            bindings.addIndexBinding((Bindings.IndexBinding)binding);
        } else {
            bindings.addNamedBinding((Bindings.NamedBinding)binding);
        }
        return (Statement)proxy;
    }
}

