/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.client.Parameter;
import io.r2dbc.postgresql.codec.AbstractCodec;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.type.PostgresqlObjectId;
import io.r2dbc.postgresql.util.Assert;
import io.r2dbc.postgresql.util.ByteBufUtils;
import reactor.util.annotation.Nullable;

final class StringCodec
extends AbstractCodec<String> {
    private final ByteBufAllocator byteBufAllocator;

    StringCodec(ByteBufAllocator byteBufAllocator) {
        super(String.class);
        this.byteBufAllocator = Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
    }

    @Override
    public Parameter encodeNull() {
        return StringCodec.createNull(PostgresqlObjectId.VARCHAR, Format.FORMAT_TEXT);
    }

    @Override
    boolean doCanDecode(PostgresqlObjectId type, Format format) {
        Assert.requireNonNull(format, "format must not be null");
        Assert.requireNonNull(type, "type must not be null");
        return PostgresqlObjectId.BPCHAR == type || PostgresqlObjectId.CHAR == type || PostgresqlObjectId.TEXT == type || PostgresqlObjectId.UNKNOWN == type || PostgresqlObjectId.VARCHAR == type || PostgresqlObjectId.NAME == type;
    }

    @Override
    String doDecode(ByteBuf buffer, PostgresqlObjectId dataType, @Nullable Format format, @Nullable Class<? extends String> type) {
        Assert.requireNonNull(buffer, "byteBuf must not be null");
        return ByteBufUtils.decode(buffer);
    }

    @Override
    Parameter doEncode(String value) {
        Assert.requireNonNull(value, "value must not be null");
        return StringCodec.create(PostgresqlObjectId.VARCHAR, Format.FORMAT_TEXT, () -> ByteBufUtils.encode(this.byteBufAllocator, value));
    }
}

