/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.r2dbc.postgresql.api.PostgresqlConnection;
import io.r2dbc.postgresql.util.Assert;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class PostgresTypes {
    private static final String SELECT_PG_TYPE = "SELECT pg_type.oid, typname, typcategory   FROM pg_catalog.pg_type   LEFT   JOIN (select ns.oid as nspoid, ns.nspname, r.r           from pg_namespace as ns           join ( select s.r, (current_schemas(false))[s.r] as nspname                    from generate_series(1, array_upper(current_schemas(false), 1)) as s(r) ) as r          using ( nspname )        ) as sp     ON sp.nspoid = typnamespace  WHERE typname %s %s  ORDER BY sp.r, pg_type.oid DESC %s;";
    private static final Pattern TYPENAME = Pattern.compile("[a-zA-Z0-9_]+");
    private final PostgresqlConnection connection;

    private PostgresTypes(PostgresqlConnection connection) {
        this.connection = connection;
    }

    public static PostgresTypes from(PostgresqlConnection connection) {
        return new PostgresTypes(Assert.requireNonNull(connection, "connection must not be null"));
    }

    public Mono<PostgresType> lookupType(String typeName) {
        if (!TYPENAME.matcher(Assert.requireNonNull(typeName, "typeName must not be null")).matches()) {
            throw new IllegalArgumentException(String.format("Invalid typename %s", typeName));
        }
        return this.connection.createStatement(String.format(SELECT_PG_TYPE, "=", typeName, "LIMIT 1")).execute().flatMap(it -> it.map((row, rowMetadata) -> new PostgresType((Integer)row.get("oid", Integer.class), (String)row.get("typname", String.class), (String)row.get("typcategory", String.class)))).singleOrEmpty();
    }

    public Flux<PostgresType> lookupTypes(Iterable<String> typeNames) {
        StringJoiner joiner = new StringJoiner(",", "(", ")");
        typeNames.forEach(typeName -> {
            if (!TYPENAME.matcher(Assert.requireNonNull(typeName, "typeName must not be null")).matches()) {
                throw new IllegalArgumentException(String.format("Invalid typename %s", typeName));
            }
            joiner.add("'" + typeName + "'");
        });
        return this.connection.createStatement(String.format(SELECT_PG_TYPE, "IN", joiner, "")).execute().flatMap(it -> it.map((row, rowMetadata) -> new PostgresType((Integer)row.get("oid", Integer.class), (String)row.get("typname", String.class), (String)row.get("typcategory", String.class))));
    }

    public static class PostgresType {
        private final int oid;
        private final String name;
        private final String category;

        public PostgresType(int oid, String name, String category) {
            this.oid = oid;
            this.name = name;
            this.category = category;
        }

        public int getOid() {
            return this.oid;
        }

        public String getName() {
            return this.name;
        }

        public boolean isArray() {
            return "A".equals(this.category);
        }

        public boolean isBoolean() {
            return "B".equals(this.category);
        }

        public boolean isComposite() {
            return "C".equals(this.category);
        }

        public boolean isDateTime() {
            return "D".equals(this.category);
        }

        public boolean isEnum() {
            return "E".equals(this.category);
        }

        public boolean isGeometric() {
            return "G".equals(this.category);
        }

        public boolean isNetworkAddress() {
            return "I".equals(this.category);
        }

        public boolean isNumeric() {
            return "N".equals(this.category);
        }

        public boolean isPseudo() {
            return "P".equals(this.category);
        }

        public boolean isString() {
            return "S".equals(this.category);
        }

        public boolean isTimespan() {
            return "T".equals(this.category);
        }

        public boolean isUserDefinedType() {
            return "U".equals(this.category);
        }

        public boolean isBitString() {
            return "V".equals(this.category);
        }

        public boolean isUnknown() {
            return "X".equals(this.category);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PostgresType)) {
                return false;
            }
            PostgresType that = (PostgresType)o;
            return this.oid == that.oid && Objects.equals(this.name, that.name) && Objects.equals(this.category, that.category);
        }

        public int hashCode() {
            return Objects.hash(this.oid, this.name, this.category);
        }

        public String toString() {
            return "PostgresType{oid=" + this.oid + ", name='" + this.name + '\'' + ", category='" + this.category + '\'' + '}';
        }
    }
}

