/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.ByteProcessor;
import io.netty.util.CharsetUtil;
import io.r2dbc.postgresql.client.Parameter;
import io.r2dbc.postgresql.codec.Codec;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.util.Assert;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

final class HStoreCodec
implements Codec<Map> {
    private final ByteBufAllocator byteBufAllocator;
    private final Class<Map> type = Map.class;
    private final int oid;

    HStoreCodec(ByteBufAllocator byteBufAllocator, int oid) {
        this.byteBufAllocator = Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
        this.oid = oid;
    }

    @Override
    public boolean canDecode(int dataType, Format format, Class<?> type) {
        Assert.requireNonNull(format, "format must not be null");
        Assert.requireNonNull(type, "type must not be null");
        Assert.requireNonNull(type, "type must not be null");
        return dataType == this.oid && type.isAssignableFrom(this.type);
    }

    @Override
    public boolean canEncode(Object value) {
        Assert.requireNonNull(value, "value must not be null");
        return this.type.isInstance(value);
    }

    @Override
    public boolean canEncodeNull(Class<?> type) {
        Assert.requireNonNull(type, "type must not be null");
        return this.type.isAssignableFrom(type);
    }

    @Override
    public Map<String, String> decode(@Nullable ByteBuf buffer, int dataType, Format format, Class<? extends Map> type) {
        if (buffer == null) {
            return null;
        }
        if (format == Format.FORMAT_TEXT) {
            return HStoreCodec.decodeTextFormat(buffer);
        }
        return HStoreCodec.decodeBinaryFormat(buffer);
    }

    private static Map<String, String> decodeBinaryFormat(ByteBuf buffer) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (!buffer.isReadable()) {
            return map;
        }
        int numElements = buffer.readInt();
        for (int i = 0; i < numElements; ++i) {
            int keyLen = buffer.readInt();
            String key = buffer.readCharSequence(keyLen, CharsetUtil.UTF_8).toString();
            int valLen = buffer.readInt();
            String val = valLen == -1 ? null : buffer.readCharSequence(valLen, CharsetUtil.UTF_8).toString();
            map.put(key, val);
        }
        return map;
    }

    private static Map<String, String> decodeTextFormat(ByteBuf buffer) {
        String key;
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        StringBuilder mutableBuffer = new StringBuilder();
        while (buffer.isReadable() && (key = HStoreCodec.readString(mutableBuffer, buffer)) != null) {
            String value;
            buffer.skipBytes(2);
            if ((char)HStoreCodec.peekByte(buffer) == 'N') {
                value = null;
                buffer.skipBytes(4);
            } else {
                value = HStoreCodec.readString(mutableBuffer, buffer);
            }
            map.put(key, value);
            if (!buffer.isReadable()) continue;
            buffer.readByte();
        }
        return map;
    }

    private static byte peekByte(ByteBuf buffer) {
        int readerIndex = buffer.readerIndex();
        try {
            byte by = buffer.readByte();
            return by;
        }
        finally {
            buffer.readerIndex(readerIndex);
        }
    }

    @Nullable
    private static String readString(StringBuilder mutableBuffer, ByteBuf buffer) {
        char c;
        mutableBuffer.setLength(0);
        int position = buffer.forEachByte((ByteProcessor)new IndexOfProcessor(34));
        if (position > buffer.writerIndex()) {
            return null;
        }
        if (position > -1) {
            buffer.readerIndex(position + 1);
        }
        while (buffer.isReadable() && (c = (char)buffer.readByte()) != '\"') {
            if (c == '\\') {
                c = (char)buffer.readByte();
            }
            mutableBuffer.append(c);
        }
        String result = mutableBuffer.toString();
        mutableBuffer.setLength(0);
        return result;
    }

    @Override
    public Parameter encode(Object value) {
        Assert.requireNonNull(value, "value must not be null");
        Map map = (Map)value;
        return new Parameter(Format.FORMAT_BINARY, this.oid, (Publisher<? extends ByteBuf>)Mono.fromSupplier(() -> {
            ByteBuf buffer = this.byteBufAllocator.buffer(4 + 10 * map.size());
            buffer.writeInt(map.size());
            for (Map.Entry entry : map.entrySet()) {
                String k = entry.getKey().toString();
                byte[] bytes = k.getBytes(CharsetUtil.UTF_8);
                buffer.writeInt(bytes.length);
                buffer.writeBytes(bytes);
                if (entry.getValue() == null) {
                    buffer.writeInt(-1);
                    continue;
                }
                String v = entry.getValue().toString();
                bytes = v.getBytes(CharsetUtil.UTF_8);
                buffer.writeInt(bytes.length);
                buffer.writeBytes(bytes);
            }
            return buffer;
        }));
    }

    @Override
    public Parameter encodeNull() {
        return new Parameter(Format.FORMAT_BINARY, this.oid, (Publisher<? extends ByteBuf>)Parameter.NULL_VALUE);
    }

    @Override
    public Class<?> type() {
        return this.type;
    }

    static class IndexOfProcessor
    implements ByteProcessor {
        private final byte byteToFind;

        public IndexOfProcessor(byte byteToFind) {
            this.byteToFind = byteToFind;
        }

        public boolean process(byte value) {
            return value != this.byteToFind;
        }
    }
}

