/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.r2dbc.postgresql.client.Parameter;
import io.r2dbc.postgresql.codec.AbstractBinaryCodec;
import io.r2dbc.postgresql.codec.AbstractCodec;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.type.PostgresqlObjectId;
import io.r2dbc.postgresql.util.Assert;
import io.r2dbc.spi.Blob;
import java.nio.ByteBuffer;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

final class BlobCodec
extends AbstractCodec<Blob> {
    private final ByteBufAllocator byteBufAllocator;

    BlobCodec(ByteBufAllocator byteBufAllocator) {
        super(Blob.class);
        this.byteBufAllocator = Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
    }

    @Override
    public Parameter encodeNull() {
        return BlobCodec.createNull(PostgresqlObjectId.BYTEA, Format.FORMAT_TEXT);
    }

    @Override
    boolean doCanDecode(PostgresqlObjectId type, Format format) {
        Assert.requireNonNull(format, "format must not be null");
        Assert.requireNonNull(type, "type must not be null");
        return PostgresqlObjectId.BYTEA == type;
    }

    @Override
    Blob doDecode(ByteBuf buffer, PostgresqlObjectId dataType, @Nullable Format format, @Nullable Class<? extends Blob> type) {
        Assert.requireNonNull(buffer, "byteBuf must not be null");
        return new ByteABlob(buffer, format);
    }

    @Override
    Parameter doEncode(Blob value) {
        Assert.requireNonNull(value, "value must not be null");
        return BlobCodec.create(PostgresqlObjectId.BYTEA, Format.FORMAT_TEXT, (Publisher<? extends ByteBuf>)Flux.from((Publisher)value.stream()).reduce((Object)this.byteBufAllocator.compositeBuffer(), (a, b) -> a.addComponent(true, Unpooled.wrappedBuffer((ByteBuffer)b))).map(it -> AbstractBinaryCodec.encodeToHex((ByteBuf)it, this.byteBufAllocator)).concatWith((Publisher)Flux.from((Publisher)value.discard()).then(Mono.empty())));
    }

    private static final class ByteABlob
    implements Blob {
        private final ByteBuf byteBuf;
        private final Format format;

        private ByteABlob(ByteBuf byteBuf, Format format) {
            this.byteBuf = byteBuf.retain();
            this.format = format;
        }

        public Mono<Void> discard() {
            return Mono.fromRunnable(() -> {
                if (this.byteBuf.refCnt() > 0) {
                    this.byteBuf.release();
                }
            });
        }

        public Mono<ByteBuffer> stream() {
            return Mono.fromSupplier(() -> {
                if (this.format == Format.FORMAT_BINARY) {
                    return this.byteBuf.nioBuffer();
                }
                return ByteBuffer.wrap(AbstractBinaryCodec.decodeFromHex(this.byteBuf));
            }).doAfterTerminate(() -> ((ByteBuf)this.byteBuf).release());
        }
    }
}

