/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql;

import io.netty.util.AbstractReferenceCounted;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import io.r2dbc.postgresql.ConnectionResources;
import io.r2dbc.postgresql.ExceptionFactory;
import io.r2dbc.postgresql.PostgresqlRow;
import io.r2dbc.postgresql.PostgresqlRowMetadata;
import io.r2dbc.postgresql.message.backend.BackendMessage;
import io.r2dbc.postgresql.message.backend.CommandComplete;
import io.r2dbc.postgresql.message.backend.DataRow;
import io.r2dbc.postgresql.message.backend.ErrorResponse;
import io.r2dbc.postgresql.message.backend.RowDescription;
import io.r2dbc.postgresql.util.Assert;
import io.r2dbc.spi.Row;
import io.r2dbc.spi.RowMetadata;
import java.util.function.BiFunction;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SynchronousSink;

final class PostgresqlResult
extends AbstractReferenceCounted
implements io.r2dbc.postgresql.api.PostgresqlResult {
    private final ConnectionResources resources;
    private final Flux<BackendMessage> messages;
    private final ExceptionFactory factory;
    private volatile PostgresqlRowMetadata metadata;
    private volatile RowDescription rowDescription;

    PostgresqlResult(ConnectionResources resources, Flux<BackendMessage> messages, ExceptionFactory factory) {
        this.resources = Assert.requireNonNull(resources, "resources must not be null");
        this.messages = Assert.requireNonNull(messages, "messages must not be null");
        this.factory = Assert.requireNonNull(factory, "factory must not be null");
    }

    @Override
    public Mono<Integer> getRowsUpdated() {
        return this.messages.handle((message, sink) -> {
            Integer rowCount;
            if (message instanceof ErrorResponse) {
                this.factory.handleErrorResponse((BackendMessage)message, (SynchronousSink<BackendMessage>)sink);
                return;
            }
            if (message instanceof DataRow) {
                ((DataRow)message).release();
            }
            if (message instanceof CommandComplete && (rowCount = ((CommandComplete)message).getRows()) != null) {
                sink.next((Object)rowCount);
            }
        }).singleOrEmpty();
    }

    @Override
    public <T> Flux<T> map(BiFunction<Row, RowMetadata, ? extends T> f) {
        Assert.requireNonNull(f, "f must not be null");
        return this.messages.handle((message, sink) -> {
            try {
                if (message instanceof ErrorResponse) {
                    this.factory.handleErrorResponse((BackendMessage)message, (SynchronousSink<BackendMessage>)sink);
                    return;
                }
                if (message instanceof RowDescription) {
                    this.rowDescription = (RowDescription)message;
                    this.metadata = PostgresqlRowMetadata.toRowMetadata(this.resources.getCodecs(), (RowDescription)message);
                    return;
                }
                if (message instanceof DataRow) {
                    PostgresqlRow row = PostgresqlRow.toRow(this.resources, (DataRow)message, this.rowDescription);
                    sink.next(f.apply(row, this.metadata));
                }
            }
            finally {
                ReferenceCountUtil.release((Object)message);
            }
        });
    }

    protected void deallocate() {
        this.getRowsUpdated().subscribe();
    }

    public ReferenceCounted touch(Object hint) {
        return this;
    }

    public String toString() {
        return "PostgresqlResult{context=" + this.resources + ", messages=" + this.messages + '}';
    }

    static PostgresqlResult toResult(ConnectionResources resources, Flux<BackendMessage> messages, ExceptionFactory factory) {
        return new PostgresqlResult(resources, messages, factory);
    }
}

