/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.pool;

import io.r2dbc.pool.Assert;
import io.r2dbc.pool.ConnectionPool;
import io.r2dbc.pool.ConnectionPoolConfiguration;
import io.r2dbc.pool.OptionMapper;
import io.r2dbc.spi.Connection;
import io.r2dbc.spi.ConnectionFactories;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.ConnectionFactoryOptions;
import io.r2dbc.spi.ConnectionFactoryProvider;
import io.r2dbc.spi.Option;
import io.r2dbc.spi.ValidationDepth;
import java.time.Duration;
import java.util.function.Function;
import org.reactivestreams.Publisher;

public class PoolingConnectionFactoryProvider
implements ConnectionFactoryProvider {
    public static final String POOLING_DRIVER = "pool";
    public static final Option<Integer> ACQUIRE_RETRY = Option.valueOf((String)"acquireRetry");
    public static final Option<Integer> BACKGROUND_EVICTION_INTERVAL = Option.valueOf((String)"backgroundEvictionInterval");
    public static final Option<Integer> INITIAL_SIZE = Option.valueOf((String)"initialSize");
    public static final Option<Integer> MAX_SIZE = Option.valueOf((String)"maxSize");
    public static final Option<Integer> MIN_IDLE = Option.valueOf((String)"minIdle");
    public static final Option<Duration> MAX_ACQUIRE_TIME = Option.valueOf((String)"maxAcquireTime");
    public static final Option<Duration> MAX_CREATE_CONNECTION_TIME = Option.valueOf((String)"maxCreateConnectionTime");
    public static final Option<Duration> MAX_IDLE_TIME = Option.valueOf((String)"maxIdleTime");
    public static final Option<Duration> MAX_LIFE_TIME = Option.valueOf((String)"maxLifeTime");
    public static final Option<Duration> MAX_VALIDATION_TIME = Option.valueOf((String)"maxValidationTime");
    public static final Option<String> POOL_NAME = Option.valueOf((String)"poolName");
    public static final Option<Boolean> REGISTER_JMX = Option.valueOf((String)"registerJmx");
    public static final Option<Function<? super Connection, ? extends Publisher<Void>>> POST_ALLOCATE = Option.valueOf((String)"postAllocate");
    public static final Option<Function<? super Connection, ? extends Publisher<Void>>> PRE_RELEASE = Option.valueOf((String)"preRelease");
    public static final Option<String> VALIDATION_QUERY = Option.valueOf((String)"validationQuery");
    public static final Option<ValidationDepth> VALIDATION_DEPTH = Option.valueOf((String)"validationDepth");
    private static final String COLON = ":";

    public ConnectionPool create(ConnectionFactoryOptions connectionFactoryOptions) {
        return new ConnectionPool(PoolingConnectionFactoryProvider.buildConfiguration(connectionFactoryOptions));
    }

    static ConnectionPoolConfiguration buildConfiguration(ConnectionFactoryOptions connectionFactoryOptions) {
        String protocol = connectionFactoryOptions.getRequiredValue(ConnectionFactoryOptions.PROTOCOL).toString();
        if (protocol.trim().length() == 0) {
            throw new IllegalArgumentException(String.format("Protocol %s is not valid.", protocol));
        }
        String[] protocols = protocol.split(COLON, 2);
        String driverDelegate = protocols[0];
        String protocolDelegate = protocols.length == 2 ? protocols[1] : "";
        ConnectionFactoryOptions newOptions = ConnectionFactoryOptions.builder().from(connectionFactoryOptions).option(ConnectionFactoryOptions.DRIVER, (Object)driverDelegate).option(ConnectionFactoryOptions.PROTOCOL, (Object)protocolDelegate).build();
        ConnectionFactory connectionFactory = ConnectionFactories.find((ConnectionFactoryOptions)newOptions);
        if (connectionFactory == null) {
            throw new IllegalArgumentException(String.format("Could not find delegating driver [%s]", driverDelegate));
        }
        ConnectionPoolConfiguration.Builder builder = ConnectionPoolConfiguration.builder(connectionFactory);
        OptionMapper mapper = OptionMapper.create(newOptions);
        mapper.from(BACKGROUND_EVICTION_INTERVAL).as(OptionMapper::toDuration).to(builder::backgroundEvictionInterval);
        mapper.from(INITIAL_SIZE).as(OptionMapper::toInteger).to(builder::initialSize);
        mapper.from(MAX_SIZE).as(OptionMapper::toInteger).to(builder::maxSize);
        mapper.from(MIN_IDLE).as(OptionMapper::toInteger).to(builder::minIdle);
        mapper.from(ACQUIRE_RETRY).as(OptionMapper::toInteger).to(builder::acquireRetry);
        mapper.from(MAX_ACQUIRE_TIME).as(OptionMapper::toDuration).to(builder::maxAcquireTime);
        mapper.from(MAX_CREATE_CONNECTION_TIME).as(OptionMapper::toDuration).to(builder::maxCreateConnectionTime);
        mapper.from(MAX_LIFE_TIME).as(OptionMapper::toDuration).to(builder::maxLifeTime);
        mapper.from(MAX_IDLE_TIME).as(OptionMapper::toDuration).to(builder::maxIdleTime);
        mapper.from(MAX_VALIDATION_TIME).as(OptionMapper::toDuration).to(builder::maxValidationTime);
        mapper.fromExact(POOL_NAME).to(builder::name);
        mapper.fromExact(POST_ALLOCATE).to(builder::postAllocate);
        mapper.fromExact(PRE_RELEASE).to(builder::preRelease);
        mapper.from(REGISTER_JMX).as(OptionMapper::toBoolean).to(builder::registerJmx);
        mapper.fromExact(VALIDATION_QUERY).to(builder::validationQuery);
        mapper.from(VALIDATION_DEPTH).as(validationDepth -> OptionMapper.toEnum(validationDepth, ValidationDepth.class)).to(builder::validationDepth);
        return builder.build();
    }

    public boolean supports(ConnectionFactoryOptions connectionFactoryOptions) {
        Assert.requireNonNull(connectionFactoryOptions, "connectionFactoryOptions must not be null");
        Object driver = connectionFactoryOptions.getValue(ConnectionFactoryOptions.DRIVER);
        return driver != null && driver.equals(POOLING_DRIVER);
    }

    public String getDriver() {
        return POOLING_DRIVER;
    }
}

