/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.h2.codecs;

import io.r2dbc.h2.codecs.AbstractCodec;
import io.r2dbc.h2.util.Assert;
import org.h2.value.Value;
import org.h2.value.ValueVarchar;

final class StringCodec
extends AbstractCodec<String> {
    StringCodec() {
        super(String.class);
    }

    @Override
    boolean doCanDecode(int dataType) {
        return 2 == dataType || 4 == dataType || 1 == dataType || 36 == dataType;
    }

    @Override
    String doDecode(Value value, Class<? extends String> type) {
        return value.getString();
    }

    @Override
    Value doEncode(String value) {
        return ValueVarchar.get((String)Assert.requireNonNull(value, "value must not be null"));
    }
}

