/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.jaxrs;

import jakarta.ws.rs.ServiceUnavailableException;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.CompletionCallback;
import jakarta.ws.rs.container.ConnectionCallback;
import jakarta.ws.rs.container.TimeoutHandler;
import jakarta.ws.rs.core.Response;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;

public class AsyncResponseImpl
implements AsyncResponse,
Runnable {
    private final ResteasyReactiveRequestContext context;
    private volatile boolean suspended;
    private volatile boolean cancelled;
    private volatile TimeoutHandler timeoutHandler;
    private Runnable timerCancelTask = null;

    public AsyncResponseImpl(ResteasyReactiveRequestContext context) {
        this.context = context;
        this.suspended = true;
    }

    public synchronized boolean resume(Object response) {
        if (!this.suspended) {
            return false;
        }
        this.suspended = false;
        this.cancelTimer();
        this.context.setResult(response);
        this.context.resume();
        return true;
    }

    public synchronized boolean resume(Throwable response) {
        if (!this.suspended) {
            return false;
        }
        this.suspended = false;
        this.cancelTimer();
        this.context.handleException(response);
        this.context.resume();
        return true;
    }

    public boolean cancel() {
        return this.internalCancel(null);
    }

    public boolean cancel(int retryAfter) {
        return this.internalCancel(retryAfter);
    }

    private synchronized boolean internalCancel(Object retryAfter) {
        if (this.cancelled) {
            return true;
        }
        if (!this.suspended) {
            return false;
        }
        this.cancelTimer();
        this.suspended = false;
        this.cancelled = true;
        Response.ResponseBuilder response = Response.status((int)503);
        if (retryAfter != null) {
            response.header("Retry-After", retryAfter);
        }
        this.context.setResult(response.build());
        this.context.resume();
        return true;
    }

    public boolean cancel(Date retryAfter) {
        return this.internalCancel(retryAfter);
    }

    private void cancelTimer() {
        if (this.timerCancelTask != null) {
            this.timerCancelTask.run();
            this.timerCancelTask = null;
        }
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public boolean isDone() {
        return !this.suspended;
    }

    public synchronized boolean setTimeout(long time, TimeUnit unit) {
        if (!this.suspended) {
            return false;
        }
        if (this.timerCancelTask != null) {
            this.timerCancelTask.run();
        }
        this.timerCancelTask = this.context.registerTimer(TimeUnit.MILLISECONDS.convert(time, unit), this);
        return true;
    }

    public void setTimeoutHandler(TimeoutHandler handler) {
        this.timeoutHandler = handler;
    }

    public Collection<Class<?>> register(Class<?> callback) {
        Objects.requireNonNull(callback);
        try {
            return this.register(callback.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<Class<?>, Collection<Class<?>>> register(Class<?> callback, Class<?> ... callbacks) {
        Objects.requireNonNull(callback);
        Objects.requireNonNull(callbacks);
        HashMap ret = new HashMap();
        ret.put(callback, this.register(callback));
        for (Class<?> cb : callbacks) {
            ret.put(cb, this.register(cb));
        }
        return ret;
    }

    public Collection<Class<?>> register(Object callback) {
        Objects.requireNonNull(callback);
        ArrayList ret = new ArrayList(2);
        if (callback instanceof ConnectionCallback) {
            this.context.registerConnectionCallback((ConnectionCallback)callback);
            ret.add(ConnectionCallback.class);
        }
        if (callback instanceof CompletionCallback) {
            this.context.registerCompletionCallback((CompletionCallback)callback);
            ret.add(CompletionCallback.class);
        }
        return ret;
    }

    public Map<Class<?>, Collection<Class<?>>> register(Object callback, Object ... callbacks) {
        Objects.requireNonNull(callback);
        Objects.requireNonNull(callbacks);
        HashMap ret = new HashMap();
        ret.put(callback.getClass(), this.register(callback));
        for (Object cb : callbacks) {
            ret.put(cb.getClass(), this.register(cb));
        }
        return ret;
    }

    @Override
    public synchronized void run() {
        this.timerCancelTask = null;
        if (!this.suspended || this.cancelled) {
            return;
        }
        if (this.timeoutHandler != null) {
            this.timeoutHandler.handleTimeout((AsyncResponse)this);
            if (this.suspended && this.timerCancelTask == null) {
                this.resume((Throwable)new ServiceUnavailableException());
            }
        } else {
            this.resume((Throwable)new ServiceUnavailableException());
        }
    }
}

