/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public class PathPart {
    public final Path file;
    public final long offset;
    public final long count;

    public PathPart(Path file, long offset, long count) {
        if (!Files.exists(file, new LinkOption[0])) {
            throw new IllegalArgumentException("File does not exist: " + String.valueOf(file));
        }
        if (!Files.isRegularFile(file, new LinkOption[0])) {
            throw new IllegalArgumentException("File is not a regular file: " + String.valueOf(file));
        }
        if (!Files.isReadable(file)) {
            throw new IllegalArgumentException("File cannot be read: " + String.valueOf(file));
        }
        if (offset < 0L) {
            throw new IllegalArgumentException("Offset (" + offset + ") must be >= 0: " + String.valueOf(file));
        }
        if (count < 0L) {
            throw new IllegalArgumentException("Count (" + count + ") must be >= 0: " + String.valueOf(file));
        }
        try {
            long fileLength = Files.size(file);
            if (offset + count > fileLength) {
                throw new IllegalArgumentException("Offset + count (" + (offset + count) + ") larger than file size (" + fileLength + "): " + String.valueOf(file));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.file = file;
        this.offset = offset;
        this.count = count;
    }
}

