/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.common.util.types;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import org.jboss.resteasy.reactive.common.util.types.GenericArrayTypeImpl;
import org.jboss.resteasy.reactive.common.util.types.ParameterizedTypeImpl;
import org.jboss.resteasy.reactive.common.util.types.WildcardTypeImpl;

public class TypeSignatureParser {
    private char[] chars;
    private int i;

    public TypeSignatureParser(String signature) {
        this.chars = signature.toCharArray();
    }

    public Type parseType() {
        int arrayCount = 0;
        Type ret = null;
        int start = this.i;
        block14: while (true) {
            char c = this.chars[this.i++];
            switch (c) {
                case 'B': {
                    ret = Byte.TYPE;
                    break block14;
                }
                case 'C': {
                    ret = Character.TYPE;
                    break block14;
                }
                case 'D': {
                    ret = Double.TYPE;
                    break block14;
                }
                case 'F': {
                    ret = Float.TYPE;
                    break block14;
                }
                case 'I': {
                    ret = Integer.TYPE;
                    break block14;
                }
                case 'J': {
                    ret = Long.TYPE;
                    break block14;
                }
                case 'S': {
                    ret = Short.TYPE;
                    break block14;
                }
                case 'Z': {
                    ret = Boolean.TYPE;
                    break block14;
                }
                case 'V': {
                    ret = Void.TYPE;
                    break block14;
                }
                case 'L': {
                    ret = this.parseReference();
                    break block14;
                }
                case 'T': {
                    throw new IllegalArgumentException("Invalid type variable in signature: " + new String(this.chars) + " at position " + this.i);
                }
                case '[': {
                    ++arrayCount;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid signature char: " + c + " in " + new String(this.chars) + " at position " + this.i);
                }
            }
        }
        if (arrayCount > 0) {
            if (ret instanceof Class) {
                Type retClass = ret;
                if (((Class)retClass).isPrimitive()) {
                    return this.loadClass(new String(this.chars, start, this.i - start));
                }
                return this.loadClass(new String(this.chars, start, arrayCount + 1) + ((Class)retClass).getName() + ";");
            }
            if (ret instanceof ParameterizedType) {
                for (int a = 0; a < arrayCount; ++a) {
                    ret = new GenericArrayTypeImpl(ret);
                }
                return ret;
            }
            throw new UnsupportedOperationException();
        }
        return ret;
    }

    private Type parseReference() {
        int start = this.i;
        StringBuilder name = new StringBuilder(this.chars.length - start);
        ArrayList<WildcardType> args = new ArrayList<WildcardType>();
        Type lastOwnerType = null;
        block6: while (this.i < this.chars.length) {
            char c = this.chars[this.i++];
            switch (c) {
                case '/': {
                    name.append('.');
                    continue block6;
                }
                case '<': {
                    do {
                        Type typeArg;
                        boolean ext = false;
                        boolean sup = false;
                        if (this.chars[this.i] == '+') {
                            ++this.i;
                            ext = true;
                        } else if (this.chars[this.i] == '-') {
                            ++this.i;
                            sup = true;
                        }
                        if (ext) {
                            typeArg = WildcardTypeImpl.withUpperBound(this.parseType());
                        } else if (sup) {
                            typeArg = WildcardTypeImpl.withLowerBound(this.parseType());
                        } else if (this.chars[this.i] == '*') {
                            ++this.i;
                            typeArg = WildcardTypeImpl.defaultInstance();
                        } else {
                            typeArg = this.parseType();
                        }
                        args.add((WildcardType)typeArg);
                    } while (this.chars[this.i] != '>');
                    ++this.i;
                    continue block6;
                }
                case '.': {
                    Type ownerType = this.loadClass(name.toString());
                    if (!args.isEmpty()) {
                        ownerType = new ParameterizedTypeImpl(ownerType, args.toArray(new Type[0]), lastOwnerType);
                        args.clear();
                    }
                    lastOwnerType = ownerType;
                    name.append('$');
                    continue block6;
                }
                case ';': {
                    Type type = this.loadClass(name.toString());
                    if (args.isEmpty()) {
                        return type;
                    }
                    return new ParameterizedTypeImpl(type, args.toArray(new Type[0]), lastOwnerType);
                }
            }
            name.append(c);
        }
        throw new UnsupportedOperationException();
    }

    private Type loadClass(String name) {
        try {
            return Class.forName(name, false, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static Type parse(String signature) {
        return new TypeSignatureParser(signature).parseType();
    }
}

