/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.client.impl;

import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.smallrye.mutiny.Multi;
import io.smallrye.stork.api.ServiceInstance;
import io.vertx.core.Context;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.core.GenericEntity;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.ReaderInterceptor;
import jakarta.ws.rs.ext.WriterInterceptor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.jboss.resteasy.reactive.ClientWebApplicationException;
import org.jboss.resteasy.reactive.RestResponse;
import org.jboss.resteasy.reactive.client.impl.AsyncInvokerImpl;
import org.jboss.resteasy.reactive.client.impl.ClientImpl;
import org.jboss.resteasy.reactive.client.impl.ClientRequestContextImpl;
import org.jboss.resteasy.reactive.client.impl.ClientRequestHeaders;
import org.jboss.resteasy.reactive.client.impl.ClientResponseContextImpl;
import org.jboss.resteasy.reactive.client.impl.ClientSerialisers;
import org.jboss.resteasy.reactive.client.impl.multipart.QuarkusMultipartForm;
import org.jboss.resteasy.reactive.client.spi.ClientRestHandler;
import org.jboss.resteasy.reactive.client.spi.MultipartResponseData;
import org.jboss.resteasy.reactive.common.core.AbstractResteasyReactiveContext;
import org.jboss.resteasy.reactive.common.core.Serialisers;
import org.jboss.resteasy.reactive.common.jaxrs.ConfigurationImpl;
import org.jboss.resteasy.reactive.common.jaxrs.ResponseImpl;
import org.jboss.resteasy.reactive.common.util.CaseInsensitiveMap;
import org.jboss.resteasy.reactive.spi.RestHandler;
import org.jboss.resteasy.reactive.spi.ThreadSetupAction;

public class RestClientRequestContext
extends AbstractResteasyReactiveContext<RestClientRequestContext, ClientRestHandler> {
    public static final String INVOKED_METHOD_PROP = "org.eclipse.microprofile.rest.client.invokedMethod";
    public static final String INVOKED_METHOD_PARAMETERS_PROP = "io.quarkus.rest.client.invokedMethodParameters";
    public static final String DEFAULT_CONTENT_TYPE_PROP = "io.quarkus.rest.client.defaultContentType";
    public static final String DEFAULT_USER_AGENT_VALUE = "Quarkus REST Client";
    private static final String TMP_FILE_PATH_KEY = "tmp_file_path";
    static final MediaType IGNORED_MEDIA_TYPE = new MediaType("ignored", "ignored");
    private final HttpClient httpClient;
    String httpMethod;
    URI uri;
    Entity<?> entity;
    GenericType<?> responseType;
    private boolean responseTypeSpecified;
    private final ClientImpl restClient;
    final ClientRequestHeaders requestHeaders;
    final ConfigurationImpl configuration;
    private final boolean registerBodyHandler;
    private final boolean checkSuccessfulFamily;
    private final CompletableFuture<ResponseImpl> result;
    private final ClientRestHandler[] abortHandlerChainWithoutResponseFilters;
    private final boolean disableContextualErrorMessages;
    private HttpClientResponse vertxClientResponse;
    Map<String, Object> properties;
    private HttpClientRequest httpClientRequest;
    private int responseStatus;
    private String responseReasonPhrase;
    private MultivaluedMap<String, String> responseHeaders;
    private ClientRequestContextImpl clientRequestContext;
    private ClientResponseContextImpl clientResponseContext;
    private InputStream responseEntityStream;
    private List<InterfaceHttpData> responseMultiParts;
    private Response abortedWith;
    private ServiceInstance callStatsCollector;
    private Map<Class<?>, MultipartResponseData> multipartResponsesData;
    private StackTraceElement[] callerStackTrace;

    public RestClientRequestContext(ClientImpl restClient, HttpClient httpClient, String httpMethod, URI uri, ConfigurationImpl configuration, ClientRequestHeaders requestHeaders, Entity<?> entity, GenericType<?> responseType, boolean registerBodyHandler, Map<String, Object> properties, ClientRestHandler[] handlerChain, ClientRestHandler[] abortHandlerChain, ClientRestHandler[] abortHandlerChainWithoutResponseFilters, ThreadSetupAction requestContext) {
        super((RestHandler[])handlerChain, (RestHandler[])abortHandlerChain, requestContext);
        this.restClient = restClient;
        this.httpClient = httpClient;
        this.httpMethod = httpMethod;
        this.uri = uri;
        this.requestHeaders = requestHeaders;
        this.configuration = configuration;
        this.entity = entity;
        this.abortHandlerChainWithoutResponseFilters = abortHandlerChainWithoutResponseFilters;
        if (responseType == null) {
            this.responseType = new GenericType(String.class);
            this.checkSuccessfulFamily = false;
            this.responseTypeSpecified = false;
        } else {
            this.responseType = responseType;
            if (responseType.getRawType().equals(Response.class)) {
                this.checkSuccessfulFamily = false;
                this.responseTypeSpecified = false;
            } else if (responseType.getRawType().equals(RestResponse.class)) {
                ParameterizedType type;
                if (responseType.getType() instanceof ParameterizedType && (type = (ParameterizedType)responseType.getType()).getActualTypeArguments().length == 1) {
                    Type restResponseType = type.getActualTypeArguments()[0];
                    this.responseType = new GenericType(restResponseType);
                }
                this.checkSuccessfulFamily = false;
                this.responseTypeSpecified = true;
            } else {
                this.checkSuccessfulFamily = true;
                this.responseTypeSpecified = true;
            }
        }
        this.registerBodyHandler = registerBodyHandler;
        this.result = new CompletableFuture();
        this.properties = new HashMap<String, Object>(properties);
        this.disableContextualErrorMessages = Boolean.parseBoolean(System.getProperty("quarkus.rest-client.disable-contextual-error-messages", "false")) || this.getBooleanProperty("io.quarkus.rest.client.disable-contextual-error-messages", false) != false;
    }

    public void abort() {
        this.setAbortHandlerChainStarted(true);
        this.restart((ClientRestHandler[])this.abortHandlerChain);
    }

    public Method getInvokedMethod() {
        Object o = this.properties.get(INVOKED_METHOD_PROP);
        if (o instanceof Method) {
            return (Method)o;
        }
        return null;
    }

    public Annotation[] getMethodDeclaredAnnotationsSafe() {
        Method invokedMethod = this.getInvokedMethod();
        if (invokedMethod != null) {
            return invokedMethod.getDeclaredAnnotations();
        }
        return null;
    }

    protected Throwable unwrapException(Throwable t) {
        Throwable res = super.unwrapException(t);
        if (res instanceof WebApplicationException) {
            WebApplicationException webApplicationException = (WebApplicationException)res;
            Object message = webApplicationException.getMessage();
            Object invokedMethodObject = this.properties.get(INVOKED_METHOD_PROP);
            if (invokedMethodObject instanceof Method && !this.disableContextualErrorMessages) {
                Method invokedMethod = (Method)invokedMethodObject;
                message = "Received: '" + (String)message + "' when invoking: Rest Client method: '" + invokedMethod.getDeclaringClass().getName() + "#" + invokedMethod.getName() + "'";
            }
            return new ClientWebApplicationException((String)message, webApplicationException instanceof ClientWebApplicationException ? webApplicationException.getCause() : webApplicationException, webApplicationException.getResponse());
        }
        return res;
    }

    public <T> T readEntity(InputStream in, GenericType<T> responseType, MediaType mediaType, Annotation[] annotations, MultivaluedMap<String, Object> metadata) throws IOException {
        if (in == null) {
            return null;
        }
        return (T)ClientSerialisers.invokeClientReader(annotations, responseType.getRawType(), responseType.getType(), mediaType, this.properties, this, metadata, this.restClient.getClientContext().getSerialisers(), in, this.getReaderInterceptors(), this.configuration);
    }

    public ReaderInterceptor[] getReaderInterceptors() {
        return this.configuration.getReaderInterceptors().toArray(Serialisers.NO_READER_INTERCEPTOR);
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void initialiseResponse(HttpClientResponse vertxResponse) {
        CaseInsensitiveMap headers = new CaseInsensitiveMap();
        MultiMap vertxHeaders = vertxResponse.headers();
        for (String i : vertxHeaders.names()) {
            headers.addAll((Object)i, vertxHeaders.getAll(i));
        }
        this.vertxClientResponse = vertxResponse;
        this.responseStatus = vertxResponse.statusCode();
        this.responseReasonPhrase = vertxResponse.statusMessage();
        this.responseHeaders = headers;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public ClientRequestContextImpl getClientRequestContext() {
        return this.clientRequestContext;
    }

    public ClientResponseContextImpl getOrCreateClientResponseContext() {
        if (this.clientResponseContext == null) {
            this.clientResponseContext = new ClientResponseContextImpl(this);
        }
        return this.clientResponseContext;
    }

    public ClientRequestContextImpl getOrCreateClientRequestContext() {
        if (this.clientRequestContext == null) {
            this.clientRequestContext = new ClientRequestContextImpl(this, this.getRestClient(), this.getConfiguration());
        }
        return this.clientRequestContext;
    }

    public Buffer writeEntity(Entity<?> entity, MultivaluedMap<String, String> headerMap, WriterInterceptor[] interceptors) throws IOException {
        Type entityType;
        Class entityClass;
        Object entityObject = entity.getEntity();
        if (entityObject == null) {
            return AsyncInvokerImpl.EMPTY_BUFFER;
        }
        if (entityObject instanceof GenericEntity) {
            GenericEntity genericEntity = (GenericEntity)entityObject;
            entityClass = genericEntity.getRawType();
            entityType = genericEntity.getType();
            entityObject = genericEntity.getEntity();
        } else {
            entityType = entityClass = entityObject.getClass();
        }
        List writers = this.restClient.getClientContext().getSerialisers().findWriters(this.configuration, entityClass, entity.getMediaType(), RuntimeType.CLIENT);
        for (MessageBodyWriter w : writers) {
            Buffer ret = ClientSerialisers.invokeClientWriter(entity, entityObject, entityClass, entityType, headerMap, w, interceptors, this.properties, this, this.restClient.getClientContext().getSerialisers(), this.configuration);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    public void setEntity(Object entity, Annotation[] annotations, MediaType mediaType) {
        if (entity == null) {
            this.entity = null;
        } else {
            if (mediaType == null) {
                mediaType = IGNORED_MEDIA_TYPE;
            }
            this.entity = Entity.entity((Object)entity, (MediaType)mediaType, (Annotation[])annotations);
        }
    }

    public CompletableFuture<ResponseImpl> getResult() {
        return this.result;
    }

    public HttpClientResponse getVertxClientResponse() {
        return this.vertxClientResponse;
    }

    protected Executor getEventLoop() {
        if (this.httpClientRequest == null) {
            final Context context = this.restClient.getVertx().getOrCreateContext();
            return new Executor(){

                @Override
                public void execute(Runnable command) {
                    context.runOnContext(v -> command.run());
                }
            };
        }
        return new Executor(){

            @Override
            public void execute(Runnable command) {
                command.run();
            }
        };
    }

    public HttpClientRequest getHttpClientRequest() {
        return this.httpClientRequest;
    }

    public RestClientRequestContext setHttpClientRequest(HttpClientRequest httpClientRequest) {
        this.httpClientRequest = httpClientRequest;
        return this;
    }

    protected void handleRequestScopeActivation() {
    }

    protected void restarted(boolean keepTarget) {
    }

    public void close() {
        super.close();
        if (!this.result.isDone()) {
            try {
                ClientRestHandler[] handlers = (ClientRestHandler[])this.handlers;
                Object[] handlerClassNames = new String[handlers.length];
                for (int i = 0; i < handlers.length; ++i) {
                    handlerClassNames[i] = handlers[i].getClass().getName();
                }
                log.error((Object)("Client was closed, however the result was not completed. Handlers array is: " + Arrays.toString(handlerClassNames) + ". Last executed handler is: " + handlers[this.position - 1].getClass().getName()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.result.completeExceptionally(new IllegalStateException("Client request did not complete"));
        }
    }

    protected void handleUnrecoverableError(Throwable throwable) {
        this.result.completeExceptionally(throwable);
    }

    public ConfigurationImpl getConfiguration() {
        return this.configuration;
    }

    public ClientImpl getRestClient() {
        return this.restClient;
    }

    public int getResponseStatus() {
        return this.responseStatus;
    }

    public RestClientRequestContext setResponseStatus(int responseStatus) {
        this.responseStatus = responseStatus;
        return this;
    }

    public String getResponseReasonPhrase() {
        return this.responseReasonPhrase;
    }

    public RestClientRequestContext setResponseReasonPhrase(String responseReasonPhrase) {
        this.responseReasonPhrase = responseReasonPhrase;
        return this;
    }

    public MultivaluedMap<String, String> getResponseHeaders() {
        return this.responseHeaders;
    }

    public RestClientRequestContext setResponseHeaders(MultivaluedMap<String, String> responseHeaders) {
        this.responseHeaders = responseHeaders;
        return this;
    }

    public boolean isCheckSuccessfulFamily() {
        return this.checkSuccessfulFamily;
    }

    public boolean isResponseTypeSpecified() {
        return this.responseTypeSpecified;
    }

    public RestClientRequestContext setResponseTypeSpecified(boolean responseTypeSpecified) {
        this.responseTypeSpecified = responseTypeSpecified;
        return this;
    }

    public GenericType<?> getResponseType() {
        return this.responseType;
    }

    public RestClientRequestContext setResponseType(GenericType<?> responseType) {
        this.responseType = responseType;
        return this;
    }

    public ClientRequestHeaders getRequestHeaders() {
        return this.requestHeaders;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public RestClientRequestContext setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
        return this;
    }

    public URI getUri() {
        return this.uri;
    }

    public RestClientRequestContext setUri(URI uri) {
        this.uri = uri;
        return this;
    }

    public Entity<?> getEntity() {
        return this.entity;
    }

    public RestClientRequestContext setEntity(Entity<?> entity) {
        this.entity = entity;
        return this;
    }

    public boolean isRegisterBodyHandler() {
        return this.registerBodyHandler;
    }

    public InputStream getResponseEntityStream() {
        return this.responseEntityStream;
    }

    public RestClientRequestContext setResponseEntityStream(InputStream responseEntityStream) {
        this.responseEntityStream = responseEntityStream;
        return this;
    }

    public RestClientRequestContext setResponseMultipartParts(List<InterfaceHttpData> responseMultiParts) {
        this.responseMultiParts = responseMultiParts;
        return this;
    }

    public List<InterfaceHttpData> getResponseMultipartParts() {
        return this.responseMultiParts;
    }

    public boolean isAborted() {
        return this.getAbortedWith() != null;
    }

    public Response getAbortedWith() {
        return this.abortedWith;
    }

    public RestClientRequestContext setAbortedWith(Response abortedWith) {
        this.abortedWith = abortedWith;
        return this;
    }

    public boolean isFileUpload() {
        return this.entity != null && (this.entity.getEntity() instanceof File || this.entity.getEntity() instanceof Path);
    }

    public boolean isInputStreamUpload() {
        return this.entity != null && this.entity.getEntity() instanceof InputStream;
    }

    public boolean isMultiBufferUpload() {
        return this.entity != null && this.entity.getEntity() instanceof Multi;
    }

    public boolean isMultipart() {
        return this.entity != null && this.entity.getEntity() instanceof QuarkusMultipartForm;
    }

    public boolean isFileDownload() {
        if (this.responseType == null) {
            return false;
        }
        Class rawType = this.responseType.getRawType();
        return File.class.equals((Object)rawType) || Path.class.equals((Object)rawType);
    }

    public boolean isInputStreamDownload() {
        if (this.responseType == null) {
            return false;
        }
        Class rawType = this.responseType.getRawType();
        return InputStream.class.equals((Object)rawType);
    }

    public String getTmpFilePath() {
        return (String)this.getProperties().get(TMP_FILE_PATH_KEY);
    }

    public void setTmpFilePath(String tmpFilePath) {
        this.getProperties().put(TMP_FILE_PATH_KEY, tmpFilePath);
    }

    public void clearTmpFilePath() {
        this.getProperties().remove(TMP_FILE_PATH_KEY);
    }

    public Map<String, Object> getClientFilterProperties() {
        return this.properties;
    }

    public ClientRestHandler[] getAbortHandlerChainWithoutResponseFilters() {
        return this.abortHandlerChainWithoutResponseFilters;
    }

    public void setCallStatsCollector(ServiceInstance serviceInstance) {
        this.callStatsCollector = serviceInstance;
    }

    public ServiceInstance getCallStatsCollector() {
        return this.callStatsCollector;
    }

    public Map<Class<?>, MultipartResponseData> getMultipartResponsesData() {
        return this.multipartResponsesData;
    }

    public void setMultipartResponsesData(Map<Class<?>, MultipartResponseData> multipartResponsesData) {
        this.multipartResponsesData = multipartResponsesData;
    }

    public StackTraceElement[] getCallerStackTrace() {
        return this.callerStackTrace;
    }

    public void setCallerStackTrace(StackTraceElement[] callerStackTrace) {
        this.callerStackTrace = callerStackTrace;
    }

    private Boolean getBooleanProperty(String name, Boolean defaultValue) {
        Object value = this.configuration.getProperty(name);
        if (value != null) {
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            if (value instanceof String) {
                return Boolean.parseBoolean((String)value);
            }
            log.warnf("Property '%s' is expected to be of type Boolean. Got '%s'.", (Object)name, (Object)value.getClass().getSimpleName());
        }
        return defaultValue;
    }

    protected boolean isRequestScopeManagementRequired() {
        return false;
    }
}

