/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.client.impl;

import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import jakarta.ws.rs.core.MediaType;
import java.nio.charset.StandardCharsets;
import org.jboss.resteasy.reactive.client.impl.InboundSseEventImpl;
import org.jboss.resteasy.reactive.client.impl.NeedsMoreDataException;
import org.jboss.resteasy.reactive.client.impl.SseEventSourceImpl;
import org.jboss.resteasy.reactive.client.impl.WebTargetImpl;

public class SseParser
implements Handler<Buffer> {
    private static final byte CR = 13;
    private static final byte LF = 10;
    private static final byte COLON = 58;
    private static final byte SPACE = 32;
    private byte[] bytes;
    private int i;
    private StringBuffer commentBuffer = new StringBuffer();
    private StringBuffer nameBuffer = new StringBuffer();
    private StringBuffer valueBuffer = new StringBuffer();
    private boolean firstByte = true;
    private boolean startedEvent = false;
    private String eventType;
    private String contentType;
    private String contentTypeHeader;
    private StringBuffer dataBuffer = new StringBuffer();
    private String lastEventId;
    private long eventReconnectTime = -1L;
    private SseEventSourceImpl sseEventSource;

    public SseParser(SseEventSourceImpl sseEventSource, String defaultContentType) {
        this.sseEventSource = sseEventSource;
        this.contentTypeHeader = defaultContentType;
    }

    public void setSseContentTypeHeader(String sseContentTypeHeader) {
        this.contentTypeHeader = sseContentTypeHeader;
    }

    public void handle(Buffer event) {
        byte[] newBytes = event.getBytes();
        event.getByteBuf().release();
        if (this.bytes != null) {
            byte[] totalBytes = new byte[this.bytes.length - this.i + newBytes.length];
            System.arraycopy(this.bytes, this.i, totalBytes, 0, this.bytes.length - this.i);
            System.arraycopy(newBytes, 0, totalBytes, this.bytes.length - this.i, newBytes.length);
            this.bytes = totalBytes;
        } else {
            this.bytes = newBytes;
        }
        this.i = 0;
        while (this.hasByte()) {
            boolean lastFirstByte = this.firstByte;
            this.startedEvent = false;
            this.nameBuffer.setLength(0);
            this.valueBuffer.setLength(0);
            this.commentBuffer.setLength(0);
            this.dataBuffer.setLength(0);
            this.contentType = this.contentTypeHeader;
            this.eventType = null;
            this.eventReconnectTime = -1L;
            boolean needsMoreData = false;
            int lastEventStart = this.i;
            try {
                this.parseEvent();
                if (this.startedEvent) {
                    needsMoreData = true;
                }
            }
            catch (NeedsMoreDataException x) {
                needsMoreData = true;
            }
            if (!needsMoreData) continue;
            this.i = lastEventStart;
            this.firstByte = lastFirstByte;
            return;
        }
        this.bytes = null;
    }

    private void parseEvent() {
        if (this.firstByte && this.i == 0 && 1 < this.bytes.length && this.bytes[0] == -2 && this.bytes[1] == -1) {
            this.i = 2;
        }
        while (this.hasByte()) {
            int c = this.readChar();
            this.firstByte = false;
            if (c == 58) {
                this.startedEvent = true;
                this.parseComment();
                continue;
            }
            if (this.isNameChar(c)) {
                this.startedEvent = true;
                this.parseField(c);
                continue;
            }
            if (this.isEofWithSideEffect(c)) {
                this.dispatchEvent();
                return;
            }
            throw this.illegalEventException();
        }
    }

    private void dispatchEvent() {
        WebTargetImpl webTarget = this.sseEventSource.getWebTarget();
        InboundSseEventImpl event = webTarget != null ? new InboundSseEventImpl(webTarget.getConfiguration(), webTarget.getSerialisers()) : new InboundSseEventImpl(null, null);
        event.setComment(this.commentBuffer.length() == 0 ? null : this.commentBuffer.toString());
        event.setId(this.lastEventId);
        event.setData(this.dataBuffer.length() == 0 ? "" : this.dataBuffer.toString());
        event.setName(this.eventType);
        event.setReconnectDelay(this.eventReconnectTime);
        event.setMediaType(this.contentType != null ? MediaType.valueOf((String)this.contentType) : null);
        this.sseEventSource.fireEvent(event);
        this.startedEvent = false;
    }

    private byte peekByte() {
        return this.bytes[this.i];
    }

    private byte readByte() {
        if (this.i >= this.bytes.length) {
            throw new NeedsMoreDataException();
        }
        return this.bytes[this.i++];
    }

    private boolean hasByte() {
        return this.i < this.bytes.length;
    }

    private void parseComment() {
        int c;
        while (this.isAnyChar(c = this.readChar())) {
            this.commentBuffer.appendCodePoint(c);
        }
        if (this.isEofWithSideEffect(c)) {
            return;
        }
        throw this.illegalEventException();
    }

    private void parseField(int c) {
        boolean readingName = true;
        this.nameBuffer.appendCodePoint(c);
        while (true) {
            if (this.isEofWithSideEffect(c = this.readChar())) {
                this.processField(this.nameBuffer.toString(), this.valueBuffer.toString());
                this.nameBuffer.setLength(0);
                this.valueBuffer.setLength(0);
                return;
            }
            if (readingName && this.isNameChar(c)) {
                this.nameBuffer.appendCodePoint(c);
                continue;
            }
            if (readingName && c == 58) {
                readingName = false;
                if (!this.hasByte() || this.peekByte() != 32) continue;
                ++this.i;
                continue;
            }
            if (readingName || !this.isAnyChar(c)) break;
            this.valueBuffer.appendCodePoint(c);
        }
        throw this.illegalEventException();
    }

    private void processField(String name, String value) {
        switch (name) {
            case "event": {
                this.eventType = value;
                break;
            }
            case "content-type": {
                this.contentType = value;
                break;
            }
            case "data": {
                if (this.dataBuffer.length() > 0) {
                    this.dataBuffer.append('\n');
                }
                this.dataBuffer.append(value);
                break;
            }
            case "id": {
                if (value.indexOf(0) != -1) break;
                this.lastEventId = value;
                break;
            }
            case "retry": {
                try {
                    this.eventReconnectTime = Long.parseUnsignedLong(value, 10);
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    private boolean isEofWithSideEffect(int c) {
        if (c == 13) {
            if (this.hasByte() && this.peekByte() == 10) {
                ++this.i;
            }
            return true;
        }
        return c == 10;
    }

    private boolean isAnyChar(int c) {
        return c >= 0 && c <= 9 || c >= 11 && c <= 12 || c >= 14 && c <= 0x10FFFF;
    }

    private boolean isNameChar(int c) {
        return c >= 0 && c <= 9 || c >= 11 && c <= 12 || c >= 14 && c <= 57 || c >= 59 && c <= 0x10FFFF;
    }

    private int readChar() {
        byte b0 = this.readByte();
        if ((b0 & 0x80) == 0) {
            return b0;
        }
        if ((b0 & 0xE0) == 192) {
            byte b1 = this.readByte();
            if ((b1 & 0xC0) != 128) {
                throw this.utf8Exception();
            }
            return (b0 & 0x1F) << 6 | b1 & 0x3F;
        }
        if ((b0 & 0xF0) == 224) {
            byte b1 = this.readByte();
            if ((b1 & 0xC0) != 128) {
                throw this.utf8Exception();
            }
            byte b2 = this.readByte();
            if ((b2 & 0xC0) != 128) {
                throw this.utf8Exception();
            }
            return (b0 & 0xF) << 12 | (b1 & 0x3F) << 6 | b2 & 0x3F;
        }
        if ((b0 & 0xF8) == 240) {
            byte b1 = this.readByte();
            if ((b1 & 0xC0) != 128) {
                throw this.utf8Exception();
            }
            byte b2 = this.readByte();
            if ((b2 & 0xC0) != 128) {
                throw this.utf8Exception();
            }
            byte b3 = this.readByte();
            if ((b3 & 0xC0) != 128) {
                throw this.utf8Exception();
            }
            return (b0 & 7) << 18 | (b1 & 0x3F) << 12 | (b2 & 0x3F) << 6 | b3 & 0x3F;
        }
        throw this.utf8Exception();
    }

    private IllegalStateException utf8Exception() {
        return new IllegalStateException("Illegal UTF8 input");
    }

    private IllegalStateException illegalEventException() {
        return new IllegalStateException("Illegal Server-Sent Event input at byte index " + this.i + " while parsing: " + new String(this.bytes, StandardCharsets.UTF_8));
    }
}

