/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.client.logging;

import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.client.api.ClientLogger;

public class DefaultClientLogger
implements ClientLogger {
    private static final Logger log = Logger.getLogger(DefaultClientLogger.class);
    private int bodySize;

    @Override
    public void setBodySize(int bodySize) {
        this.bodySize = bodySize;
    }

    @Override
    public void logResponse(final HttpClientResponse response, final boolean redirect) {
        response.bodyHandler((Handler)new Handler<Buffer>(){

            public void handle(Buffer body) {
                log.infof("%s: %s %s, Status[%d %s], Headers[%s], Body:\n%s", new Object[]{redirect ? "Redirect" : "Response", response.request().getMethod(), response.request().absoluteURI(), response.statusCode(), response.statusMessage(), DefaultClientLogger.this.asString(response.headers()), DefaultClientLogger.this.bodyToString(body)});
            }
        });
    }

    @Override
    public void logRequest(HttpClientRequest request, Buffer body, boolean omitBody) {
        if (omitBody) {
            log.infof("Request: %s %s Headers[%s], Body omitted", (Object)request.getMethod(), (Object)request.absoluteURI(), (Object)this.asString(request.headers()));
        } else if (body == null || body.length() == 0) {
            log.infof("Request: %s %s Headers[%s], Empty body", (Object)request.getMethod(), (Object)request.absoluteURI(), (Object)this.asString(request.headers()));
        } else {
            log.infof("Request: %s %s Headers[%s], Body:\n%s", new Object[]{request.getMethod(), request.absoluteURI(), this.asString(request.headers()), this.bodyToString(body)});
        }
    }

    private String bodyToString(Buffer body) {
        if (body == null) {
            return "";
        }
        if (this.bodySize <= 0) {
            return body.toString();
        }
        String bodyAsString = body.toString();
        return bodyAsString.substring(0, Math.min(this.bodySize, bodyAsString.length()));
    }

    private String asString(MultiMap headers) {
        if (headers.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder(headers.size() * 13 + (headers.size() - 1));
        boolean isFirst = true;
        for (Map.Entry entry : headers) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(' ');
            }
            sb.append((String)entry.getKey()).append('=').append((String)entry.getValue());
        }
        return sb.toString();
    }
}

