/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.client.impl.multipart;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.HttpConstants;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.handler.codec.http.multipart.MemoryFileUpload;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.impl.headers.HeadersAdaptor;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.impl.InboundBuffer;
import java.io.File;
import java.nio.charset.Charset;
import org.jboss.resteasy.reactive.client.impl.multipart.MultiByteHttpData;
import org.jboss.resteasy.reactive.client.impl.multipart.PausableHttpPostRequestEncoder;
import org.jboss.resteasy.reactive.client.impl.multipart.QuarkusMultipartForm;
import org.jboss.resteasy.reactive.client.impl.multipart.QuarkusMultipartFormDataPart;

public class QuarkusMultipartFormUpload
implements ReadStream<Buffer>,
Runnable {
    private static final UnpooledByteBufAllocator ALLOC = new UnpooledByteBufAllocator(false);
    private DefaultFullHttpRequest request;
    private PausableHttpPostRequestEncoder encoder;
    private Handler<Throwable> exceptionHandler;
    private Handler<Buffer> dataHandler;
    private Handler<Void> endHandler;
    private boolean ended;
    private final InboundBuffer<Object> pending;
    private final Context context;

    public QuarkusMultipartFormUpload(Context context, QuarkusMultipartForm parts, boolean multipart, int maxChunkSize, PausableHttpPostRequestEncoder.EncoderMode encoderMode) throws Exception {
        this.context = context;
        this.pending = new InboundBuffer(context).handler(this::handleChunk).drainHandler(v -> this.run()).pause();
        this.request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "/");
        final Charset charset = parts.getCharset() != null ? parts.getCharset() : HttpConstants.DEFAULT_CHARSET;
        DefaultHttpDataFactory httpDataFactory = new DefaultHttpDataFactory(-1L, charset){

            public FileUpload createFileUpload(HttpRequest request, String name, String filename, String contentType, String contentTransferEncoding, Charset _charset, long size) {
                if (_charset == null) {
                    _charset = charset;
                }
                return super.createFileUpload(request, name, filename, contentType, contentTransferEncoding, _charset, size);
            }
        };
        this.encoder = new PausableHttpPostRequestEncoder((HttpDataFactory)httpDataFactory, (HttpRequest)this.request, multipart, maxChunkSize, charset, encoderMode);
        for (QuarkusMultipartFormDataPart formDataPart : parts) {
            String contentType;
            if (formDataPart.isAttribute()) {
                this.encoder.addBodyAttribute(formDataPart.name(), formDataPart.value());
                continue;
            }
            if (formDataPart.isObject()) {
                MemoryFileUpload data = new MemoryFileUpload(formDataPart.name(), formDataPart.filename() != null ? formDataPart.filename() : "", formDataPart.mediaType(), formDataPart.isText() ? null : "binary", null, (long)formDataPart.content().length());
                data.setContent(formDataPart.content().getByteBuf());
                this.encoder.addBodyHttpData((InterfaceHttpData)data);
                continue;
            }
            if (formDataPart.multiByteContent() != null) {
                String contentTransferEncoding = null;
                contentType = formDataPart.mediaType();
                if (contentType == null) {
                    contentType = formDataPart.isText() ? "text/plain" : "application/octet-stream";
                }
                if (!formDataPart.isText()) {
                    contentTransferEncoding = "binary";
                }
                this.encoder.addBodyHttpData((InterfaceHttpData)new MultiByteHttpData(formDataPart.name(), formDataPart.filename(), contentType, contentTransferEncoding, Charset.defaultCharset(), formDataPart.multiByteContent(), this::handleError, context, this));
                continue;
            }
            String pathname = formDataPart.pathname();
            if (pathname != null) {
                this.encoder.addBodyFileUpload(formDataPart.name(), formDataPart.filename(), new File(formDataPart.pathname()), formDataPart.mediaType(), formDataPart.isText());
                continue;
            }
            contentType = formDataPart.mediaType();
            if (formDataPart.mediaType() == null) {
                contentType = formDataPart.isText() ? "text/plain" : "application/octet-stream";
            }
            String transferEncoding = formDataPart.isText() ? null : "binary";
            MemoryFileUpload fileUpload = new MemoryFileUpload(formDataPart.name(), formDataPart.filename(), contentType, transferEncoding, null, (long)formDataPart.content().length());
            fileUpload.setContent(formDataPart.content().getByteBuf());
            this.encoder.addBodyHttpData((InterfaceHttpData)fileUpload);
        }
        this.encoder.finalizeRequest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleChunk(Object item) {
        Object handler;
        QuarkusMultipartFormUpload quarkusMultipartFormUpload = this;
        synchronized (quarkusMultipartFormUpload) {
            if (item instanceof Buffer) {
                handler = this.dataHandler;
            } else if (item instanceof Throwable) {
                handler = this.exceptionHandler;
            } else if (item == InboundBuffer.END_SENTINEL) {
                handler = this.endHandler;
                item = null;
            } else {
                return;
            }
        }
        handler.handle(item);
    }

    private void clearEncoder() {
        if (this.encoder == null) {
            return;
        }
        this.encoder.cleanFiles();
        this.encoder = null;
    }

    @Override
    public void run() {
        if (Vertx.currentContext() != this.context) {
            throw new IllegalArgumentException("Wrong Vert.x context used for multipart upload. Expected: " + String.valueOf(this.context) + ", actual: " + String.valueOf(Vertx.currentContext()));
        }
        while (!this.ended) {
            if (this.encoder.isChunked()) {
                try {
                    HttpContent chunk = this.encoder.readChunk((ByteBufAllocator)ALLOC);
                    if (chunk == PausableHttpPostRequestEncoder.WAIT_MARKER) {
                        return;
                    }
                    if (chunk == LastHttpContent.EMPTY_LAST_CONTENT || this.encoder.isEndOfInput()) {
                        this.ended = true;
                        this.request = null;
                        this.clearEncoder();
                        this.pending.write(InboundBuffer.END_SENTINEL);
                        continue;
                    }
                    ByteBuf content = chunk.content();
                    Buffer buff = Buffer.buffer((ByteBuf)content);
                    boolean writable = this.pending.write((Object)buff);
                    if (writable) continue;
                }
                catch (Exception e) {
                    this.handleError(e);
                }
                break;
            }
            ByteBuf content = this.request.content();
            Buffer buffer = Buffer.buffer((ByteBuf)content);
            this.request = null;
            this.clearEncoder();
            this.pending.write((Object)buffer);
            this.ended = true;
            this.pending.write(InboundBuffer.END_SENTINEL);
        }
    }

    public boolean isChunked() {
        return this.encoder.isChunked();
    }

    private void handleError(Throwable e) {
        this.ended = true;
        this.request = null;
        this.clearEncoder();
        this.pending.write((Object)e);
    }

    public MultiMap headers() {
        return new HeadersAdaptor(this.request.headers());
    }

    public synchronized QuarkusMultipartFormUpload exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    public synchronized QuarkusMultipartFormUpload handler(Handler<Buffer> handler) {
        this.dataHandler = handler;
        return this;
    }

    public synchronized QuarkusMultipartFormUpload pause() {
        this.pending.pause();
        return this;
    }

    public ReadStream<Buffer> fetch(long amount) {
        this.pending.fetch(amount);
        return this;
    }

    @Deprecated
    public synchronized QuarkusMultipartFormUpload resume() {
        this.pending.resume();
        return this;
    }

    public synchronized QuarkusMultipartFormUpload endHandler(Handler<Void> handler) {
        this.endHandler = handler;
        return this;
    }
}

