/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.client.impl;

import io.netty.buffer.ByteBuf;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.buffer.impl.VertxByteBufAllocator;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.impl.InboundBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicInteger;

public class InputStreamReadStream
implements ReadStream<Buffer> {
    private static final int MAX_DEPTH = 8;
    private final Buffer endSentinel;
    private final Vertx vertx;
    private final InputStream is;
    private final HttpClientRequest request;
    private final int chunkSize;
    private InboundBuffer<Buffer> inboundBuffer;
    private Handler<Throwable> exceptionHandler;
    private Handler<Void> endHandler;
    private byte[] bytes;
    final ThreadLocal<AtomicInteger> counter = new ThreadLocal<AtomicInteger>(){

        @Override
        protected AtomicInteger initialValue() {
            return new AtomicInteger();
        }
    };

    public InputStreamReadStream(Vertx vertx, InputStream is, HttpClientRequest request, int chunkSize) {
        this.vertx = vertx;
        this.is = is;
        this.request = request;
        this.chunkSize = chunkSize;
        this.endSentinel = Buffer.buffer();
    }

    public ReadStream<Buffer> exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    public ReadStream<Buffer> handler(final Handler<Buffer> handler) {
        boolean start;
        boolean bl = start = this.inboundBuffer == null && handler != null;
        if (start) {
            this.inboundBuffer = new InboundBuffer(this.vertx.getOrCreateContext());
            this.inboundBuffer.drainHandler((Handler)new Handler<Void>(){

                public void handle(Void event) {
                    InputStreamReadStream.this.readChunk();
                }
            });
        }
        if (handler != null) {
            this.inboundBuffer.handler((Handler)new Handler<Buffer>(){

                public void handle(Buffer buff) {
                    if (buff == InputStreamReadStream.this.endSentinel) {
                        if (InputStreamReadStream.this.endHandler != null) {
                            InputStreamReadStream.this.endHandler.handle(null);
                        }
                    } else {
                        handler.handle((Object)buff);
                    }
                }
            });
        } else {
            this.inboundBuffer.handler(null);
        }
        if (start) {
            this.readChunk();
        }
        return this;
    }

    private void readChunk() {
        AtomicInteger atomicInteger = this.counter.get();
        try {
            int depth = atomicInteger.getAndIncrement();
            if (depth < 8) {
                this.readChunk2();
                return;
            }
        }
        finally {
            atomicInteger.decrementAndGet();
        }
        this.vertx.runOnContext(v -> this.readChunk());
    }

    private void readChunk2() {
        Future fut = this.vertx.executeBlocking((Handler)new Handler<Promise<Buffer>>(){

            public void handle(Promise<Buffer> p) {
                int amount;
                if (InputStreamReadStream.this.bytes == null) {
                    InputStreamReadStream.this.bytes = new byte[InputStreamReadStream.this.chunkSize];
                }
                try {
                    amount = InputStreamReadStream.this.is.read(InputStreamReadStream.this.bytes);
                }
                catch (IOException e) {
                    p.fail((Throwable)e);
                    return;
                }
                if (amount == -1) {
                    p.complete();
                } else {
                    p.complete((Object)Buffer.buffer((ByteBuf)VertxByteBufAllocator.DEFAULT.heapBuffer(amount, Integer.MAX_VALUE).writeBytes(InputStreamReadStream.this.bytes, 0, amount)));
                }
            }
        });
        fut.onComplete((Handler)new Handler<AsyncResult<Buffer>>(){

            public void handle(AsyncResult<Buffer> ar) {
                if (ar.succeeded()) {
                    Buffer chunk = (Buffer)ar.result();
                    if (chunk != null) {
                        boolean writable = InputStreamReadStream.this.inboundBuffer.write((Object)chunk);
                        if (writable) {
                            InputStreamReadStream.this.readChunk();
                        }
                    } else {
                        InputStreamReadStream.this.inboundBuffer.write((Object)InputStreamReadStream.this.endSentinel);
                    }
                } else {
                    if (InputStreamReadStream.this.exceptionHandler != null) {
                        InputStreamReadStream.this.exceptionHandler.handle((Object)ar.cause());
                    }
                    InputStreamReadStream.this.request.reset(0L, ar.cause());
                }
            }
        });
    }

    public ReadStream<Buffer> endHandler(Handler<Void> handler) {
        this.endHandler = handler;
        return this;
    }

    public ReadStream<Buffer> pause() {
        this.inboundBuffer.pause();
        return this;
    }

    public ReadStream<Buffer> resume() {
        this.inboundBuffer.resume();
        return this;
    }

    public ReadStream<Buffer> fetch(long amount) {
        this.inboundBuffer.fetch(amount);
        return this;
    }
}

