/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.client.impl;

import io.smallrye.mutiny.Multi;
import io.smallrye.stork.Stork;
import io.smallrye.stork.api.ServiceInstance;
import jakarta.annotation.Priority;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.ext.Provider;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.client.spi.ResteasyReactiveClientRequestContext;
import org.jboss.resteasy.reactive.client.spi.ResteasyReactiveClientRequestFilter;

@Priority(value=1000)
@Provider
public class StorkClientRequestFilter
implements ResteasyReactiveClientRequestFilter {
    private static final Logger log = Logger.getLogger(StorkClientRequestFilter.class);
    private final Stork stork;

    public StorkClientRequestFilter() {
        try {
            this.stork = Stork.getInstance();
            if (this.stork == null) {
                throw new IllegalStateException("Trying to use a StorkClientRequestFilter but the quarkus-smallrye-stork extension is missing, please add the extension.");
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Trying to use a StorkClientRequestFilter but the quarkus-smallrye-stork extension is missing, please add the extension.");
        }
    }

    @Override
    public void filter(ResteasyReactiveClientRequestContext requestContext) {
        URI uri = requestContext.getUri();
        if (uri != null && uri.getScheme() != null && uri.getScheme().startsWith("stork")) {
            String serviceName = uri.getHost();
            if (serviceName == null) {
                throw new IllegalArgumentException("Invalid REST Client URL used: '" + String.valueOf(uri) + "'");
            }
            requestContext.suspend();
            boolean measureTime = this.shouldMeasureTime(requestContext.getResponseType());
            try {
                this.stork.getService(serviceName).selectInstanceAndRecordStart(measureTime).subscribe().with(instance -> {
                    boolean isHttps = instance.isSecure() || "storks".equals(uri.getScheme());
                    String scheme = isHttps ? "https" : "http";
                    try {
                        String host = instance.getHost() == null ? "localhost" : instance.getHost();
                        int port = instance.getPort();
                        if (instance.getPort() == 0) {
                            port = isHttps ? 433 : 80;
                        }
                        Optional path = instance.getPath();
                        Object actualPath = uri.getRawPath();
                        if (path.isPresent()) {
                            Object p = (String)path.get();
                            if (!((String)p).startsWith("/")) {
                                p = "/" + (String)p;
                            }
                            actualPath = actualPath == null ? p : (((String)actualPath).startsWith("/") || ((String)p).endsWith("/") ? (String)p + (String)actualPath : (String)p + "/" + (String)actualPath);
                        }
                        URI newUri = new URI(scheme, uri.getUserInfo(), host, port, null, uri.getQuery(), uri.getFragment());
                        URI build = UriBuilder.fromUri((URI)newUri).path((String)actualPath).build(new Object[0]);
                        requestContext.setUri(build);
                        if (measureTime && instance.gatherStatistics()) {
                            requestContext.setCallStatsCollector((ServiceInstance)instance);
                        }
                        requestContext.resume();
                    }
                    catch (URISyntaxException e) {
                        requestContext.resume(new IllegalArgumentException("Invalid URI", e));
                    }
                }, requestContext::resume);
            }
            catch (Throwable e) {
                log.error((Object)("Error selecting service instance for serviceName: " + serviceName), e);
                requestContext.resume(e);
            }
        }
    }

    private boolean shouldMeasureTime(GenericType<?> responseType) {
        return !Multi.class.equals((Object)responseType.getRawType());
    }
}

