/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.websockets.next.runtime;

import io.quarkus.runtime.BlockingOperationControl;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.spi.runtime.AbstractSecurityIdentityAssociation;
import io.quarkus.vertx.http.runtime.security.DuplicatedContextSecurityIdentityAssociation;
import io.quarkus.websockets.next.runtime.ContextSupport;
import io.quarkus.websockets.next.runtime.SecuritySupport;
import io.quarkus.websockets.next.runtime.WebSocketConnectionImpl;
import io.smallrye.common.vertx.VertxContext;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@RequestScoped
public class WebSocketSecurityIdentityAssociation
implements CurrentIdentityAssociation {
    private final AbstractSecurityIdentityAssociation delegate;
    private volatile boolean userChangedIdentity = false;

    @Inject
    WebSocketSecurityIdentityAssociation(final IdentityProviderManager identityProviderManager, @ConfigProperty(name="quarkus.http.auth.propagate-security-identity") boolean identityPropagationEnabled) {
        this.delegate = identityPropagationEnabled ? new DuplicatedContextSecurityIdentityAssociation().setIdentityProviderManager(identityProviderManager) : new AbstractSecurityIdentityAssociation(){

            protected IdentityProviderManager getIdentityProviderManager() {
                return identityProviderManager;
            }
        };
    }

    public Uni<SecurityIdentity> getDeferredIdentity() {
        if (this.userChangedIdentity) {
            return this.delegate.getDeferredIdentity();
        }
        SecuritySupport securitySupport = WebSocketSecurityIdentityAssociation.getSecuritySupportFromCtx();
        if (securitySupport != null) {
            if (securitySupport.getIdentity() != null) {
                return Uni.createFrom().item((Object)securitySupport.getIdentity());
            }
            Uni<SecurityIdentity> deferredIdentity = securitySupport.getDeferredIdentity();
            if (deferredIdentity != null) {
                return deferredIdentity.onItem().ifNull().switchTo(() -> ((AbstractSecurityIdentityAssociation)this.delegate).getDeferredIdentity());
            }
        }
        return this.delegate.getDeferredIdentity();
    }

    public void setIdentity(SecurityIdentity securityIdentity) {
        this.userChangedIdentity = true;
        this.delegate.setIdentity(securityIdentity);
    }

    public void setIdentity(Uni<SecurityIdentity> uni) {
        this.userChangedIdentity = true;
        this.delegate.setIdentity(uni);
    }

    public SecurityIdentity getIdentity() {
        if (this.userChangedIdentity) {
            return this.delegate.getIdentity();
        }
        SecuritySupport securitySupport = WebSocketSecurityIdentityAssociation.getSecuritySupportFromCtx();
        if (securitySupport != null) {
            SecurityIdentity resolvedIdentity;
            Uni<SecurityIdentity> deferredIdentity;
            if (securitySupport.getIdentity() != null) {
                return securitySupport.getIdentity();
            }
            if (BlockingOperationControl.isBlockingAllowed() && (deferredIdentity = securitySupport.getDeferredIdentity()) != null && (resolvedIdentity = (SecurityIdentity)deferredIdentity.await().indefinitely()) != null) {
                return resolvedIdentity;
            }
        }
        return this.delegate.getIdentity();
    }

    private static SecuritySupport getSecuritySupportFromCtx() {
        Object object;
        Context context = Vertx.currentContext();
        if (context != null && VertxContext.isDuplicatedContext((Context)context) && (object = context.getLocal((Object)ContextSupport.WEB_SOCKET_CONN_KEY)) instanceof WebSocketConnectionImpl) {
            WebSocketConnectionImpl connection = (WebSocketConnectionImpl)object;
            return connection.securitySupport();
        }
        return null;
    }
}

