/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.websockets.next.runtime;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.quarkus.arc.ClientProxy;
import io.quarkus.security.ForbiddenException;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.spi.runtime.AuthorizationFailureEvent;
import io.quarkus.security.spi.runtime.AuthorizationSuccessEvent;
import io.quarkus.security.spi.runtime.MethodDescription;
import io.quarkus.security.spi.runtime.SecurityCheck;
import io.quarkus.security.spi.runtime.SecurityEvent;
import io.quarkus.security.spi.runtime.SecurityEventHelper;
import io.quarkus.vertx.http.runtime.security.HttpSecurityPolicy;
import io.quarkus.vertx.http.runtime.security.QuarkusHttpUser;
import io.quarkus.websockets.next.HttpUpgradeCheck;
import io.quarkus.websockets.next.runtime.HttpUpgradeContextImpl;
import io.smallrye.mutiny.Uni;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.RoutingContext;
import java.util.List;
import java.util.Map;

public final class SecurityHttpUpgradeCheck
implements HttpUpgradeCheck {
    public static final int BEAN_PRIORITY = 2147483547;
    public static final String SECURED_ENDPOINT_ID_KEY = SecurityHttpUpgradeCheck.class.getName() + ".ENDPOINT_ID";
    public static final String HTTP_REQUEST_KEY = SecurityHttpUpgradeCheck.class.getName() + ".HTTP_REQUEST";
    private final String redirectUrl;
    private final Map<String, SecurityCheck> endpointToCheck;
    private final Map<String, HttpSecurityPolicy> endpointToPolicy;
    private final SecurityEventHelper<AuthorizationSuccessEvent, AuthorizationFailureEvent> securityEventHelper;
    private final HttpSecurityPolicy.AuthorizationRequestContext authorizationRequestContext;

    SecurityHttpUpgradeCheck(String redirectUrl, Map<String, SecurityCheck> endpointToCheck, SecurityEventHelper<AuthorizationSuccessEvent, AuthorizationFailureEvent> securityEventHelper, Map<String, HttpSecurityPolicy> endpointToPolicy, HttpSecurityPolicy.AuthorizationRequestContext authorizationRequestContext) {
        this.redirectUrl = redirectUrl;
        this.endpointToCheck = Map.copyOf(endpointToCheck);
        this.securityEventHelper = securityEventHelper;
        this.authorizationRequestContext = authorizationRequestContext;
        this.endpointToPolicy = Map.copyOf(endpointToPolicy);
    }

    @Override
    public Uni<HttpUpgradeCheck.CheckResult> perform(HttpUpgradeCheck.HttpUpgradeContext context) {
        SecurityCheck securityCheck = this.endpointToCheck.get(context.endpointId());
        HttpSecurityPolicy httpSecurityPolicy = this.endpointToPolicy.get(context.endpointId());
        if (httpSecurityPolicy != null) {
            if (securityCheck != null) {
                return HttpUpgradeCheck.CheckResult.rejectUpgrade(403);
            }
            if (context instanceof HttpUpgradeContextImpl) {
                HttpUpgradeContextImpl impl = (HttpUpgradeContextImpl)context;
                return httpSecurityPolicy.checkPermission(impl.routingContext(), context.securityIdentity(), this.authorizationRequestContext).onItemOrFailure().transform((checkResult, throwable) -> {
                    SecurityIdentity securityIdentity;
                    if (checkResult == null) {
                        return this.rejectUpgrade((Throwable)throwable, SecurityHttpUpgradeCheck.getSecurityIdentity(impl), SecurityHttpUpgradeCheck.getHttpSecurityPolicyClass(httpSecurityPolicy), context);
                    }
                    if (checkResult.getAugmentedIdentity() != null) {
                        securityIdentity = checkResult.getAugmentedIdentity();
                        QuarkusHttpUser.setIdentity((SecurityIdentity)securityIdentity, (RoutingContext)impl.routingContext());
                    } else {
                        securityIdentity = SecurityHttpUpgradeCheck.getSecurityIdentity(impl);
                    }
                    if (checkResult.isPermitted()) {
                        return this.permitUpgrade(securityIdentity, SecurityHttpUpgradeCheck.getHttpSecurityPolicyClass(httpSecurityPolicy), context);
                    }
                    return this.rejectUpgrade((Throwable)throwable, securityIdentity, SecurityHttpUpgradeCheck.getHttpSecurityPolicyClass(httpSecurityPolicy), context);
                });
            }
            return HttpUpgradeCheck.CheckResult.rejectUpgrade(403);
        }
        if (securityCheck == null) {
            return HttpUpgradeCheck.CheckResult.rejectUpgrade(403);
        }
        return context.securityIdentity().chain(identity -> securityCheck.nonBlockingApply(identity, (MethodDescription)null, null).replaceWith(() -> this.permitUpgrade((SecurityIdentity)identity, securityCheck, context)).onFailure(SecurityException.class).recoverWithItem(t -> this.rejectUpgrade((Throwable)t, (SecurityIdentity)identity, securityCheck, context)));
    }

    @Override
    public boolean appliesTo(String endpointId) {
        return this.endpointToCheck.containsKey(endpointId) || this.endpointToPolicy.containsKey(endpointId);
    }

    private HttpUpgradeCheck.CheckResult permitUpgrade(SecurityIdentity identity, Object authorizationCheck, HttpUpgradeCheck.HttpUpgradeContext context) {
        if (this.securityEventHelper.fireEventOnSuccess()) {
            String authorizationContext = authorizationCheck.getClass().getName();
            AuthorizationSuccessEvent successEvent = new AuthorizationSuccessEvent(identity, authorizationContext, Map.of(SECURED_ENDPOINT_ID_KEY, context.endpointId(), HTTP_REQUEST_KEY, context.httpRequest()));
            this.securityEventHelper.fireSuccessEvent((SecurityEvent)successEvent);
        }
        return HttpUpgradeCheck.CheckResult.permitUpgradeSync();
    }

    private HttpUpgradeCheck.CheckResult rejectUpgrade(Throwable throwable, SecurityIdentity identity, Object authorizationCheck, HttpUpgradeCheck.HttpUpgradeContext context) {
        if (this.securityEventHelper.fireEventOnFailure()) {
            String authorizationContext = authorizationCheck.getClass().getName();
            AuthorizationFailureEvent failureEvent = new AuthorizationFailureEvent(identity, throwable, authorizationContext, Map.of(SECURED_ENDPOINT_ID_KEY, context.endpointId(), HTTP_REQUEST_KEY, context.httpRequest()));
            this.securityEventHelper.fireFailureEvent((SecurityEvent)failureEvent);
        }
        if (this.redirectUrl != null) {
            return HttpUpgradeCheck.CheckResult.rejectUpgradeSync(302, Map.of(HttpHeaderNames.LOCATION.toString(), List.of(this.redirectUrl), HttpHeaderNames.CACHE_CONTROL.toString(), List.of("no-store")));
        }
        if (throwable instanceof ForbiddenException || identity != null && !identity.isAnonymous()) {
            return HttpUpgradeCheck.CheckResult.rejectUpgradeSync(403);
        }
        return HttpUpgradeCheck.CheckResult.rejectUpgradeSync(401);
    }

    private static SecurityIdentity getSecurityIdentity(HttpUpgradeContextImpl impl) {
        User user = impl.routingContext().user();
        if (user instanceof QuarkusHttpUser) {
            QuarkusHttpUser user2 = (QuarkusHttpUser)user;
            return user2.getSecurityIdentity();
        }
        return null;
    }

    private static String getHttpSecurityPolicyClass(HttpSecurityPolicy httpSecurityPolicy) {
        return ((HttpSecurityPolicy)ClientProxy.unwrap((Object)httpSecurityPolicy)).getClass().getName();
    }
}

