/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.websockets.next.runtime;

import io.quarkus.websockets.next.HandshakeRequest;
import io.quarkus.websockets.next.WebSocketClientConnection;
import io.quarkus.websockets.next.runtime.Codecs;
import io.quarkus.websockets.next.runtime.TrafficLogger;
import io.quarkus.websockets.next.runtime.UserDataImpl;
import io.quarkus.websockets.next.runtime.WebSocketConnectionBase;
import io.quarkus.websockets.next.runtime.telemetry.SendingInterceptor;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebSocketBase;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

class WebSocketClientConnectionImpl
extends WebSocketConnectionBase
implements WebSocketClientConnection {
    private final String clientId;
    private final WebSocket webSocket;
    private final Consumer<WebSocketClientConnection> cleanup;

    WebSocketClientConnectionImpl(String clientId, WebSocket webSocket, Codecs codecs, Map<String, String> pathParams, URI serverEndpointUri, Map<String, List<String>> headers, TrafficLogger trafficLogger, Map<String, Object> userData, SendingInterceptor sendingInterceptor, Consumer<WebSocketClientConnection> cleanup) {
        super(Map.copyOf(pathParams), codecs, new ClientHandshakeRequestImpl(serverEndpointUri, Objects.requireNonNull(webSocket), headers), trafficLogger, new UserDataImpl(userData), sendingInterceptor);
        this.clientId = clientId;
        this.webSocket = webSocket;
        this.cleanup = cleanup;
    }

    @Override
    WebSocketBase webSocket() {
        return this.webSocket;
    }

    @Override
    public String clientId() {
        return this.clientId;
    }

    public String toString() {
        return "WebSocket client connection [id=" + this.identifier + ", clientId=" + this.clientId + "]";
    }

    public int hashCode() {
        return Objects.hash(this.identifier);
    }

    protected void cleanup() {
        if (this.cleanup != null) {
            this.cleanup.accept(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WebSocketClientConnectionImpl other = (WebSocketClientConnectionImpl)obj;
        return Objects.equals(this.identifier, other.identifier);
    }

    private static class ClientHandshakeRequestImpl
    extends WebSocketConnectionBase.HandshakeRequestBase
    implements HandshakeRequest {
        private final URI serverEndpointUrl;
        private final WebSocket webSocket;
        private final Map<String, List<String>> headers;

        ClientHandshakeRequestImpl(URI serverEndpointUrl, WebSocket webSocket, Map<String, List<String>> headers) {
            this.serverEndpointUrl = serverEndpointUrl;
            this.webSocket = webSocket;
            HashMap<String, List<String>> copy = new HashMap<String, List<String>>();
            for (Map.Entry<String, List<String>> e : headers.entrySet()) {
                copy.put(e.getKey().toLowerCase(), List.copyOf((Collection)e.getValue()));
            }
            this.headers = copy;
        }

        @Override
        public String header(String name) {
            List<String> values = this.headers(name);
            return values.isEmpty() ? null : values.get(0);
        }

        @Override
        public List<String> headers(String name) {
            return this.headers.getOrDefault(Objects.requireNonNull(name).toLowerCase(), List.of());
        }

        @Override
        public Map<String, List<String>> headers() {
            return this.headers;
        }

        @Override
        public String scheme() {
            return this.serverEndpointUrl.getScheme();
        }

        @Override
        public String host() {
            return this.serverEndpointUrl.getHost();
        }

        @Override
        public int port() {
            return this.serverEndpointUrl.getPort();
        }

        @Override
        public String path() {
            return this.serverEndpointUrl.getPath();
        }

        @Override
        public String query() {
            return this.serverEndpointUrl.getQuery();
        }

        @Override
        public String localAddress() {
            return this.formatSocketAddress(this.webSocket.localAddress());
        }

        @Override
        public String remoteAddress() {
            return this.formatSocketAddress(this.webSocket.remoteAddress());
        }
    }
}

