/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.websockets.next.runtime.telemetry;

import io.quarkus.websockets.next.runtime.WebSocketConnectionBase;
import io.quarkus.websockets.next.runtime.WebSocketEndpoint;
import io.quarkus.websockets.next.runtime.telemetry.ConnectionInterceptor;
import io.quarkus.websockets.next.runtime.telemetry.ErrorInterceptor;
import io.quarkus.websockets.next.runtime.telemetry.SendingInterceptor;
import io.quarkus.websockets.next.runtime.telemetry.TelemetrySupport;
import io.quarkus.websockets.next.runtime.telemetry.TelemetryWebSocketEndpointContext;
import java.util.function.Function;

public final class WebSocketTelemetryProvider {
    private final Function<TelemetryWebSocketEndpointContext, WebSocketEndpoint> serverEndpointDecorator;
    private final Function<TelemetryWebSocketEndpointContext, WebSocketEndpoint> clientEndpointDecorator;
    private final Function<String, ConnectionInterceptor> pathToClientConnectionInterceptor;
    private final Function<String, ConnectionInterceptor> pathToServerConnectionInterceptor;
    private final Function<String, SendingInterceptor> pathToClientSendingInterceptor;
    private final Function<String, SendingInterceptor> pathToServerSendingInterceptor;
    private final Function<String, ErrorInterceptor> pathToClientErrorInterceptor;
    private final Function<String, ErrorInterceptor> pathToServerErrorInterceptor;
    private final boolean clientTelemetryEnabled;
    private final boolean serverTelemetryEnabled;

    WebSocketTelemetryProvider(Function<TelemetryWebSocketEndpointContext, WebSocketEndpoint> serverEndpointDecorator, Function<TelemetryWebSocketEndpointContext, WebSocketEndpoint> clientEndpointDecorator, Function<String, ConnectionInterceptor> pathToClientConnectionInterceptor, Function<String, ConnectionInterceptor> pathToServerConnectionInterceptor, Function<String, SendingInterceptor> pathToClientSendingInterceptor, Function<String, SendingInterceptor> pathToServerSendingInterceptor, Function<String, ErrorInterceptor> pathToClientErrorInterceptor, Function<String, ErrorInterceptor> pathToServerErrorInterceptor) {
        this.serverTelemetryEnabled = serverEndpointDecorator != null || pathToServerConnectionInterceptor != null || pathToServerSendingInterceptor != null || pathToServerErrorInterceptor != null;
        this.serverEndpointDecorator = serverEndpointDecorator;
        this.pathToServerConnectionInterceptor = pathToServerConnectionInterceptor;
        this.clientTelemetryEnabled = clientEndpointDecorator != null || pathToClientConnectionInterceptor != null || pathToClientSendingInterceptor != null || pathToClientErrorInterceptor != null;
        this.clientEndpointDecorator = clientEndpointDecorator;
        this.pathToClientConnectionInterceptor = pathToClientConnectionInterceptor;
        this.pathToClientSendingInterceptor = pathToClientSendingInterceptor;
        this.pathToServerSendingInterceptor = pathToServerSendingInterceptor;
        this.pathToClientErrorInterceptor = pathToClientErrorInterceptor;
        this.pathToServerErrorInterceptor = pathToServerErrorInterceptor;
    }

    public TelemetrySupport createServerTelemetrySupport(final String path) {
        if (this.serverTelemetryEnabled) {
            return new TelemetrySupport(this.getServerConnectionInterceptor(path), this.getServerSendingInterceptor(path), this.getServerErrorInterceptor(path)){

                @Override
                public WebSocketEndpoint decorate(WebSocketEndpoint endpoint, WebSocketConnectionBase connection) {
                    if (WebSocketTelemetryProvider.this.serverEndpointDecorator == null) {
                        return endpoint;
                    }
                    return WebSocketTelemetryProvider.this.serverEndpointDecorator.apply(new TelemetryWebSocketEndpointContext(endpoint, connection, path, this.getContextData()));
                }
            };
        }
        return null;
    }

    public TelemetrySupport createClientTelemetrySupport(final String path) {
        if (this.clientTelemetryEnabled) {
            return new TelemetrySupport(this.getClientConnectionInterceptor(path), this.getClientSendingInterceptor(path), this.getClientErrorInterceptor(path)){

                @Override
                public WebSocketEndpoint decorate(WebSocketEndpoint endpoint, WebSocketConnectionBase connection) {
                    if (WebSocketTelemetryProvider.this.clientEndpointDecorator == null) {
                        return endpoint;
                    }
                    return WebSocketTelemetryProvider.this.clientEndpointDecorator.apply(new TelemetryWebSocketEndpointContext(endpoint, connection, path, this.getContextData()));
                }
            };
        }
        return null;
    }

    private ConnectionInterceptor getServerConnectionInterceptor(String path) {
        return this.pathToServerConnectionInterceptor == null ? null : this.pathToServerConnectionInterceptor.apply(path);
    }

    private ConnectionInterceptor getClientConnectionInterceptor(String path) {
        return this.pathToClientConnectionInterceptor == null ? null : this.pathToClientConnectionInterceptor.apply(path);
    }

    private ErrorInterceptor getServerErrorInterceptor(String path) {
        return this.pathToServerErrorInterceptor == null ? null : this.pathToServerErrorInterceptor.apply(path);
    }

    private SendingInterceptor getServerSendingInterceptor(String path) {
        return this.pathToServerSendingInterceptor == null ? null : this.pathToServerSendingInterceptor.apply(path);
    }

    private ErrorInterceptor getClientErrorInterceptor(String path) {
        return this.pathToClientErrorInterceptor == null ? null : this.pathToClientErrorInterceptor.apply(path);
    }

    private SendingInterceptor getClientSendingInterceptor(String path) {
        return this.pathToClientSendingInterceptor == null ? null : this.pathToClientSendingInterceptor.apply(path);
    }
}

