/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.websockets.next.runtime;

import io.quarkus.runtime.annotations.RecordableConstructor;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.websockets.next.WebSocketClientException;
import io.quarkus.websockets.next.runtime.ContextSupport;
import io.smallrye.common.vertx.VertxContext;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import java.util.Map;
import java.util.function.Supplier;

@Recorder
public class WebSocketClientRecorder {
    public Supplier<Object> connectionSupplier() {
        return new Supplier<Object>(){

            @Override
            public Object get() {
                Object connection;
                Context context = Vertx.currentContext();
                if (context != null && VertxContext.isDuplicatedContext((Context)context) && (connection = context.getLocal((Object)ContextSupport.WEB_SOCKET_CONN_KEY)) != null) {
                    return connection;
                }
                throw new WebSocketClientException("Unable to obtain the connection from the Vert.x duplicated context");
            }
        };
    }

    public Supplier<Object> createContext(final Map<String, ClientEndpoint> endpointMap) {
        return new Supplier<Object>(){

            @Override
            public Object get() {
                return new ClientEndpointsContext(){

                    @Override
                    public ClientEndpoint endpoint(String endpointClass) {
                        return (ClientEndpoint)endpointMap.get(endpointClass);
                    }
                };
            }
        };
    }

    public static class ClientEndpoint {
        public final String clientId;
        public final String path;
        public final String generatedEndpointClass;

        @RecordableConstructor
        public ClientEndpoint(String clientId, String path, String generatedEndpointClass) {
            this.clientId = clientId;
            this.path = path;
            this.generatedEndpointClass = generatedEndpointClass;
        }
    }

    public static interface ClientEndpointsContext {
        public ClientEndpoint endpoint(String var1);
    }
}

