/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.websockets.next.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InjectableInstance;
import io.quarkus.arc.SyntheticCreationalContext;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.spi.runtime.AuthorizationFailureEvent;
import io.quarkus.security.spi.runtime.AuthorizationSuccessEvent;
import io.quarkus.security.spi.runtime.SecurityCheck;
import io.quarkus.security.spi.runtime.SecurityEvent;
import io.quarkus.security.spi.runtime.SecurityEventHelper;
import io.quarkus.vertx.core.runtime.VertxCoreRecorder;
import io.quarkus.vertx.http.runtime.security.EagerSecurityInterceptorStorage;
import io.quarkus.vertx.http.runtime.security.QuarkusHttpUser;
import io.quarkus.websockets.next.HttpUpgradeCheck;
import io.quarkus.websockets.next.WebSocketServerException;
import io.quarkus.websockets.next.runtime.Codecs;
import io.quarkus.websockets.next.runtime.ConnectionManager;
import io.quarkus.websockets.next.runtime.ContextSupport;
import io.quarkus.websockets.next.runtime.Endpoints;
import io.quarkus.websockets.next.runtime.HttpUpgradeContextImpl;
import io.quarkus.websockets.next.runtime.HttpUpgradeSecurityInterceptor;
import io.quarkus.websockets.next.runtime.SecurityHttpUpgradeCheck;
import io.quarkus.websockets.next.runtime.SecuritySupport;
import io.quarkus.websockets.next.runtime.TrafficLogger;
import io.quarkus.websockets.next.runtime.WebSocketConnectionImpl;
import io.quarkus.websockets.next.runtime.config.WebSocketsServerRuntimeConfig;
import io.quarkus.websockets.next.runtime.telemetry.SendingInterceptor;
import io.quarkus.websockets.next.runtime.telemetry.TelemetrySupport;
import io.quarkus.websockets.next.runtime.telemetry.WebSocketTelemetryProvider;
import io.smallrye.common.vertx.VertxContext;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.WebSocketBase;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.util.TypeLiteral;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;

@Recorder
public class WebSocketServerRecorder {
    private static final Logger LOG = Logger.getLogger(WebSocketServerRecorder.class);

    public Supplier<Object> connectionSupplier() {
        return new Supplier<Object>(){

            @Override
            public Object get() {
                Object connection;
                Context context = Vertx.currentContext();
                if (context != null && VertxContext.isDuplicatedContext((Context)context) && (connection = context.getLocal((Object)ContextSupport.WEB_SOCKET_CONN_KEY)) != null) {
                    return connection;
                }
                throw new WebSocketServerException("Unable to obtain the connection from the Vert.x duplicated context");
            }
        };
    }

    public Handler<RoutingContext> createEndpointHandler(final String generatedEndpointClass, final String endpointId, final boolean activateRequestContext, final boolean activateSessionContext, final String endpointPath, final WebSocketsServerRuntimeConfig config) {
        final ArcContainer container = Arc.container();
        final ConnectionManager connectionManager = (ConnectionManager)container.instance(ConnectionManager.class, new Annotation[0]).get();
        final Codecs codecs = (Codecs)container.instance(Codecs.class, new Annotation[0]).get();
        final HttpUpgradeCheck[] httpUpgradeChecks = WebSocketServerRecorder.getHttpUpgradeChecks(endpointId, container);
        final TrafficLogger trafficLogger = TrafficLogger.forServer(config);
        final WebSocketTelemetryProvider telemetryProvider = (WebSocketTelemetryProvider)container.instance(WebSocketTelemetryProvider.class, new Annotation[0]).orElse(null);
        return new Handler<RoutingContext>(){

            public void handle(RoutingContext ctx) {
                if (ctx.request().headers().contains("Sec-WebSocket-Key")) {
                    if (httpUpgradeChecks != null) {
                        this.checkHttpUpgrade(ctx, endpointId).subscribe().with(result -> {
                            if (!result.getResponseHeaders().isEmpty()) {
                                result.getResponseHeaders().forEach((k, v) -> ctx.response().putHeader(k, (Iterable)v));
                            }
                            if (result.isUpgradePermitted()) {
                                this.httpUpgrade(ctx);
                            } else {
                                ctx.response().setStatusCode(result.getHttpResponseCode()).end();
                            }
                        }, arg_0 -> ((RoutingContext)ctx).fail(arg_0));
                    } else {
                        this.httpUpgrade(ctx);
                    }
                } else {
                    LOG.debugf("Non-websocket client request ignored:\n%s", (Object)ctx.request().headers());
                    ctx.next();
                }
            }

            private void httpUpgrade(RoutingContext ctx) {
                Future future;
                TelemetrySupport telemetrySupport;
                TelemetrySupport telemetrySupport2 = telemetrySupport = telemetryProvider == null ? null : telemetryProvider.createServerTelemetrySupport(endpointPath);
                if (telemetrySupport != null && telemetrySupport.interceptConnection()) {
                    telemetrySupport.connectionOpened();
                    future = ctx.request().toWebSocket().onFailure((Handler)new Handler<Throwable>(){

                        public void handle(Throwable throwable) {
                            telemetrySupport.connectionOpeningFailed(throwable);
                        }
                    });
                } else {
                    future = ctx.request().toWebSocket();
                }
                future.onSuccess(ws -> {
                    Vertx vertx = (Vertx)VertxCoreRecorder.getVertx().get();
                    SendingInterceptor sendingInterceptor = telemetrySupport == null ? null : telemetrySupport.getSendingInterceptor();
                    WebSocketConnectionImpl connection = new WebSocketConnectionImpl(generatedEndpointClass, endpointId, (ServerWebSocket)ws, connectionManager, codecs, ctx, trafficLogger, sendingInterceptor);
                    connectionManager.add(generatedEndpointClass, connection);
                    if (trafficLogger != null) {
                        trafficLogger.connectionOpened(connection);
                    }
                    SecuritySupport securitySupport = WebSocketServerRecorder.this.initializeSecuritySupport(container, ctx, vertx, connection);
                    Endpoints.initialize(vertx, container, codecs, connection, (WebSocketBase)ws, generatedEndpointClass, config.autoPingInterval(), securitySupport, config.unhandledFailureStrategy(), trafficLogger, () -> connectionManager.remove(generatedEndpointClass, connection), activateRequestContext, activateSessionContext, telemetrySupport);
                });
            }

            private Uni<HttpUpgradeCheck.CheckResult> checkHttpUpgrade(RoutingContext ctx, String endpointId2) {
                QuarkusHttpUser user = (QuarkusHttpUser)ctx.user();
                Uni identity = user == null ? (Uni)ctx.get("io.quarkus.vertx.http.deferred-identity") : Uni.createFrom().item((Object)user.getSecurityIdentity());
                return 2.checkHttpUpgrade(new HttpUpgradeContextImpl(ctx, (Uni<SecurityIdentity>)identity, endpointId2), httpUpgradeChecks, 0);
            }

            private static Uni<HttpUpgradeCheck.CheckResult> checkHttpUpgrade(HttpUpgradeCheck.HttpUpgradeContext ctx, HttpUpgradeCheck[] checks, int idx) {
                return checks[idx].perform(ctx).flatMap(res -> {
                    if (res == null) {
                        return Uni.createFrom().failure((Throwable)new IllegalStateException("The '%s' returned null CheckResult, please make sure non-null value is returned".formatted(checks[idx])));
                    }
                    if (idx < checks.length - 1 && res.isUpgradePermitted()) {
                        return 2.checkHttpUpgrade(ctx, checks, idx + 1).map(n -> n.withHeaders(res.getResponseHeaders()));
                    }
                    return Uni.createFrom().item(res);
                });
            }
        };
    }

    private static HttpUpgradeCheck[] getHttpUpgradeChecks(String endpointId, ArcContainer container) {
        ArrayList<HttpUpgradeCheck> httpUpgradeChecks = null;
        for (HttpUpgradeCheck check : container.select(HttpUpgradeCheck.class, new Annotation[0])) {
            if (!check.appliesTo(endpointId)) continue;
            if (httpUpgradeChecks == null) {
                httpUpgradeChecks = new ArrayList<HttpUpgradeCheck>();
            }
            httpUpgradeChecks.add(check);
        }
        return httpUpgradeChecks == null ? null : httpUpgradeChecks.toArray(new HttpUpgradeCheck[0]);
    }

    SecuritySupport initializeSecuritySupport(ArcContainer container, RoutingContext ctx, Vertx vertx, WebSocketConnectionImpl connection) {
        QuarkusHttpUser user;
        InjectableInstance currentIdentityAssociation = container.select(CurrentIdentityAssociation.class, new Annotation[0]);
        if (currentIdentityAssociation.isResolvable() && (user = (QuarkusHttpUser)ctx.user()) != null) {
            return new SecuritySupport((Instance<CurrentIdentityAssociation>)currentIdentityAssociation, user.getSecurityIdentity(), vertx, connection);
        }
        return SecuritySupport.NOOP;
    }

    public Function<SyntheticCreationalContext<SecurityHttpUpgradeCheck>, SecurityHttpUpgradeCheck> createSecurityHttpUpgradeCheck(final Map<String, SecurityCheck> endpointToCheck) {
        return new Function<SyntheticCreationalContext<SecurityHttpUpgradeCheck>, SecurityHttpUpgradeCheck>(){

            @Override
            public SecurityHttpUpgradeCheck apply(SyntheticCreationalContext<SecurityHttpUpgradeCheck> ctx) {
                boolean securityEventsEnabled = (Boolean)ConfigProvider.getConfig().getValue("quarkus.security.events.enabled", Boolean.class);
                SecurityEventHelper securityEventHelper = new SecurityEventHelper((Event)ctx.getInjectedReference((TypeLiteral)new TypeLiteral<Event<AuthorizationSuccessEvent>>(){}, new Annotation[0]), (Event)ctx.getInjectedReference((TypeLiteral)new TypeLiteral<Event<AuthorizationFailureEvent>>(){}, new Annotation[0]), (SecurityEvent)SecurityEventHelper.AUTHORIZATION_SUCCESS, (SecurityEvent)SecurityEventHelper.AUTHORIZATION_FAILURE, (BeanManager)ctx.getInjectedReference(BeanManager.class, new Annotation[0]), securityEventsEnabled);
                WebSocketsServerRuntimeConfig config = (WebSocketsServerRuntimeConfig)ctx.getInjectedReference(WebSocketsServerRuntimeConfig.class, new Annotation[0]);
                return new SecurityHttpUpgradeCheck(config.security().authFailureRedirectUrl().orElse(null), endpointToCheck, (SecurityEventHelper<AuthorizationSuccessEvent, AuthorizationFailureEvent>)securityEventHelper);
            }
        };
    }

    public Function<SyntheticCreationalContext<HttpUpgradeSecurityInterceptor>, HttpUpgradeSecurityInterceptor> createHttpUpgradeSecurityInterceptor(final Map<String, String> classNameToEndpointId) {
        return new Function<SyntheticCreationalContext<HttpUpgradeSecurityInterceptor>, HttpUpgradeSecurityInterceptor>(){

            @Override
            public HttpUpgradeSecurityInterceptor apply(SyntheticCreationalContext<HttpUpgradeSecurityInterceptor> ctx) {
                EagerSecurityInterceptorStorage storage = (EagerSecurityInterceptorStorage)ctx.getInjectedReference(EagerSecurityInterceptorStorage.class, new Annotation[0]);
                HashMap<String, Consumer<RoutingContext>> endpointIdToInterceptor = new HashMap<String, Consumer<RoutingContext>>();
                classNameToEndpointId.forEach((className, endpointId) -> {
                    Consumer interceptor = Objects.requireNonNull(storage.getClassInterceptor(className));
                    endpointIdToInterceptor.put((String)endpointId, interceptor);
                });
                return new HttpUpgradeSecurityInterceptor(endpointIdToInterceptor);
            }
        };
    }
}

