/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.websockets.next.runtime;

import io.quarkus.websockets.next.runtime.WebSocketConnectionBase;
import io.smallrye.mutiny.helpers.queues.Queues;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.logging.Logger;

class ConcurrencyLimiter {
    private static final Logger LOG = Logger.getLogger(ConcurrencyLimiter.class);
    private final WebSocketConnectionBase connection;
    private final Queue<Action> queue;
    private final AtomicLong uncompleted;
    private final AtomicLong queueCounter;

    ConcurrencyLimiter(WebSocketConnectionBase connection) {
        this.connection = connection;
        this.uncompleted = new AtomicLong();
        this.queueCounter = LOG.isDebugEnabled() ? new AtomicLong() : null;
        this.queue = Queues.createMpscQueue();
    }

    PromiseComplete newComplete(Promise<Void> promise) {
        return new PromiseComplete(promise);
    }

    void run(Context context, Runnable action) {
        if (this.uncompleted.compareAndSet(0L, 1L)) {
            LOG.debugf("Run action: %s", (Object)this.connection);
            action.run();
        } else {
            long queueIndex = this.queueCounter != null ? this.queueCounter.incrementAndGet() : 0L;
            LOG.debugf("Action queued as %s: %s", queueIndex, (Object)this.connection);
            this.queue.offer(new Action(queueIndex, action, context));
            if (this.uncompleted.getAndIncrement() == 0L) {
                Action queuedAction = this.queue.poll();
                assert (queuedAction != null);
                LOG.debugf("Run action %s from queue: %s", queuedAction.queueIndex, (Object)this.connection);
                queuedAction.runnable.run();
            }
        }
    }

    class PromiseComplete {
        final Promise<Void> promise;

        private PromiseComplete(Promise<Void> promise) {
            this.promise = promise;
        }

        void failure(Throwable t) {
            try {
                this.promise.fail(t);
            }
            finally {
                this.tryNext();
            }
        }

        void complete() {
            try {
                this.promise.complete();
            }
            finally {
                this.tryNext();
            }
        }

        private void tryNext() {
            if (ConcurrencyLimiter.this.uncompleted.decrementAndGet() == 0L) {
                return;
            }
            final Action queuedAction = ConcurrencyLimiter.this.queue.poll();
            assert (queuedAction != null);
            LOG.debugf("Run action %s from queue: %s", queuedAction.queueIndex, (Object)ConcurrencyLimiter.this.connection);
            queuedAction.context.runOnContext((Handler)new Handler<Void>(){

                public void handle(Void event) {
                    queuedAction.runnable.run();
                }
            });
        }
    }

    record Action(long queueIndex, Runnable runnable, Context context) {
    }
}

