/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.websockets.next.deployment;

import io.quarkus.arc.impl.GenericArrayTypeImpl;
import io.quarkus.arc.impl.ParameterizedTypeImpl;
import io.quarkus.arc.impl.TypeVariableImpl;
import io.quarkus.arc.impl.TypeVariableReferenceImpl;
import io.quarkus.arc.impl.WildcardTypeImpl;
import io.quarkus.gizmo2.Assignable;
import io.quarkus.gizmo2.Const;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.LocalVar;
import io.quarkus.gizmo2.creator.BlockCreator;
import io.quarkus.gizmo2.desc.ConstructorDesc;
import io.quarkus.gizmo2.desc.MethodDesc;
import java.lang.constant.ClassDesc;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jboss.jandex.ArrayType;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeVariable;

class RuntimeTypeCreator {
    private final BlockCreator bc;
    private final IndexView index;
    private final Cache cache;
    private final LocalVar tccl;

    public static RuntimeTypeCreator of(BlockCreator bc) {
        Objects.requireNonNull(bc);
        return new RuntimeTypeCreator(bc, null, null, null);
    }

    public RuntimeTypeCreator withIndex(IndexView index) {
        Objects.requireNonNull(index);
        return new RuntimeTypeCreator(this.bc, index, this.cache, this.tccl);
    }

    public RuntimeTypeCreator withCache(Cache cache) {
        Objects.requireNonNull(cache);
        return new RuntimeTypeCreator(this.bc, this.index, cache, this.tccl);
    }

    public RuntimeTypeCreator withTCCL(LocalVar tccl) {
        Objects.requireNonNull(tccl);
        return new RuntimeTypeCreator(this.bc, this.index, this.cache, tccl);
    }

    private RuntimeTypeCreator(BlockCreator bc, IndexView index, Cache cache, LocalVar tccl) {
        this.bc = bc;
        this.index = index;
        this.cache = cache;
        this.tccl = tccl;
    }

    public LocalVar create(org.jboss.jandex.Type type) {
        Objects.requireNonNull(type);
        LocalVar result = this.bc.localVar("type", (Expr)Const.ofNull(Type.class));
        TypeVariables typeVariables = new TypeVariables();
        this.create(type, result, this.bc, typeVariables);
        typeVariables.patchTypeVariableReferences(this.bc);
        return result;
    }

    private void create(org.jboss.jandex.Type btType, LocalVar rtType, BlockCreator bc, TypeVariables typeVariables) {
        if (this.cache != null) {
            LocalVar rtCachedType = this.cache.get(bc, btType);
            bc.ifElse(bc.eq((Expr)rtCachedType, (Expr)Const.ofNull(Type.class)), b1 -> this.doCreate(btType, rtType, (BlockCreator)b1, typeVariables), b1 -> b1.set((Assignable)rtType, (Expr)rtCachedType));
        } else {
            this.doCreate(btType, rtType, bc, typeVariables);
        }
    }

    private void doCreate(org.jboss.jandex.Type btType, LocalVar rtType, BlockCreator bc, TypeVariables typeVariables) {
        if (Type.Kind.VOID.equals((Object)btType.kind())) {
            bc.set((Assignable)rtType, Const.of(Void.TYPE));
        } else if (Type.Kind.PRIMITIVE.equals((Object)btType.kind())) {
            bc.set((Assignable)rtType, switch (btType.asPrimitiveType().primitive()) {
                default -> throw new IncompatibleClassChangeError();
                case PrimitiveType.Primitive.BOOLEAN -> Const.of(Boolean.TYPE);
                case PrimitiveType.Primitive.BYTE -> Const.of(Byte.TYPE);
                case PrimitiveType.Primitive.SHORT -> Const.of(Short.TYPE);
                case PrimitiveType.Primitive.INT -> Const.of(Integer.TYPE);
                case PrimitiveType.Primitive.LONG -> Const.of(Long.TYPE);
                case PrimitiveType.Primitive.FLOAT -> Const.of(Float.TYPE);
                case PrimitiveType.Primitive.DOUBLE -> Const.of(Double.TYPE);
                case PrimitiveType.Primitive.CHAR -> Const.of(Character.TYPE);
            });
        } else if (Type.Kind.CLASS.equals((Object)btType.kind())) {
            ClassType btClass = btType.asClassType();
            LocalVar rtClass = bc.localVar("clazz", this.doLoadClass(btClass.name().toString(), bc));
            if (this.cache != null) {
                this.cache.put(bc, btType, rtClass);
            }
            bc.set((Assignable)rtType, (Expr)rtClass);
        } else if (Type.Kind.ARRAY.equals((Object)btType.kind())) {
            LocalVar rtArray;
            ArrayType btArray = btType.asArrayType();
            org.jboss.jandex.Type btElementType = btArray.elementType();
            if (btElementType.kind() == Type.Kind.PRIMITIVE || btElementType.kind() == Type.Kind.CLASS) {
                rtArray = bc.localVar("array", this.doLoadClass(btArray.name().toString(), bc));
            } else {
                org.jboss.jandex.Type btComponentType = btType.asArrayType().componentType();
                LocalVar rtComponentType = bc.localVar("component", (Expr)Const.ofNull(Type.class));
                this.create(btComponentType, rtComponentType, bc, typeVariables);
                rtArray = bc.localVar("array", bc.new_(ConstructorDesc.of(GenericArrayTypeImpl.class, (Class[])new Class[]{Type.class}), new Expr[]{rtComponentType}));
            }
            if (this.cache != null) {
                this.cache.put(bc, btType, rtArray);
            }
            bc.set((Assignable)rtType, (Expr)rtArray);
        } else if (Type.Kind.PARAMETERIZED_TYPE.equals((Object)btType.kind())) {
            ClassInfo btGenericClass;
            ParameterizedType btParamType = btType.asParameterizedType();
            LocalVar rtTypeArgs = bc.localVar("typeArgs", bc.newArray(Type.class, btParamType.arguments().stream().map(btTypeArg -> {
                LocalVar rtTypeArg = bc.localVar("typeArg", (Expr)Const.ofNull(Type.class));
                this.create((org.jboss.jandex.Type)btTypeArg, rtTypeArg, bc, typeVariables);
                return rtTypeArg;
            }).toList()));
            ClassType btGenericType = ClassType.create((DotName)btParamType.name());
            LocalVar rtGenericType = null;
            if (this.cache != null) {
                rtGenericType = this.cache.get(bc, (org.jboss.jandex.Type)btGenericType);
            }
            if (rtGenericType == null) {
                rtGenericType = bc.localVar("genericType", this.doLoadClass(btGenericType.name().toString(), bc));
                if (this.cache != null) {
                    this.cache.put(bc, (org.jboss.jandex.Type)btGenericType, rtGenericType);
                }
            }
            LocalVar rtOwner = bc.localVar("owner", (Expr)Const.ofNull(Type.class));
            if (btParamType.owner() != null) {
                this.create(btParamType.owner(), rtOwner, bc, typeVariables);
            } else if (this.index != null && (btGenericClass = this.index.getClassByName(btParamType.name())) != null && btGenericClass.enclosingClass() != null) {
                ClassType btOwner = ClassType.create((DotName)btGenericClass.enclosingClass());
                this.create((org.jboss.jandex.Type)btOwner, rtOwner, bc, typeVariables);
            }
            LocalVar rtParamType = bc.localVar("parameterizedType", bc.new_(ConstructorDesc.of(ParameterizedTypeImpl.class, (Class[])new Class[]{Type.class, Type[].class, Type.class}), new Expr[]{rtGenericType, rtTypeArgs, rtOwner}));
            if (this.cache != null) {
                this.cache.put(bc, (org.jboss.jandex.Type)btParamType, rtParamType);
            }
            bc.set((Assignable)rtType, (Expr)rtParamType);
        } else if (Type.Kind.TYPE_VARIABLE.equals((Object)btType.kind())) {
            TypeVariable btTypeVar = btType.asTypeVariable();
            String btIdentifier = btTypeVar.identifier();
            LocalVar rtTypeVar = typeVariables.getTypeVariable(btIdentifier);
            if (rtTypeVar == null) {
                List btBounds = btTypeVar.bounds();
                LocalVar rtBounds = bc.localVar("bounds", bc.newArray(Type.class, btBounds.stream().map(btBound -> {
                    LocalVar rtBound = bc.localVar("bound", (Expr)Const.ofNull(Type.class));
                    this.create((org.jboss.jandex.Type)btBound, rtBound, bc, typeVariables);
                    return rtBound;
                }).toList()));
                rtTypeVar = bc.localVar("typeVariable", bc.new_(ConstructorDesc.of(TypeVariableImpl.class, (Class[])new Class[]{String.class, Type[].class}), new Expr[]{Const.of((String)btIdentifier), rtBounds}));
                if (this.cache != null) {
                    this.cache.put(bc, (org.jboss.jandex.Type)btTypeVar, rtTypeVar);
                }
                typeVariables.setTypeVariable(btIdentifier, rtTypeVar);
            }
            bc.set((Assignable)rtType, (Expr)rtTypeVar);
        } else if (Type.Kind.TYPE_VARIABLE_REFERENCE.equals((Object)btType.kind())) {
            String btIdentifier = btType.asTypeVariableReference().identifier();
            LocalVar rtTypeVarRef = typeVariables.getTypeVariableReference(btIdentifier);
            if (rtTypeVarRef == null) {
                rtTypeVarRef = bc.localVar("typeVariableReference", bc.new_(ConstructorDesc.of(TypeVariableReferenceImpl.class, (Class[])new Class[]{String.class}), new Expr[]{Const.of((String)btIdentifier)}));
                typeVariables.setTypeVariableReference(btIdentifier, rtTypeVarRef);
            }
            bc.set((Assignable)rtType, (Expr)rtTypeVarRef);
        } else if (Type.Kind.WILDCARD_TYPE.equals((Object)btType.kind())) {
            LocalVar rtWildcard;
            org.jboss.jandex.WildcardType btWildcard = btType.asWildcardType();
            if (btWildcard.superBound() == null) {
                org.jboss.jandex.Type btUpperBound = btWildcard.extendsBound();
                LocalVar rtUpperBound = bc.localVar("upperBound", (Expr)Const.ofNull(Type.class));
                this.create(btUpperBound, rtUpperBound, bc, typeVariables);
                rtWildcard = bc.localVar("wildcard", bc.invokeStatic(MethodDesc.of(WildcardTypeImpl.class, (String)"withUpperBound", WildcardType.class, (Class[])new Class[]{Type.class}), new Expr[]{rtUpperBound}));
            } else {
                org.jboss.jandex.Type btLowerBound = btWildcard.superBound();
                LocalVar rtLowerBound = bc.localVar("lowerBound", (Expr)Const.ofNull(Type.class));
                this.create(btLowerBound, rtLowerBound, bc, typeVariables);
                rtWildcard = bc.localVar("wildcard", bc.invokeStatic(MethodDesc.of(WildcardTypeImpl.class, (String)"withLowerBound", WildcardType.class, (Class[])new Class[]{Type.class}), new Expr[]{rtLowerBound}));
            }
            if (this.cache != null) {
                this.cache.put(bc, (org.jboss.jandex.Type)btWildcard, rtWildcard);
            }
            bc.set((Assignable)rtType, (Expr)rtWildcard);
        } else {
            throw new IllegalArgumentException("Unsupported type: " + String.valueOf(btType.kind()) + ", " + String.valueOf(btType));
        }
    }

    private Expr doLoadClass(String className, BlockCreator bc) {
        if (className.startsWith("java.")) {
            return Const.of((ClassDesc)ClassDesc.of(className));
        }
        MethodDesc THREAD_GET_TCCL = MethodDesc.of(Thread.class, (String)"getContextClassLoader", ClassLoader.class, (Class[])new Class[0]);
        MethodDesc CL_FOR_NAME = MethodDesc.of(Class.class, (String)"forName", Class.class, (Class[])new Class[]{String.class, Boolean.TYPE, ClassLoader.class});
        LocalVar cl = this.tccl != null ? this.tccl : bc.invokeVirtual(THREAD_GET_TCCL, bc.currentThread(), new Expr[0]);
        return bc.invokeStatic(CL_FOR_NAME, new Expr[]{Const.of((String)className), Const.of((boolean)false), cl});
    }

    public static interface Cache {
        public LocalVar get(BlockCreator var1, org.jboss.jandex.Type var2);

        public void put(BlockCreator var1, org.jboss.jandex.Type var2, LocalVar var3);
    }

    private static final class TypeVariables {
        private final Map<String, LocalVar> typeVariables = new HashMap<String, LocalVar>();
        private final Map<String, LocalVar> typeVariableReferences = new HashMap<String, LocalVar>();

        private TypeVariables() {
        }

        LocalVar getTypeVariable(String identifier) {
            return this.typeVariables.get(identifier);
        }

        void setTypeVariable(String identifier, LocalVar localVar) {
            this.typeVariables.put(identifier, localVar);
        }

        LocalVar getTypeVariableReference(String identifier) {
            return this.typeVariableReferences.get(identifier);
        }

        void setTypeVariableReference(String identifier, LocalVar localVar) {
            this.typeVariableReferences.put(identifier, localVar);
        }

        void patchTypeVariableReferences(BlockCreator bc) {
            this.typeVariableReferences.forEach((identifier, reference) -> {
                LocalVar typeVar = this.typeVariables.get(identifier);
                if (typeVar != null) {
                    bc.invokeVirtual(MethodDesc.of(TypeVariableReferenceImpl.class, (String)"setDelegate", Void.TYPE, (Class[])new Class[]{TypeVariableImpl.class}), (Expr)reference, new Expr[]{typeVar});
                }
            });
        }
    }
}

