/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InjectableContext;
import io.quarkus.arc.ManagedContext;
import io.quarkus.vertx.runtime.VertxEventBusConsumerRecorder;
import io.vertx.core.eventbus.Message;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;

public abstract class EventConsumerInvoker {
    public boolean isBlocking() {
        return false;
    }

    public boolean isRunningOnVirtualThread() {
        return false;
    }

    public boolean isOrdered() {
        return false;
    }

    public void invoke(Message<Object> message) throws Exception {
        ManagedContext requestContext = Arc.container().requestContext();
        if (requestContext.isActive()) {
            Object ret = this.invokeBean(message);
            if (ret != null) {
                if (ret instanceof CompletionStage) {
                    ((CompletionStage)ret).whenComplete(new RequestActiveConsumer(message));
                } else {
                    message.reply(ret);
                }
            }
        } else {
            Object ret;
            requestContext.activate();
            try {
                ret = this.invokeBean(message);
            }
            catch (Exception e) {
                requestContext.terminate();
                throw e;
            }
            if (ret == null) {
                requestContext.terminate();
            } else if (ret instanceof CompletionStage) {
                InjectableContext.ContextState endState = requestContext.getState();
                requestContext.deactivate();
                ((CompletionStage)ret).whenComplete(new RequestActivatedConsumer(message, requestContext, endState));
            } else {
                requestContext.terminate();
                message.reply(ret);
            }
        }
    }

    protected abstract Object invokeBean(Message<Object> var1) throws Exception;

    private static class RequestActivatedConsumer
    implements BiConsumer<Object, Throwable> {
        private final Message<Object> message;
        private final ManagedContext requestContext;
        private final InjectableContext.ContextState endState;

        public RequestActivatedConsumer(Message<Object> message, ManagedContext requestContext, InjectableContext.ContextState endState) {
            this.message = message;
            this.requestContext = requestContext;
            this.endState = endState;
        }

        @Override
        public void accept(Object result, Throwable failure) {
            try {
                this.requestContext.destroy(this.endState);
            }
            catch (Exception e) {
                throw VertxEventBusConsumerRecorder.wrapIfNecessary(e);
            }
            if (failure != null) {
                if (this.message.replyAddress() == null) {
                    throw VertxEventBusConsumerRecorder.wrapIfNecessary(failure);
                }
                this.message.fail(8191, failure.getMessage());
            } else {
                this.message.reply(result);
            }
        }
    }

    private static class RequestActiveConsumer
    implements BiConsumer<Object, Throwable> {
        private final Message<Object> message;

        RequestActiveConsumer(Message<Object> message) {
            this.message = message;
        }

        @Override
        public void accept(Object result, Throwable failure) {
            if (failure != null) {
                if (this.message.replyAddress() == null) {
                    throw VertxEventBusConsumerRecorder.wrapIfNecessary(failure);
                }
                this.message.fail(8191, failure.getMessage());
            } else {
                this.message.reply(result);
            }
        }
    }
}

