/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.devmode;

import io.quarkus.runtime.TemplateHtmlBuilder;
import io.quarkus.runtime.util.ClassPathUtils;
import io.quarkus.vertx.http.runtime.devmode.AdditionalRouteDescription;
import io.quarkus.vertx.http.runtime.devmode.RouteDescription;
import io.quarkus.vertx.http.runtime.devmode.RouteMethodDescription;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;

public class ResourceNotFoundHandler
implements Handler<RoutingContext> {
    private static final Logger LOG = Logger.getLogger(ResourceNotFoundHandler.class);
    protected static final String META_INF_RESOURCES = "META-INF/resources";
    public static volatile List<RouteDescription> runtimeRoutes;
    private static volatile List<String> servletMappings;
    private final String baseUrl;
    private final String httpRoot;
    private final List<RouteDescription> routes;
    private final Set<String> staticResourceRoots;
    private final List<AdditionalRouteDescription> additionalEndpoints;

    public ResourceNotFoundHandler(String baseUrl, String httpRoot, List<RouteDescription> routes, Set<String> staticResourceRoots, List<AdditionalRouteDescription> additionalEndpoints) {
        this.baseUrl = baseUrl;
        this.httpRoot = httpRoot;
        this.routes = routes;
        this.staticResourceRoots = staticResourceRoots;
        this.additionalEndpoints = additionalEndpoints;
    }

    public void handle(RoutingContext routingContext) {
        String header = routingContext.request().getHeader("Accept");
        if (header != null && header.startsWith("application/json")) {
            this.handleJson(routingContext);
        } else {
            this.handleHTML(routingContext);
        }
    }

    private void handleJson(RoutingContext routingContext) {
        routingContext.response().setStatusCode(404).putHeader("content-type", "application/json; charset=utf-8").end();
    }

    private void handleHTML(RoutingContext routingContext) {
        List<String> resources;
        TemplateHtmlBuilder builder = new TemplateHtmlBuilder(this.baseUrl, "404 - Resource Not Found", "", "Resources overview");
        ArrayList<RouteDescription> combinedRoutes = new ArrayList<RouteDescription>();
        if (runtimeRoutes != null) {
            combinedRoutes.addAll(runtimeRoutes);
        }
        if (this.routes != null) {
            combinedRoutes.addAll(this.routes);
        }
        builder.resourcesStart("Resource Endpoints");
        for (RouteDescription routeDescription : combinedRoutes) {
            builder.resourcePath(TemplateHtmlBuilder.adjustRoot((String)this.httpRoot, (String)routeDescription.getBasePath()));
            for (RouteMethodDescription method : routeDescription.getCalls()) {
                builder.method(method.getHttpMethod(), method.getFullPath());
                if (method.getJavaMethod() != null) {
                    builder.listItem(method.getJavaMethod());
                }
                if (method.getConsumes() != null) {
                    builder.consumes(method.getConsumes());
                }
                if (method.getProduces() != null) {
                    builder.produces(method.getProduces());
                }
                builder.methodEnd();
            }
            builder.resourceEnd();
        }
        if (combinedRoutes.isEmpty()) {
            builder.noResourcesFound();
        }
        builder.resourcesEnd();
        if (!servletMappings.isEmpty()) {
            builder.resourcesStart("Servlet mappings");
            for (String string : servletMappings) {
                builder.servletMapping(TemplateHtmlBuilder.adjustRoot((String)this.httpRoot, (String)string));
            }
            builder.resourcesEnd();
        }
        if (!this.staticResourceRoots.isEmpty() && !(resources = this.findRealResources()).isEmpty()) {
            builder.resourcesStart("Static resources");
            for (String staticResource : resources) {
                builder.staticResourcePath(TemplateHtmlBuilder.adjustRoot((String)this.httpRoot, (String)staticResource));
            }
            builder.resourcesEnd();
        }
        if (!this.additionalEndpoints.isEmpty()) {
            builder.resourcesStart("Additional endpoints");
            for (AdditionalRouteDescription additionalRouteDescription : this.additionalEndpoints) {
                builder.staticResourcePath(additionalRouteDescription.getUri(), additionalRouteDescription.getDescription());
            }
            builder.resourcesEnd();
        }
        routingContext.response().setStatusCode(404).putHeader("content-type", "text/html; charset=utf-8").end(builder.toString());
    }

    private List<String> findRealResources() {
        final HashSet knownFiles = new HashSet();
        for (String staticResourceRoot : this.staticResourceRoots) {
            Path resource;
            if (staticResourceRoot == null || !Files.exists(resource = Paths.get(staticResourceRoot, new String[0]), new LinkOption[0])) continue;
            try {
                Stream<Path> fileTreeElements = Files.walk(resource, new FileVisitOption[0]);
                try {
                    fileTreeElements.forEach(new Consumer<Path>(){

                        @Override
                        public void accept(Path path) {
                            if (resource.equals(path)) {
                                return;
                            }
                            Path rel = resource.relativize(path);
                            if (!Files.isDirectory(path, new LinkOption[0])) {
                                knownFiles.add(rel.toString());
                            }
                        }
                    });
                }
                finally {
                    if (fileTreeElements == null) continue;
                    fileTreeElements.close();
                }
            }
            catch (IOException e) {
                LOG.error((Object)"Failed to read static resources", (Throwable)e);
            }
        }
        try {
            ClassPathUtils.consumeAsPaths((String)META_INF_RESOURCES, p -> this.collectKnownPaths((Path)p, knownFiles));
        }
        catch (IOException e) {
            LOG.error((Object)"Failed to read static resources", (Throwable)e);
        }
        return knownFiles.stream().filter(this::isHtmlFileName).limit(1000L).distinct().sorted(Comparator.naturalOrder()).collect(Collectors.toList());
    }

    private void collectKnownPaths(final Path resource, final Set<String> knownPaths) {
        try {
            Files.walkFileTree(resource, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path p, BasicFileAttributes attrs) throws IOException {
                    String file = resource.relativize(p).toString();
                    if (!(file = file.replace('\\', '/')).startsWith("_static/") && !file.startsWith("webjars/")) {
                        knownPaths.add(file);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private boolean isHtmlFileName(String fileName) {
        return fileName.endsWith(".html") || fileName.endsWith(".htm") || fileName.endsWith(".xhtml");
    }

    public static void addServlet(String mapping) {
        servletMappings.add(mapping);
    }

    static {
        servletMappings = new ArrayList<String>();
    }
}

