/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.management;

import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.quarkus.vertx.http.runtime.BodyConfig;
import io.quarkus.vertx.http.runtime.FilterConfig;
import io.quarkus.vertx.http.runtime.HeaderConfig;
import io.quarkus.vertx.http.runtime.ProxyConfig;
import io.quarkus.vertx.http.runtime.ServerLimitsConfig;
import io.quarkus.vertx.http.runtime.ServerSslConfig;
import io.quarkus.vertx.http.runtime.management.ManagementRuntimeAuthConfig;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;

@ConfigRoot(phase=ConfigPhase.RUN_TIME, name="management")
public class ManagementInterfaceConfiguration {
    public ManagementRuntimeAuthConfig auth;
    @ConfigItem(defaultValue="9000")
    public int port;
    @ConfigItem(defaultValue="9001")
    public int testPort;
    @ConfigItem
    public Optional<String> host;
    @ConfigItem(defaultValue="true")
    public boolean hostEnabled;
    public ServerSslConfig ssl;
    @ConfigItem(defaultValue="false", name="handle-100-continue-automatically")
    public boolean handle100ContinueAutomatically;
    public ServerLimitsConfig limits;
    @ConfigItem(defaultValue="30M", name="idle-timeout")
    public Duration idleTimeout;
    public BodyConfig body;
    @ConfigItem(defaultValue="-1")
    public int acceptBacklog;
    @ConfigItem(defaultValue="/var/run/io.quarkus.management.socket")
    public String domainSocket;
    @ConfigItem
    public boolean domainSocketEnabled;
    @ConfigItem
    public Map<String, HeaderConfig> header;
    @ConfigItem
    public Map<String, FilterConfig> filter;
    public ProxyConfig proxy;

    public int determinePort(LaunchMode launchMode) {
        return launchMode == LaunchMode.TEST ? this.testPort : this.port;
    }
}

