/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.security;

import io.quarkus.arc.DefaultBean;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.spi.runtime.AbstractSecurityIdentityAssociation;
import io.quarkus.vertx.http.runtime.security.QuarkusHttpUser;
import io.smallrye.common.vertx.ContextLocals;
import io.smallrye.mutiny.Uni;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;

@DefaultBean
@RequestScoped
public class DuplicatedContextSecurityIdentityAssociation
extends AbstractSecurityIdentityAssociation {
    private IdentityProviderManager identityProviderManager;

    @Inject
    public DuplicatedContextSecurityIdentityAssociation setIdentityProviderManager(IdentityProviderManager identityProviderManager) {
        this.identityProviderManager = identityProviderManager;
        return this;
    }

    protected IdentityProviderManager getIdentityProviderManager() {
        return this.identityProviderManager;
    }

    public Uni<SecurityIdentity> getDeferredIdentity() {
        RoutingContext routingContext = DuplicatedContextSecurityIdentityAssociation.getRoutingContext();
        if (routingContext != null) {
            SecurityIdentity securityIdentity = DuplicatedContextSecurityIdentityAssociation.getSecurityIdentityFromCtx(routingContext);
            if (securityIdentity != null) {
                return Uni.createFrom().item((Object)securityIdentity);
            }
            Uni identityUni = (Uni)routingContext.get("io.quarkus.vertx.http.deferred-identity");
            if (identityUni != null) {
                return identityUni;
            }
        }
        return super.getDeferredIdentity();
    }

    public SecurityIdentity getIdentity() {
        RoutingContext routingContext = DuplicatedContextSecurityIdentityAssociation.getRoutingContext();
        if (routingContext != null) {
            SecurityIdentity securityIdentity = DuplicatedContextSecurityIdentityAssociation.getSecurityIdentityFromCtx(routingContext);
            if (securityIdentity != null) {
                return securityIdentity;
            }
            securityIdentity = QuarkusHttpUser.getSecurityIdentityBlocking(routingContext, null);
            if (securityIdentity != null) {
                return securityIdentity;
            }
        }
        return super.getIdentity();
    }

    private static SecurityIdentity getSecurityIdentityFromCtx(RoutingContext routingContext) {
        User user = routingContext.user();
        if (user instanceof QuarkusHttpUser) {
            QuarkusHttpUser quarkusHttpUser = (QuarkusHttpUser)user;
            return quarkusHttpUser.getSecurityIdentity();
        }
        return null;
    }

    private static RoutingContext getRoutingContext() {
        return (RoutingContext)ContextLocals.get((String)"quarkus.http.routing.context", null);
    }
}

