/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.security;

import io.quarkus.security.StringPermission;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.vertx.http.runtime.FormAuthConfig;
import io.quarkus.vertx.http.runtime.VertxHttpConfig;
import io.quarkus.vertx.http.runtime.security.BasicAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.FormAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.HttpSecurityConfiguration;
import io.quarkus.vertx.http.runtime.security.HttpSecurityPolicy;
import io.quarkus.vertx.http.runtime.security.RolesAllowedHttpSecurityPolicy;
import io.quarkus.vertx.http.runtime.security.RolesMapping;
import io.quarkus.vertx.http.security.Basic;
import io.quarkus.vertx.http.security.HttpSecurity;
import io.smallrye.config.SmallRyeConfigBuilder;
import io.smallrye.mutiny.Uni;
import io.vertx.core.http.ClientAuth;
import io.vertx.ext.web.RoutingContext;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import org.jboss.logging.Logger;

final class HttpSecurityImpl
implements HttpSecurity {
    private static final Logger LOG = Logger.getLogger((String)HttpSecurityImpl.class.getName());
    private final List<HttpSecurityConfiguration.HttpPermissionCarrier> httpPermissions = new ArrayList<HttpSecurityConfiguration.HttpPermissionCarrier>();
    private final List<HttpAuthenticationMechanism> mechanisms = new ArrayList<HttpAuthenticationMechanism>();
    private final VertxHttpConfig vertxHttpConfig;
    private RolesMapping rolesMapping = null;
    private ClientAuth clientAuth;

    HttpSecurityImpl(ClientAuth clientAuth, VertxHttpConfig vertxHttpConfig) {
        this.clientAuth = clientAuth;
        this.vertxHttpConfig = vertxHttpConfig;
    }

    @Override
    public HttpSecurity mechanism(HttpAuthenticationMechanism mechanism) {
        String actualRealm;
        Objects.requireNonNull(mechanism);
        if (mechanism.getClass() == FormAuthenticationMechanism.class) {
            FormAuthConfig defaults = ((VertxHttpConfig)new SmallRyeConfigBuilder().addDiscoveredConverters().withDefaultValue("quarkus.http.host", "8081").withMapping(VertxHttpConfig.class).build().getConfigMapping(VertxHttpConfig.class)).auth().form();
            FormAuthConfig actualConfig = this.vertxHttpConfig.auth().form();
            if (!actualConfig.equals(defaults)) {
                throw new IllegalArgumentException("Cannot configure form-based authentication programmatically because it has already been configured in the 'application.properties' file");
            }
        } else if (mechanism.getClass() == BasicAuthenticationMechanism.class && (actualRealm = (String)this.vertxHttpConfig.auth().realm().orElse(null)) != null) {
            throw new IllegalArgumentException("Cannot configure basic authentication programmatically because the authentication realm has already been configured in the 'application.properties' file");
        }
        this.mechanisms.add(mechanism);
        return this;
    }

    @Override
    public HttpSecurity basic() {
        return this.mechanism(Basic.create());
    }

    @Override
    public HttpSecurity basic(String authenticationRealm) {
        return this.mechanism(Basic.realm(authenticationRealm));
    }

    @Override
    public HttpSecurity.HttpPermission path(String ... patterns) {
        if (patterns == null || patterns.length == 0) {
            throw new IllegalArgumentException("Paths must not be empty");
        }
        HttpPermissionImpl httpPermission = new HttpPermissionImpl(patterns);
        this.httpPermissions.add(httpPermission);
        return httpPermission;
    }

    @Override
    public HttpSecurity.HttpPermission get(String ... paths) {
        return this.path(paths).methods("GET");
    }

    @Override
    public HttpSecurity.HttpPermission put(String ... paths) {
        return this.path(paths).methods("PUT");
    }

    @Override
    public HttpSecurity.HttpPermission post(String ... paths) {
        return this.path(paths).methods("POST");
    }

    @Override
    public HttpSecurity.HttpPermission delete(String ... paths) {
        return this.path(paths).methods("DELETE");
    }

    @Override
    public HttpSecurity rolesMapping(Map<String, List<String>> roleToRoles) {
        if (this.rolesMapping != null) {
            throw new IllegalStateException("Roles mapping is already configured");
        }
        if (roleToRoles == null || roleToRoles.isEmpty()) {
            throw new IllegalArgumentException("Roles must not be empty");
        }
        roleToRoles.forEach(new BiConsumer<String, List<String>>(){

            @Override
            public void accept(String sourceRole, List<String> targetRoles) {
                if (sourceRole.isEmpty()) {
                    throw new IllegalArgumentException("Source role must not be empty");
                }
                if (targetRoles == null || targetRoles.isEmpty()) {
                    throw new IllegalArgumentException("Target roles for role '%s' must not be empty".formatted(sourceRole));
                }
            }
        });
        this.rolesMapping = RolesMapping.of(roleToRoles);
        return this;
    }

    @Override
    public HttpSecurity rolesMapping(String sourceRole, List<String> targetRoles) {
        if (sourceRole == null) {
            throw new IllegalArgumentException("Source role must not be null");
        }
        if (targetRoles == null) {
            throw new IllegalArgumentException("Target roles for role '%s' must not be null".formatted(sourceRole));
        }
        return this.rolesMapping(Map.of(sourceRole, targetRoles));
    }

    @Override
    public HttpSecurity rolesMapping(String sourceRole, String targetRole) {
        if (targetRole == null) {
            throw new IllegalArgumentException("Target role for role '%s' must not be null".formatted(sourceRole));
        }
        return this.rolesMapping(sourceRole, List.of(targetRole));
    }

    void addHttpPermissions(List<HttpSecurityConfiguration.HttpPermissionCarrier> httpPermissions) {
        this.httpPermissions.addAll(httpPermissions);
    }

    List<HttpSecurityConfiguration.HttpPermissionCarrier> getHttpPermissions() {
        return List.copyOf(this.httpPermissions);
    }

    RolesMapping getRolesMapping() {
        return this.rolesMapping;
    }

    List<HttpAuthenticationMechanism> getMechanisms() {
        return this.mechanisms.isEmpty() ? List.of() : List.copyOf(this.mechanisms);
    }

    ClientAuth getClientAuth() {
        return this.clientAuth;
    }

    private final class HttpPermissionImpl
    implements HttpSecurity.HttpPermission,
    HttpSecurityConfiguration.HttpPermissionCarrier {
        private final String[] paths;
        private boolean shared;
        private boolean applyToJaxRs;
        private String[] methods;
        private HttpSecurityConfiguration.AuthenticationMechanism authMechanism;
        private AuthorizationPolicy authorizationPolicy;

        private HttpPermissionImpl(String[] paths) {
            this.paths = Arrays.copyOf(paths, paths.length);
            this.authMechanism = null;
            this.authorizationPolicy = null;
            this.shared = false;
            this.methods = null;
            this.applyToJaxRs = false;
        }

        private void requireAuthenticationByDefault() {
            if (this.authorizationPolicy == null) {
                this.authenticated();
            }
        }

        private void validateAuthenticationNotSetYet() {
            if (this.authMechanism != null) {
                throw new IllegalArgumentException("Authentication has already been set");
            }
        }

        private void validateAuthorizationNotSetYet() {
            if (this.authMechanism == null && this.authorizationPolicy != null) {
                throw new IllegalArgumentException("Authorization has already been set");
            }
        }

        @Override
        public HttpSecurity.HttpPermission basic() {
            return this.authenticatedWith("basic");
        }

        @Override
        public HttpSecurity.HttpPermission form() {
            return this.authenticatedWith("form");
        }

        @Override
        public HttpSecurity.HttpPermission mTLS() {
            boolean mTlsDisabled = ClientAuth.NONE.equals((Object)HttpSecurityImpl.this.clientAuth);
            if (mTlsDisabled) {
                throw new IllegalStateException("TLS client authentication is not available, please set the 'quarkus.http.ssl.client-auth' configuration property to 'required' or 'request'");
            }
            return this.authenticatedWith("X509");
        }

        @Override
        public HttpSecurity.HttpPermission bearer() {
            return this.authenticatedWith("Bearer");
        }

        @Override
        public HttpSecurity.HttpPermission webAuthn() {
            return this.authenticatedWith("webauthn");
        }

        @Override
        public HttpSecurity.HttpPermission authorizationCodeFlow() {
            return this.authenticatedWith("code");
        }

        @Override
        public HttpSecurity authenticated() {
            return this.authorization().authenticated();
        }

        @Override
        public HttpSecurity.HttpPermission authenticatedWith(String mechanism) {
            this.validateAuthenticationNotSetYet();
            this.requireAuthenticationByDefault();
            if (mechanism == null || mechanism.isBlank()) {
                throw new IllegalArgumentException("Authentication mechanism must not be null or blank");
            }
            this.authMechanism = new HttpSecurityConfiguration.AuthenticationMechanism(mechanism, null);
            return this;
        }

        @Override
        public HttpSecurity.HttpPermission shared() {
            this.shared = true;
            return this;
        }

        @Override
        public HttpSecurity.HttpPermission applyToJaxRs() {
            this.applyToJaxRs = true;
            return this;
        }

        @Override
        public HttpSecurity.HttpPermission methods(String ... httpMethods) {
            if (httpMethods == null || httpMethods.length == 0) {
                throw new IllegalArgumentException("HTTP methods must not be null or empty");
            }
            this.methods = Arrays.copyOf(httpMethods, httpMethods.length);
            return this;
        }

        @Override
        public AuthorizationPolicy authorization() {
            this.validateAuthorizationNotSetYet();
            this.authorizationPolicy = new AuthorizationPolicy();
            return this.authorizationPolicy;
        }

        @Override
        public HttpSecurity permit() {
            return this.authorization().permit();
        }

        @Override
        public HttpSecurity roles(String ... roles) {
            return this.authorization().roles(roles);
        }

        @Override
        public HttpSecurity policy(HttpSecurityPolicy httpSecurityPolicy) {
            return this.authorization().policy(httpSecurityPolicy);
        }

        @Override
        public Set<String> getPaths() {
            return Set.of(this.paths);
        }

        @Override
        public boolean isShared() {
            return this.shared;
        }

        @Override
        public boolean shouldApplyToJaxRs() {
            return this.applyToJaxRs;
        }

        @Override
        public Set<String> getMethods() {
            return this.methods == null ? Set.of() : Set.of(this.methods);
        }

        @Override
        public HttpSecurityConfiguration.AuthenticationMechanism getAuthMechanism() {
            return this.authMechanism;
        }

        @Override
        public HttpSecurityConfiguration.Policy getPolicy() {
            if (this.authorizationPolicy == null || this.authorizationPolicy.policy == null) {
                throw new IllegalStateException("Authorization Policy has not been set for paths: " + String.valueOf(this.getPaths()));
            }
            return this.authorizationPolicy.policy;
        }
    }

    private static final class SimpleHttpSecurityPolicy
    implements HttpSecurityPolicy {
        private final BiPredicate<SecurityIdentity, RoutingContext> predicate;

        private SimpleHttpSecurityPolicy(BiPredicate<SecurityIdentity, RoutingContext> predicate) {
            this.predicate = predicate;
        }

        @Override
        public Uni<HttpSecurityPolicy.CheckResult> checkPermission(final RoutingContext request, Uni<SecurityIdentity> identityUni, HttpSecurityPolicy.AuthorizationRequestContext requestContext) {
            return identityUni.onItemOrFailure().transform((BiFunction)new BiFunction<SecurityIdentity, Throwable, HttpSecurityPolicy.CheckResult>(){

                @Override
                public HttpSecurityPolicy.CheckResult apply(SecurityIdentity securityIdentity, Throwable throwable) {
                    boolean deny;
                    if (securityIdentity == null) {
                        return HttpSecurityPolicy.CheckResult.DENY;
                    }
                    if (throwable != null) {
                        LOG.debug((Object)"Failed to retrieve SecurityIdentity, denying access", throwable);
                        return HttpSecurityPolicy.CheckResult.DENY;
                    }
                    try {
                        deny = !predicate.test(securityIdentity, request);
                    }
                    catch (Exception e) {
                        LOG.debug((Object)"Failed to check permission, denying access", (Throwable)e);
                        deny = true;
                    }
                    return deny ? HttpSecurityPolicy.CheckResult.DENY : HttpSecurityPolicy.CheckResult.PERMIT;
                }
            });
        }
    }

    private static final class PermissionsHttpSecurityPolicy
    implements HttpSecurityPolicy {
        private final Permission[] permissions;

        private PermissionsHttpSecurityPolicy(Permission[] permissions) {
            this.permissions = Arrays.copyOf(permissions, permissions.length);
        }

        @Override
        public Uni<HttpSecurityPolicy.CheckResult> checkPermission(RoutingContext request, Uni<SecurityIdentity> identityUni, HttpSecurityPolicy.AuthorizationRequestContext requestContext) {
            return identityUni.onItemOrFailure().transformToUni((BiFunction)new BiFunction<SecurityIdentity, Throwable, Uni<? extends HttpSecurityPolicy.CheckResult>>(){

                @Override
                public Uni<? extends HttpSecurityPolicy.CheckResult> apply(SecurityIdentity securityIdentity, Throwable throwable) {
                    if (throwable != null || securityIdentity == null || securityIdentity.isAnonymous()) {
                        if (throwable != null) {
                            LOG.debug((Object)"Authentication failed, denying access", throwable);
                        }
                        return HttpSecurityPolicy.CheckResult.deny();
                    }
                    return this.logicalAndPermissionCheck(securityIdentity, 0);
                }
            });
        }

        private Uni<HttpSecurityPolicy.CheckResult> logicalAndPermissionCheck(final SecurityIdentity securityIdentity, final int i) {
            if (this.permissions.length == i) {
                return HttpSecurityPolicy.CheckResult.permit();
            }
            return securityIdentity.checkPermission(this.permissions[i]).onItemOrFailure().transformToUni((BiFunction)new BiFunction<Boolean, Throwable, Uni<? extends HttpSecurityPolicy.CheckResult>>(){

                @Override
                public Uni<? extends HttpSecurityPolicy.CheckResult> apply(Boolean aBoolean, Throwable throwable) {
                    if (throwable == null && Boolean.TRUE.equals(aBoolean)) {
                        return this.logicalAndPermissionCheck(securityIdentity, i + 1);
                    }
                    if (throwable != null) {
                        LOG.debug((Object)"Failed to check permission, denying access", throwable);
                    }
                    return HttpSecurityPolicy.CheckResult.deny();
                }
            });
        }
    }

    private final class AuthorizationPolicy
    implements HttpSecurity.Authorization {
        private HttpSecurityConfiguration.Policy policy = null;

        private AuthorizationPolicy() {
        }

        @Override
        public HttpSecurity permit() {
            this.validatePolicyNotSetYet();
            this.policy = new HttpSecurityConfiguration.Policy("permit", null);
            return HttpSecurityImpl.this;
        }

        @Override
        public HttpSecurity deny() {
            this.validatePolicyNotSetYet();
            this.policy = new HttpSecurityConfiguration.Policy("deny", null);
            return HttpSecurityImpl.this;
        }

        @Override
        public HttpSecurity roles(Map<String, List<String>> roleToRoles, String ... roles) {
            this.validatePolicyNotSetYet();
            if (roles == null || roles.length == 0) {
                throw new IllegalArgumentException("Roles must not be empty");
            }
            if (roleToRoles == null) {
                throw new IllegalArgumentException("Role to roles mapping must not be null");
            }
            this.policy = new HttpSecurityConfiguration.Policy(null, new RolesAllowedHttpSecurityPolicy(Arrays.asList(roles), null, roleToRoles));
            return HttpSecurityImpl.this;
        }

        @Override
        public HttpSecurity roles(String ... roles) {
            return this.roles(Map.of(), roles);
        }

        @Override
        public HttpSecurity permissions(Permission ... permissions) {
            this.validatePolicyNotSetYet();
            if (permissions == null || permissions.length == 0) {
                throw new IllegalArgumentException("Permissions must not be empty");
            }
            this.policy = new HttpSecurityConfiguration.Policy(null, new PermissionsHttpSecurityPolicy(permissions));
            return HttpSecurityImpl.this;
        }

        @Override
        public HttpSecurity permissions(String ... permissionNames) {
            Objects.requireNonNull(permissionNames);
            StringPermission[] stringPermissions = new StringPermission[permissionNames.length];
            for (int i = 0; i < permissionNames.length; ++i) {
                stringPermissions[i] = new StringPermission(permissionNames[i], new String[0]);
            }
            return this.permissions((Permission[])stringPermissions);
        }

        @Override
        public HttpSecurity policy(HttpSecurityPolicy httpSecurityPolicy) {
            this.validatePolicyNotSetYet();
            if (httpSecurityPolicy == null) {
                throw new IllegalArgumentException("HttpSecurityPolicy must not be null");
            }
            this.policy = new HttpSecurityConfiguration.Policy(null, httpSecurityPolicy);
            return HttpSecurityImpl.this;
        }

        @Override
        public HttpSecurity policy(Predicate<SecurityIdentity> predicate) {
            return this.policy((SecurityIdentity identity, RoutingContext request) -> !identity.isAnonymous() && predicate.test((SecurityIdentity)identity));
        }

        @Override
        public HttpSecurity policy(BiPredicate<SecurityIdentity, RoutingContext> predicate) {
            return this.policy(new SimpleHttpSecurityPolicy(predicate));
        }

        private HttpSecurity authenticated() {
            this.validatePolicyNotSetYet();
            this.policy = new HttpSecurityConfiguration.Policy("authenticated", null);
            return HttpSecurityImpl.this;
        }

        private void validatePolicyNotSetYet() {
            if (this.policy != null) {
                throw new IllegalArgumentException("Policy has already been set");
            }
        }
    }
}

