/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.security;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.quarkus.arc.Arc;
import io.quarkus.arc.ClientProxy;
import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.identity.IdentityProvider;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.AnonymousAuthenticationRequest;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.quarkus.security.identity.request.UsernamePasswordAuthenticationRequest;
import io.quarkus.security.spi.runtime.AuthenticationFailureEvent;
import io.quarkus.security.spi.runtime.AuthenticationSuccessEvent;
import io.quarkus.security.spi.runtime.SecurityEvent;
import io.quarkus.security.spi.runtime.SecurityEventHelper;
import io.quarkus.vertx.http.runtime.AuthRuntimeConfig;
import io.quarkus.vertx.http.runtime.PolicyMappingConfig;
import io.quarkus.vertx.http.runtime.VertxHttpBuildTimeConfig;
import io.quarkus.vertx.http.runtime.VertxHttpConfig;
import io.quarkus.vertx.http.runtime.security.AbstractPathMatchingHttpSecurityPolicy;
import io.quarkus.vertx.http.runtime.security.BasicAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.ChallengeData;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.HttpCredentialTransport;
import io.quarkus.vertx.http.runtime.security.HttpSecurityUtils;
import io.quarkus.vertx.http.runtime.security.MtlsAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.RoutingContextAwareSecurityIdentity;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.mutiny.Uni;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.jboss.logging.Logger;

@Singleton
public final class HttpAuthenticator {
    public static final String TEST_IF_BASIC_AUTH_IMPLICITLY_REQUIRED = "io.quarkus.security.http.test-if-basic-auth-implicitly-required";
    public static final String BASIC_AUTH_ANNOTATION_DETECTED = "io.quarkus.security.http.basic-authentication-annotation-detected";
    private static final Logger log = Logger.getLogger(HttpAuthenticator.class);
    private static final String AUTH_MECHANISM = HttpAuthenticator.class.getName() + "#auth-mechanism";
    private static final String ATTEMPT_AUTH_INVOKED = HttpAuthenticator.class.getName() + "#attemptAuthentication";
    private static boolean selectAuthMechanismWithAnnotation = false;
    private final IdentityProviderManager identityProviderManager;
    private final HttpAuthenticationMechanism[] mechanisms;
    private final SecurityEventHelper<AuthenticationSuccessEvent, AuthenticationFailureEvent> securityEventHelper;
    private final boolean inclusiveAuth;
    private final boolean strictInclusiveMode;

    HttpAuthenticator(IdentityProviderManager identityProviderManager, Event<AuthenticationFailureEvent> authFailureEvent, Event<AuthenticationSuccessEvent> authSuccessEvent, BeanManager beanManager, VertxHttpBuildTimeConfig httpBuildTimeConfig, VertxHttpConfig httpConfig, Instance<HttpAuthenticationMechanism> httpAuthenticationMechanism, Instance<IdentityProvider<?>> providers, @ConfigProperty(name="quarkus.security.events.enabled") boolean securityEventsEnabled) {
        this.securityEventHelper = new SecurityEventHelper(authSuccessEvent, authFailureEvent, (SecurityEvent)SecurityEventHelper.AUTHENTICATION_SUCCESS, (SecurityEvent)SecurityEventHelper.AUTHENTICATION_FAILURE, beanManager, securityEventsEnabled);
        this.identityProviderManager = identityProviderManager;
        this.inclusiveAuth = httpConfig.auth().inclusive();
        this.strictInclusiveMode = httpConfig.auth().inclusiveMode() == AuthRuntimeConfig.InclusiveMode.STRICT;
        ArrayList<HttpAuthenticationMechanism> mechanisms = new ArrayList<HttpAuthenticationMechanism>();
        for (HttpAuthenticationMechanism mechanism : httpAuthenticationMechanism) {
            if (mechanism.getCredentialTypes().isEmpty()) {
                log.debugf("HttpAuthenticationMechanism '%s' provided no required credential types, therefore it needs to be able to perform authentication without any IdentityProvider", (Object)mechanism.getClass().getName());
                mechanisms.add(mechanism);
                continue;
            }
            boolean found = false;
            for (Class<? extends AuthenticationRequest> mechType : mechanism.getCredentialTypes()) {
                for (IdentityProvider i : providers) {
                    if (!i.getRequestType().equals(mechType)) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
                break;
            }
            if (found) {
                mechanisms.add(mechanism);
                continue;
            }
            if (BasicAuthenticationMechanism.class.equals(mechanism.getClass()) && httpBuildTimeConfig.auth().basic().isEmpty()) {
                log.debug((Object)"BasicAuthenticationMechanism has been enabled because no other authentication mechanism has been\ndetected, but there is no IdentityProvider based on username and password. Please use\none of supported extensions if you plan to use the mechanism.\nFor more information go to the https://quarkus.io/guides/security-basic-authentication-howto.\n");
                continue;
            }
            throw new RuntimeException("HttpAuthenticationMechanism '%s' requires one or more IdentityProviders supporting at least one\nof the following credentials types: %s.\nPlease refer to the https://quarkus.io/guides/security-identity-providers for more information.\n".formatted(mechanism.getClass().getName(), mechanism.getCredentialTypes()));
        }
        HttpAuthenticator.addBasicAuthMechanismIfImplicitlyRequired(httpAuthenticationMechanism, mechanisms, providers);
        if (mechanisms.isEmpty()) {
            this.mechanisms = new HttpAuthenticationMechanism[]{new NoAuthenticationMechanism()};
        } else {
            HttpAuthenticationMechanism topMechanism;
            boolean isMutualTls;
            mechanisms.sort(new Comparator<HttpAuthenticationMechanism>(){

                @Override
                public int compare(HttpAuthenticationMechanism mech1, HttpAuthenticationMechanism mech2) {
                    return Integer.compare(mech2.getPriority(), mech1.getPriority());
                }
            });
            this.mechanisms = mechanisms.toArray(new HttpAuthenticationMechanism[mechanisms.size()]);
            if (this.inclusiveAuth && Arc.container().instance(MtlsAuthenticationMechanism.class, new Annotation[0]).isAvailable() && !(isMutualTls = (topMechanism = (HttpAuthenticationMechanism)ClientProxy.unwrap((Object)this.mechanisms[0])) instanceof MtlsAuthenticationMechanism)) {
                throw new IllegalStateException("Inclusive authentication is enabled and '%s' does not have\nthe highest priority. Please lower priority of the '%s' authentication mechanism under '%s'.\n".formatted(MtlsAuthenticationMechanism.class.getName(), topMechanism.getClass().getName(), 3000));
            }
        }
    }

    public IdentityProviderManager getIdentityProviderManager() {
        return this.identityProviderManager;
    }

    public Uni<SecurityIdentity> attemptAuthentication(final RoutingContext routingContext) {
        AbstractPathMatchingHttpSecurityPolicy pathMatchingPolicy;
        if (selectAuthMechanismWithAnnotation) {
            HttpAuthenticator.rememberAuthAttempted(routingContext);
        }
        String pathSpecificMechanism = selectAuthMechanismWithAnnotation && HttpAuthenticator.isAuthMechanismSelected(routingContext) ? (String)routingContext.get(AUTH_MECHANISM) : ((pathMatchingPolicy = (AbstractPathMatchingHttpSecurityPolicy)routingContext.get(AbstractPathMatchingHttpSecurityPolicy.class.getName())) != null ? pathMatchingPolicy.getAuthMechanismName(routingContext) : null);
        Uni result = pathSpecificMechanism == null ? this.createSecurityIdentity(routingContext, 0) : this.findBestCandidateMechanism(routingContext, pathSpecificMechanism, 0).onItem().ifNotNull().transformToUni((Function)new Function<HttpAuthenticationMechanism, Uni<? extends SecurityIdentity>>(){

            @Override
            public Uni<SecurityIdentity> apply(HttpAuthenticationMechanism mech) {
                return mech.authenticate(routingContext, HttpAuthenticator.this.identityProviderManager);
            }
        });
        if (this.inclusiveAuth && this.strictInclusiveMode && pathSpecificMechanism == null) {
            result = result.onItem().ifNotNull().transformToUni((Function)new Function<SecurityIdentity, Uni<? extends SecurityIdentity>>(){

                @Override
                public Uni<? extends SecurityIdentity> apply(SecurityIdentity identity) {
                    Map<String, SecurityIdentity> identities = HttpSecurityUtils.getSecurityIdentities(routingContext);
                    if (identities == null || identities.size() != HttpAuthenticator.this.mechanisms.length) {
                        return Uni.createFrom().failure((Throwable)new AuthenticationFailedException("There is '%d' HTTP authentication mechanisms, however only '%d' authentication mechanisms\ncreated identity: %s\n".formatted(identities == null ? 0 : identities.size(), HttpAuthenticator.this.mechanisms.length, identities == null ? "" : identities.keySet())));
                    }
                    return Uni.createFrom().item((Object)identity);
                }
            });
        }
        if (routingContext.get("io.quarkus.vertx.http.runtime.security.RolesMapping") != null) {
            result = result.onItem().ifNotNull().transform((Function)routingContext.get("io.quarkus.vertx.http.runtime.security.RolesMapping"));
        }
        if (this.securityEventHelper.fireEventOnFailure()) {
            result = result.onFailure().invoke((Consumer)new Consumer<Throwable>(){

                @Override
                public void accept(Throwable throwable) {
                    HttpAuthenticator.this.securityEventHelper.fireFailureEvent((SecurityEvent)new AuthenticationFailureEvent(throwable, Map.of(RoutingContext.class.getName(), routingContext)));
                }
            });
        }
        if (this.securityEventHelper.fireEventOnSuccess()) {
            result = result.onItem().ifNotNull().invoke((Consumer)new Consumer<SecurityIdentity>(){

                @Override
                public void accept(SecurityIdentity securityIdentity) {
                    HttpAuthenticator.this.securityEventHelper.fireSuccessEvent((SecurityEvent)new AuthenticationSuccessEvent(securityIdentity, Map.of(RoutingContext.class.getName(), routingContext)));
                }
            });
        }
        return result;
    }

    private Uni<SecurityIdentity> createSecurityIdentity(final RoutingContext routingContext, final int i) {
        if (i == this.mechanisms.length) {
            return Uni.createFrom().nullItem();
        }
        return this.mechanisms[i].authenticate(routingContext, this.identityProviderManager).onItem().transformToUni((Function)new Function<SecurityIdentity, Uni<? extends SecurityIdentity>>(){

            @Override
            public Uni<SecurityIdentity> apply(SecurityIdentity identity) {
                if (identity != null) {
                    if (HttpAuthenticator.this.inclusiveAuth) {
                        return HttpAuthenticator.this.authenticateWithAllMechanisms(identity, i, routingContext);
                    }
                    if (selectAuthMechanismWithAnnotation && !HttpAuthenticator.isAuthMechanismSelected(routingContext)) {
                        return HttpAuthenticator.rememberAuthMechScheme(HttpAuthenticator.this.mechanisms[i], routingContext).replaceWith((Object)identity);
                    }
                    return Uni.createFrom().item((Object)identity);
                }
                return HttpAuthenticator.this.createSecurityIdentity(routingContext, i + 1);
            }
        });
    }

    public Uni<Boolean> sendChallenge(final RoutingContext routingContext) {
        HttpAuthenticationMechanism matchingMech;
        if (!routingContext.request().isEnded()) {
            routingContext.request().resume();
        }
        Uni result = null;
        if (this.mechanisms.length > 1 && (matchingMech = (HttpAuthenticationMechanism)routingContext.get(HttpAuthenticationMechanism.class.getName())) != null) {
            result = matchingMech.sendChallenge(routingContext);
        }
        if (result == null) {
            result = this.mechanisms[0].sendChallenge(routingContext);
            for (int i = 1; i < this.mechanisms.length; ++i) {
                final HttpAuthenticationMechanism mech = this.mechanisms[i];
                result = result.onItem().transformToUni((Function)new Function<Boolean, Uni<? extends Boolean>>(){

                    @Override
                    public Uni<? extends Boolean> apply(Boolean authDone) {
                        if (authDone.booleanValue()) {
                            return Uni.createFrom().item((Object)authDone);
                        }
                        return mech.sendChallenge(routingContext);
                    }
                });
            }
        }
        return result.onItem().transformToUni((Function)new Function<Boolean, Uni<? extends Boolean>>(){

            @Override
            public Uni<? extends Boolean> apply(Boolean authDone) {
                if (!authDone.booleanValue()) {
                    log.debug((Object)"Authentication has not been done, returning HTTP status 401");
                    routingContext.response().setStatusCode(401);
                    if (routingContext.get("io.quarkus.vertx.http.runtime.security.dev-mode.auth-failure-body") == null) {
                        routingContext.response().end();
                    } else {
                        String authenticationFailureBody = (String)routingContext.get("io.quarkus.vertx.http.runtime.security.dev-mode.auth-failure-body");
                        routingContext.response().end(authenticationFailureBody);
                    }
                }
                return Uni.createFrom().item((Object)authDone);
            }
        });
    }

    public Uni<ChallengeData> getChallenge(final RoutingContext routingContext) {
        HttpAuthenticationMechanism matchingMech;
        if (this.mechanisms.length > 1 && (matchingMech = (HttpAuthenticationMechanism)routingContext.get(HttpAuthenticationMechanism.class.getName())) != null) {
            return matchingMech.getChallenge(routingContext);
        }
        Uni result = this.mechanisms[0].getChallenge(routingContext);
        for (int i = 1; i < this.mechanisms.length; ++i) {
            final HttpAuthenticationMechanism mech = this.mechanisms[i];
            result = result.onItem().transformToUni((Function)new Function<ChallengeData, Uni<? extends ChallengeData>>(){

                @Override
                public Uni<? extends ChallengeData> apply(ChallengeData data) {
                    if (data != null) {
                        return Uni.createFrom().item((Object)data);
                    }
                    return mech.getChallenge(routingContext);
                }
            });
        }
        return result;
    }

    private Uni<SecurityIdentity> authenticateWithAllMechanisms(final SecurityIdentity identity, final int i, final RoutingContext routingContext) {
        return HttpAuthenticator.getCredentialTransport(this.mechanisms[i], routingContext).onItem().transformToUni((Function)new Function<HttpCredentialTransport, Uni<? extends SecurityIdentity>>(){

            @Override
            public Uni<SecurityIdentity> apply(HttpCredentialTransport httpCredentialTransport) {
                boolean isFirstIdentity;
                if (httpCredentialTransport == null || httpCredentialTransport.getAuthenticationScheme() == null) {
                    log.error((Object)"Illegal state - HttpAuthenticationMechanism '%s' authentication scheme is not available.\nThe authentication scheme is required when inclusive authentication is enabled.\n".formatted(((HttpAuthenticationMechanism)ClientProxy.unwrap((Object)HttpAuthenticator.this.mechanisms[i])).getClass().getName()));
                    return Uni.createFrom().failure((Throwable)new AuthenticationFailedException());
                }
                String authMechanism = httpCredentialTransport.getAuthenticationScheme();
                Map<String, SecurityIdentity> authMechToIdentity = HttpSecurityUtils.getSecurityIdentities(routingContext);
                boolean bl = isFirstIdentity = authMechToIdentity == null;
                if (isFirstIdentity) {
                    authMechToIdentity = new HashMap<String, SecurityIdentity>();
                    routingContext.put("io.quarkus.security.identities", authMechToIdentity);
                }
                authMechToIdentity.putIfAbsent(authMechanism, identity);
                if (isFirstIdentity) {
                    return HttpAuthenticator.this.createSecurityIdentity(routingContext, i + 1).replaceWith((Object)RoutingContextAwareSecurityIdentity.addRoutingCtxToIdentityIfMissing(identity, routingContext));
                }
                return HttpAuthenticator.this.createSecurityIdentity(routingContext, i + 1);
            }
        });
    }

    private Uni<HttpAuthenticationMechanism> findBestCandidateMechanism(final RoutingContext routingContext, final String pathSpecificMechanism, final int i) {
        if (i == this.mechanisms.length) {
            return Uni.createFrom().nullItem();
        }
        return this.getPathSpecificMechanism(i, routingContext, pathSpecificMechanism).onItem().transformToUni((Function)new Function<HttpAuthenticationMechanism, Uni<? extends HttpAuthenticationMechanism>>(){

            @Override
            public Uni<? extends HttpAuthenticationMechanism> apply(HttpAuthenticationMechanism mech) {
                if (mech != null) {
                    if (selectAuthMechanismWithAnnotation && !HttpAuthenticator.isAuthMechanismSelected(routingContext)) {
                        return HttpAuthenticator.rememberAuthMechScheme(mech, routingContext).replaceWith((Object)mech);
                    }
                    return Uni.createFrom().item((Object)mech);
                }
                return HttpAuthenticator.this.findBestCandidateMechanism(routingContext, pathSpecificMechanism, i + 1);
            }
        });
    }

    private Uni<HttpAuthenticationMechanism> getPathSpecificMechanism(final int index, final RoutingContext routingContext, final String pathSpecificMechanism) {
        return HttpAuthenticator.getCredentialTransport(this.mechanisms[index], routingContext).onItem().transform((Function)new Function<HttpCredentialTransport, HttpAuthenticationMechanism>(){

            @Override
            public HttpAuthenticationMechanism apply(HttpCredentialTransport t) {
                if (t != null && t.getAuthenticationScheme().equalsIgnoreCase(pathSpecificMechanism)) {
                    routingContext.put(HttpAuthenticationMechanism.class.getName(), (Object)HttpAuthenticator.this.mechanisms[index]);
                    routingContext.put(AUTH_MECHANISM, (Object)t.getAuthenticationScheme());
                    return HttpAuthenticator.this.mechanisms[index];
                }
                return null;
            }
        });
    }

    static void selectAuthMechanismWithAnnotation() {
        selectAuthMechanismWithAnnotation = true;
    }

    static void selectAuthMechanism(RoutingContext routingContext, String authMechanism) {
        if (HttpAuthenticator.requestAlreadyAuthenticated(routingContext, authMechanism)) {
            throw new AuthenticationFailedException("The '%1$s' authentication mechanism is required to authenticate the request but it was already\nauthenticated with the '%2$s' authentication mechanism. It can happen if the '%1$s' is selected with\nan annotation but '%2$s' is activated by the HTTP security policy which is enforced before\nthe JAX-RS chain is run. In such cases, please set the\n'quarkus.http.auth.permission.\"permissions\".applies-to=JAXRS' to all HTTP security policies\nwhich secure the same REST endpoints as the ones secured by the '%1$s' authentication mechanism\nselected with the annotation.\n".formatted(authMechanism, routingContext.get(AUTH_MECHANISM)));
        }
        routingContext.put(AUTH_MECHANISM, (Object)authMechanism);
    }

    private static Uni<HttpCredentialTransport> getCredentialTransport(HttpAuthenticationMechanism mechanism, RoutingContext routingContext) {
        try {
            return mechanism.getCredentialTransport(routingContext);
        }
        catch (UnsupportedOperationException ex) {
            return Uni.createFrom().item((Object)mechanism.getCredentialTransport());
        }
    }

    private static void rememberAuthAttempted(RoutingContext routingContext) {
        routingContext.put(ATTEMPT_AUTH_INVOKED, (Object)Boolean.TRUE);
    }

    private static boolean isAuthMechanismSelected(RoutingContext routingContext) {
        return routingContext.get(AUTH_MECHANISM) != null;
    }

    private static boolean requestAlreadyAuthenticated(RoutingContext event, String newAuthMechanism) {
        return event.get(ATTEMPT_AUTH_INVOKED) == Boolean.TRUE && HttpAuthenticator.authenticatedWithDifferentAuthMechanism(newAuthMechanism, event);
    }

    private static boolean authenticatedWithDifferentAuthMechanism(String newAuthMechanism, RoutingContext event) {
        return !newAuthMechanism.equalsIgnoreCase((String)event.get(AUTH_MECHANISM));
    }

    private static Uni<HttpCredentialTransport> rememberAuthMechScheme(HttpAuthenticationMechanism mech, final RoutingContext event) {
        return HttpAuthenticator.getCredentialTransport(mech, event).onItem().ifNotNull().invoke((Consumer)new Consumer<HttpCredentialTransport>(){

            @Override
            public void accept(HttpCredentialTransport t) {
                if (t.getAuthenticationScheme() != null) {
                    event.put(AUTH_MECHANISM, (Object)t.getAuthenticationScheme());
                }
            }
        });
    }

    private static void addBasicAuthMechanismIfImplicitlyRequired(Instance<HttpAuthenticationMechanism> httpAuthenticationMechanism, List<HttpAuthenticationMechanism> mechanisms, Instance<IdentityProvider<?>> providers) {
        if (!Boolean.getBoolean(TEST_IF_BASIC_AUTH_IMPLICITLY_REQUIRED) || HttpAuthenticator.isBasicAuthNotRequired()) {
            return;
        }
        Instance basicAuthMechInstance = httpAuthenticationMechanism.select(BasicAuthenticationMechanism.class, new Annotation[0]);
        if (basicAuthMechInstance.isResolvable() && !mechanisms.contains(basicAuthMechInstance.get())) {
            for (IdentityProvider i : providers) {
                if (!UsernamePasswordAuthenticationRequest.class.equals((Object)i.getRequestType())) continue;
                mechanisms.add((HttpAuthenticationMechanism)basicAuthMechInstance.get());
                return;
            }
            log.debug((Object)"BasicAuthenticationMechanism has been enabled because no custom authentication mechanism has been detected\nand basic authentication is required either by the HTTP Security Policy or '@BasicAuthentication', but\nthere is no IdentityProvider based on username and password. Please use one of supported extensions.\nFor more information, go to the https://quarkus.io/guides/security-basic-authentication-howto.\n");
        }
    }

    private static boolean isBasicAuthNotRequired() {
        if (Boolean.getBoolean(BASIC_AUTH_ANNOTATION_DETECTED)) {
            return false;
        }
        VertxHttpConfig httpConfig = (VertxHttpConfig)((SmallRyeConfig)ConfigProvider.getConfig().unwrap(SmallRyeConfig.class)).getConfigMapping(VertxHttpConfig.class);
        for (PolicyMappingConfig policy : httpConfig.auth().permissions().values()) {
            if (!"basic".equals(policy.authMechanism().orElse(null))) continue;
            return false;
        }
        return true;
    }

    static class NoAuthenticationMechanism
    implements HttpAuthenticationMechanism {
        NoAuthenticationMechanism() {
        }

        @Override
        public Uni<SecurityIdentity> authenticate(RoutingContext context, IdentityProviderManager identityProviderManager) {
            return Uni.createFrom().optional(Optional.empty());
        }

        @Override
        public Uni<ChallengeData> getChallenge(RoutingContext context) {
            ChallengeData challengeData = new ChallengeData(HttpResponseStatus.FORBIDDEN.code(), null, null);
            return Uni.createFrom().item((Object)challengeData);
        }

        @Override
        public Set<Class<? extends AuthenticationRequest>> getCredentialTypes() {
            return Collections.singleton(AnonymousAuthenticationRequest.class);
        }

        @Override
        public Uni<HttpCredentialTransport> getCredentialTransport(RoutingContext context) {
            return Uni.createFrom().nullItem();
        }
    }
}

