/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.cors;

import io.quarkus.vertx.http.runtime.cors.CORSConfig;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;

public class CORSFilter
implements Handler<RoutingContext> {
    private static final Pattern COMMA_SEPARATED_SPLIT_REGEX = Pattern.compile("\\s*,\\s*");
    final CORSConfig corsConfig;
    final List<Pattern> allowedOriginsRegex;
    private final List<HttpMethod> configuredHttpMethods;

    public CORSFilter(CORSConfig corsConfig) {
        this.corsConfig = corsConfig;
        this.allowedOriginsRegex = CORSFilter.parseAllowedOriginsRegex(this.corsConfig.origins);
        this.configuredHttpMethods = this.createConfiguredHttpMethods(this.corsConfig.methods);
    }

    private List<HttpMethod> createConfiguredHttpMethods(Optional<List<String>> methods) {
        if (methods.isEmpty()) {
            return Collections.emptyList();
        }
        List<String> corsConfigMethods = methods.get();
        ArrayList<HttpMethod> result = new ArrayList<HttpMethod>(corsConfigMethods.size());
        for (String value : corsConfigMethods) {
            result.add(HttpMethod.valueOf((String)value));
        }
        return result;
    }

    public static boolean isConfiguredWithWildcard(Optional<List<String>> optionalList) {
        if (optionalList == null || !optionalList.isPresent()) {
            return true;
        }
        List<String> list = optionalList.get();
        return list.isEmpty() || list.size() == 1 && "*".equals(list.get(0));
    }

    public static List<Pattern> parseAllowedOriginsRegex(Optional<List<String>> allowedOrigins) {
        if (allowedOrigins == null || !allowedOrigins.isPresent()) {
            return Collections.emptyList();
        }
        ArrayList<Pattern> allowOriginsRegex = new ArrayList<Pattern>();
        for (String o : allowedOrigins.get()) {
            if (o == null || !o.startsWith("/") || !o.endsWith("/")) continue;
            allowOriginsRegex.add(Pattern.compile(o.substring(1, o.length() - 1)));
        }
        return allowOriginsRegex;
    }

    public static boolean isOriginAllowedByRegex(List<Pattern> allowOriginsRegex, String origin) {
        if (allowOriginsRegex == null) {
            return false;
        }
        for (Pattern pattern : allowOriginsRegex) {
            if (!pattern.matcher(origin).matches()) continue;
            return true;
        }
        return false;
    }

    private void processRequestedHeaders(HttpServerResponse response, String allowHeadersValue) {
        if (CORSFilter.isConfiguredWithWildcard(this.corsConfig.headers)) {
            response.headers().set(HttpHeaders.ACCESS_CONTROL_ALLOW_HEADERS, (CharSequence)allowHeadersValue);
        } else {
            String[] allowedParts = COMMA_SEPARATED_SPLIT_REGEX.split(allowHeadersValue);
            ArrayList<String> requestedHeaders = new ArrayList<String>(allowedParts.length);
            for (String requestedHeader : allowedParts) {
                requestedHeaders.add(requestedHeader.toLowerCase());
            }
            List<String> corsConfigHeaders = this.corsConfig.headers.get();
            StringBuilder allowedHeaders = new StringBuilder();
            boolean isFirst = true;
            for (String configHeader : corsConfigHeaders) {
                if (!requestedHeaders.contains(configHeader.toLowerCase())) continue;
                if (isFirst) {
                    isFirst = false;
                } else {
                    allowedHeaders.append(',');
                }
                allowedHeaders.append(configHeader);
            }
            if (allowedHeaders.length() != 0) {
                response.headers().set(HttpHeaders.ACCESS_CONTROL_ALLOW_HEADERS, (CharSequence)allowedHeaders.toString());
            }
        }
    }

    private void processMethods(HttpServerResponse response, String allowMethodsValue) {
        if (CORSFilter.isConfiguredWithWildcard(this.corsConfig.methods)) {
            response.headers().set(HttpHeaders.ACCESS_CONTROL_ALLOW_METHODS, (CharSequence)allowMethodsValue);
        } else {
            String[] allowedMethodsParts = COMMA_SEPARATED_SPLIT_REGEX.split(allowMethodsValue);
            ArrayList<String> requestedMethods = new ArrayList<String>(allowedMethodsParts.length);
            for (String requestedMethod : allowedMethodsParts) {
                requestedMethods.add(requestedMethod.toLowerCase());
            }
            StringBuilder allowMethods = new StringBuilder();
            boolean isFirst = true;
            for (HttpMethod configMethod : this.configuredHttpMethods) {
                if (!requestedMethods.contains(configMethod.name().toLowerCase())) continue;
                if (isFirst) {
                    isFirst = false;
                } else {
                    allowMethods.append(',');
                }
                allowMethods.append(configMethod.name());
            }
            if (allowMethods.length() != 0) {
                response.headers().set(HttpHeaders.ACCESS_CONTROL_ALLOW_METHODS, (CharSequence)allowMethods.toString());
            }
        }
    }

    public void handle(RoutingContext event) {
        Objects.requireNonNull(this.corsConfig, "CORS config is not set");
        HttpServerRequest request = event.request();
        HttpServerResponse response = event.response();
        String origin = request.getHeader(HttpHeaders.ORIGIN);
        if (origin == null) {
            event.next();
        } else {
            boolean allowsOrigin;
            String requestedHeaders;
            String requestedMethods = request.getHeader(HttpHeaders.ACCESS_CONTROL_REQUEST_METHOD);
            if (requestedMethods != null) {
                this.processMethods(response, requestedMethods);
            }
            if ((requestedHeaders = request.getHeader(HttpHeaders.ACCESS_CONTROL_REQUEST_HEADERS)) != null) {
                this.processRequestedHeaders(response, requestedHeaders);
            }
            boolean bl = allowsOrigin = CORSFilter.isConfiguredWithWildcard(this.corsConfig.origins) || this.corsConfig.origins.get().contains(origin) || CORSFilter.isOriginAllowedByRegex(this.allowedOriginsRegex, origin);
            if (allowsOrigin) {
                response.headers().set(HttpHeaders.ACCESS_CONTROL_ALLOW_ORIGIN, (CharSequence)origin);
            }
            boolean allowCredentials = this.corsConfig.accessControlAllowCredentials.orElseGet(() -> this.corsConfig.origins.isPresent() && this.corsConfig.origins.get().contains(origin) && !origin.equals("*"));
            response.headers().set(HttpHeaders.ACCESS_CONTROL_ALLOW_CREDENTIALS, (CharSequence)String.valueOf(allowCredentials));
            Optional<List<String>> exposedHeaders = this.corsConfig.exposedHeaders;
            if (!CORSFilter.isConfiguredWithWildcard(exposedHeaders)) {
                response.headers().set(HttpHeaders.ACCESS_CONTROL_EXPOSE_HEADERS, (CharSequence)String.join((CharSequence)",", exposedHeaders.orElse(Collections.emptyList())));
            }
            if (request.method().equals((Object)HttpMethod.OPTIONS) && (requestedHeaders != null || requestedMethods != null)) {
                if (this.corsConfig.accessControlMaxAge.isPresent()) {
                    response.putHeader(HttpHeaders.ACCESS_CONTROL_MAX_AGE, (CharSequence)String.valueOf(this.corsConfig.accessControlMaxAge.get().getSeconds()));
                }
                response.end();
            } else {
                event.next();
            }
        }
    }
}

