/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.attribute;

import io.quarkus.vertx.http.runtime.attribute.ExchangeAttribute;
import io.quarkus.vertx.http.runtime.attribute.ExchangeAttributeBuilder;
import io.quarkus.vertx.http.runtime.attribute.ReadOnlyAttributeException;
import io.vertx.ext.web.Cookie;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.impl.CookieImpl;

public class CookieAttribute
implements ExchangeAttribute {
    private final String cookieName;

    public CookieAttribute(String cookieName) {
        this.cookieName = cookieName;
    }

    @Override
    public String readAttribute(RoutingContext exchange) {
        Cookie cookie = exchange.getCookie(this.cookieName);
        if (cookie == null) {
            return null;
        }
        return cookie.getValue();
    }

    @Override
    public void writeAttribute(RoutingContext exchange, String newValue) throws ReadOnlyAttributeException {
        exchange.response().addCookie((io.vertx.core.http.Cookie)new CookieImpl(this.cookieName, newValue));
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Cookie";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.startsWith("%{c,") && token.endsWith("}")) {
                String cookieName = token.substring(4, token.length() - 1);
                return new CookieAttribute(cookieName);
            }
            return null;
        }

        @Override
        public int priority() {
            return 0;
        }
    }
}

