/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.spi.workspace;

import io.quarkus.devui.spi.workspace.ActionBuilder;
import io.quarkus.devui.spi.workspace.Display;
import io.quarkus.devui.spi.workspace.DisplayType;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;

public class Action<T, R> {
    private final String label;
    private final String namespace;
    private final Function<T, R> function;
    private final Optional<Pattern> filter;
    private final Display display;
    private final DisplayType displayType;
    private final Function<Path, Path> pathConverter;
    private static final String SPACE = " ";
    private static final String DASH = "-";
    private static final String SLASH = "/";

    protected Action(String label, String namespace, Function<T, R> function, Optional<Pattern> filter, Display display, DisplayType displayType, Function<Path, Path> pathConverter) {
        this.label = label;
        this.namespace = namespace;
        this.function = function;
        this.filter = filter;
        this.display = display;
        this.displayType = displayType;
        this.pathConverter = pathConverter;
    }

    public String getId() {
        Object id = this.label.toLowerCase().replaceAll(SPACE, DASH);
        try {
            id = URLEncoder.encode((String)id, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        if (this.namespace != null) {
            id = this.namespace.toLowerCase() + SLASH + (String)id;
        }
        return id;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getLabel() {
        return this.label;
    }

    public Function<T, R> getFunction() {
        return this.function;
    }

    public Optional<Pattern> getFilter() {
        return this.filter;
    }

    public Display getDisplay() {
        return this.display;
    }

    public DisplayType getDisplayType() {
        return this.displayType;
    }

    public Function<Path, Path> getPathConverter() {
        return this.pathConverter;
    }

    public String toString() {
        return "Action {\n\tid=" + this.getId() + ", \n\tlabel=" + this.label + ", \n\tnamespace=" + this.namespace + ", \n\tfilter=" + String.valueOf(this.filter) + ", \n\tdisplay=" + String.valueOf((Object)this.display) + ", \n\tdisplayType=" + String.valueOf((Object)this.displayType) + "\n}";
    }

    public static ActionBuilder actionBuilder() {
        return new ActionBuilder();
    }
}

