/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.deployment;

import io.quarkus.builder.item.MultiBuildItem;
import io.quarkus.vertx.http.deployment.devmode.ConfiguredPathInfo;
import io.quarkus.vertx.http.deployment.devmode.NotFoundPageDisplayableEndpointBuildItem;
import io.quarkus.vertx.http.runtime.BasicRoute;
import io.quarkus.vertx.http.runtime.HandlerType;
import io.vertx.core.Handler;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public final class RouteBuildItem
extends MultiBuildItem {
    private final boolean management;
    private final Function<Router, Route> routeFunction;
    private final Handler<RoutingContext> handler;
    private final HandlerType type;
    private final RouteType routeType;
    private final RouteType routerType;
    private final NotFoundPageDisplayableEndpointBuildItem notFoundPageDisplayableEndpoint;
    private final ConfiguredPathInfo configuredPathInfo;

    public static Builder builder() {
        return new Builder();
    }

    RouteBuildItem(Builder builder, RouteType routeType, RouteType routerType, boolean management) {
        this.routeFunction = builder.routeFunction;
        this.handler = builder.handler;
        this.management = management;
        this.type = builder.type;
        this.routeType = routeType;
        this.routerType = routerType;
        this.notFoundPageDisplayableEndpoint = builder.getNotFoundEndpoint();
        this.configuredPathInfo = builder.getRouteConfigInfo();
    }

    public Handler<RoutingContext> getHandler() {
        return this.handler;
    }

    public HandlerType getType() {
        return this.type;
    }

    public Function<Router, Route> getRouteFunction() {
        return this.routeFunction;
    }

    public RouteType getRouteType() {
        return this.routeType;
    }

    public RouteType getRouterType() {
        return this.routerType;
    }

    public boolean isRouterFramework() {
        return this.routerType.equals((Object)RouteType.FRAMEWORK_ROUTE);
    }

    public boolean isRouterApplication() {
        return this.routerType.equals((Object)RouteType.APPLICATION_ROUTE);
    }

    public boolean isRouterAbsolute() {
        return this.routerType.equals((Object)RouteType.ABSOLUTE_ROUTE);
    }

    public NotFoundPageDisplayableEndpointBuildItem getNotFoundPageDisplayableEndpoint() {
        return this.notFoundPageDisplayableEndpoint;
    }

    public ConfiguredPathInfo getConfiguredPathInfo() {
        return this.configuredPathInfo;
    }

    public boolean isManagement() {
        return this.management;
    }

    public static class Builder {
        protected Function<Router, Route> routeFunction;
        protected Handler<RoutingContext> handler;
        protected HandlerType type = HandlerType.NORMAL;
        protected boolean displayOnNotFoundPage;
        protected String notFoundPageTitle;
        protected String notFoundPagePath;
        protected String routePath;
        protected String routeConfigKey;
        protected String absolutePath;
        protected boolean isManagement;

        @Deprecated
        public Builder routeFunction(Function<Router, Route> routeFunction) {
            this.routeFunction = routeFunction;
            return this;
        }

        public Builder routeFunction(String path, Consumer<Route> routeFunction) {
            this.routeFunction = new BasicRoute(path, null, routeFunction);
            this.notFoundPagePath = this.routePath = path;
            return this;
        }

        public Builder route(String route) {
            this.routeFunction = new BasicRoute(route);
            this.notFoundPagePath = this.routePath = route;
            return this;
        }

        public Builder orderedRoute(String route, Integer order) {
            this.routeFunction = new BasicRoute(route, order);
            this.notFoundPagePath = this.routePath = route;
            return this;
        }

        public Builder orderedRoute(String route, Integer order, Consumer<Route> routeCustomizer) {
            this.routeFunction = new BasicRoute(route, order, routeCustomizer);
            this.notFoundPagePath = this.routePath = route;
            return this;
        }

        public Builder handler(Handler<RoutingContext> handler) {
            this.handler = handler;
            return this;
        }

        public Builder handlerType(HandlerType handlerType) {
            this.type = handlerType;
            return this;
        }

        public Builder blockingRoute() {
            this.type = HandlerType.BLOCKING;
            return this;
        }

        public Builder failureRoute() {
            this.type = HandlerType.FAILURE;
            return this;
        }

        public Builder displayOnNotFoundPage() {
            this.displayOnNotFoundPage = true;
            return this;
        }

        public Builder displayOnNotFoundPage(String notFoundPageTitle) {
            this.displayOnNotFoundPage = true;
            this.notFoundPageTitle = notFoundPageTitle;
            return this;
        }

        public Builder routeConfigKey(String attributeName) {
            this.routeConfigKey = attributeName;
            return this;
        }

        public Builder management() {
            return this.management(null);
        }

        public Builder management(String managementConfigKey) {
            this.isManagement = managementConfigKey == null || this.shouldInclude(managementConfigKey);
            return this;
        }

        private boolean shouldInclude(String managementConfigKey) {
            Config config = ConfigProvider.getConfig();
            return (Boolean)config.getValue(managementConfigKey, Boolean.TYPE);
        }

        public RouteBuildItem build() {
            if (this.routeFunction == null) {
                throw new IllegalStateException("'RouteBuildItem$Builder.routeFunction' was not set. Ensure that one of the builder methods that result in it being set is called");
            }
            return new RouteBuildItem(this, RouteType.APPLICATION_ROUTE, RouteType.APPLICATION_ROUTE, this.isManagement);
        }

        protected ConfiguredPathInfo getRouteConfigInfo() {
            if (this.routeConfigKey == null) {
                return null;
            }
            if (this.routePath == null) {
                throw new RuntimeException("Cannot discover value of " + this.routeConfigKey + " as no explicit path was specified and a route function is in use");
            }
            if (this.absolutePath != null) {
                return new ConfiguredPathInfo(this.routeConfigKey, this.absolutePath, true, this.isManagement);
            }
            return new ConfiguredPathInfo(this.routeConfigKey, this.routePath, false, this.isManagement);
        }

        protected NotFoundPageDisplayableEndpointBuildItem getNotFoundEndpoint() {
            if (!this.displayOnNotFoundPage) {
                return null;
            }
            if (this.notFoundPagePath == null) {
                throw new RuntimeException("Cannot display " + this.routeFunction + " on not found page as no explicit path was specified and a route function is in use");
            }
            if (this.absolutePath != null) {
                return new NotFoundPageDisplayableEndpointBuildItem(this.absolutePath, this.notFoundPageTitle, true);
            }
            return new NotFoundPageDisplayableEndpointBuildItem(this.notFoundPagePath, this.notFoundPageTitle, false);
        }
    }

    public static enum RouteType {
        FRAMEWORK_ROUTE,
        APPLICATION_ROUTE,
        ABSOLUTE_ROUTE;

    }
}

