/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.AdditionalIndexedClassesBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.dev.console.DevConsoleManager;
import io.quarkus.devui.deployment.BuildTimeConstBuildItem;
import io.quarkus.devui.deployment.DevUIConfig;
import io.quarkus.devui.deployment.DevUIRoutesBuildItem;
import io.quarkus.devui.deployment.DevUIWebJarBuildItem;
import io.quarkus.devui.deployment.ExtensionsBuildItem;
import io.quarkus.devui.deployment.JsonRPCMethodsBuildItem;
import io.quarkus.devui.deployment.MvnpmBuildItem;
import io.quarkus.devui.deployment.extension.Codestart;
import io.quarkus.devui.deployment.extension.Extension;
import io.quarkus.devui.deployment.jsonrpc.DevUIDatabindCodec;
import io.quarkus.devui.runtime.DevUICORSFilter;
import io.quarkus.devui.runtime.DevUIRecorder;
import io.quarkus.devui.runtime.comms.JsonRpcRouter;
import io.quarkus.devui.runtime.jsonrpc.JsonRpcMethod;
import io.quarkus.devui.runtime.jsonrpc.JsonRpcMethodName;
import io.quarkus.devui.runtime.jsonrpc.json.JsonMapper;
import io.quarkus.devui.spi.DevUIContent;
import io.quarkus.devui.spi.JsonRPCProvidersBuildItem;
import io.quarkus.devui.spi.buildtime.StaticContentBuildItem;
import io.quarkus.devui.spi.page.Card;
import io.quarkus.devui.spi.page.CardPageBuildItem;
import io.quarkus.devui.spi.page.FooterPageBuildItem;
import io.quarkus.devui.spi.page.MenuPageBuildItem;
import io.quarkus.devui.spi.page.Page;
import io.quarkus.devui.spi.page.PageBuilder;
import io.quarkus.devui.spi.page.QuteDataPageBuilder;
import io.quarkus.maven.dependency.GACT;
import io.quarkus.maven.dependency.GACTV;
import io.quarkus.qute.Qute;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.util.ClassPathUtils;
import io.quarkus.vertx.http.deployment.NonApplicationRootPathBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.quarkus.vertx.http.deployment.webjar.WebJarBuildItem;
import io.quarkus.vertx.http.deployment.webjar.WebJarResourcesFilter;
import io.quarkus.vertx.http.deployment.webjar.WebJarResultsBuildItem;
import io.smallrye.common.annotation.Blocking;
import io.smallrye.common.annotation.NonBlocking;
import io.smallrye.mutiny.Multi;
import io.vertx.core.Handler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.invoke.CallSite;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.stream.Collectors;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.JandexReflection;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;
import org.yaml.snakeyaml.Yaml;

public class DevUIProcessor {
    private static final String DEVUI = "dev-ui";
    private static final String SLASH = "/";
    private static final String DOT = ".";
    private static final String DOUBLE_POINT = ":";
    private static final String DASH_DEPLOYMENT = "-deployment";
    private static final String SLASH_ALL = "/*";
    private static final String JSONRPC = "json-rpc-ws";
    private static final String CONSTRUCTOR = "<init>";
    private final ClassLoader tccl = Thread.currentThread().getContextClassLoader();
    private static final String JAR = "jar";
    private static final GACT UI_JAR = new GACT("io.quarkus", "quarkus-vertx-http-dev-ui-resources", null, "jar");
    private static final String YAML_FILE = "/META-INF/quarkus-extension.yaml";
    private static final String NAME = "name";
    private static final String DESCRIPTION = "description";
    private static final String ARTIFACT = "artifact";
    private static final String METADATA = "metadata";
    private static final String KEYWORDS = "keywords";
    private static final String SHORT_NAME = "short-name";
    private static final String GUIDE = "guide";
    private static final String CATEGORIES = "categories";
    private static final String STATUS = "status";
    private static final String BUILT_WITH = "built-with-quarkus-core";
    private static final String CONFIG = "config";
    private static final String EXTENSION_DEPENDENCIES = "extension-dependencies";
    private static final String CAPABILITIES = "capabilities";
    private static final String PROVIDES = "provides";
    private static final String UNLISTED = "unlisted";
    private static final String CODESTART = "codestart";
    private static final String LANGUAGES = "languages";
    private static final Logger log = Logger.getLogger(DevUIProcessor.class);
    private final Comparator sortingComparator = new Comparator<Extension>(){

        @Override
        public int compare(Extension t, Extension t1) {
            if (t.getGuide() != null && t1.getGuide() != null) {
                return t.getName().compareTo(t1.getName());
            }
            if (t.getGuide() == null) {
                return 1;
            }
            return -1;
        }
    };

    @BuildStep(onlyIf={IsDevelopment.class})
    @Record(value=ExecutionTime.STATIC_INIT)
    void registerDevUiHandlers(DevUIConfig devUIConfig, MvnpmBuildItem mvnpmBuildItem, List<DevUIRoutesBuildItem> devUIRoutesBuildItems, List<StaticContentBuildItem> staticContentBuildItems, BuildProducer<RouteBuildItem> routeProducer, DevUIRecorder recorder, LaunchModeBuildItem launchModeBuildItem, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem, ShutdownContextBuildItem shutdownContext) throws IOException {
        if (launchModeBuildItem.isNotLocalDevModeType()) {
            return;
        }
        if (devUIConfig.cors.enabled) {
            routeProducer.produce((BuildItem)((NonApplicationRootPathBuildItem.Builder)nonApplicationRootPathBuildItem.routeBuilder().orderedRoute("dev-ui/*", -300).handler((Handler)new DevUICORSFilter())).build());
        }
        routeProducer.produce((BuildItem)((NonApplicationRootPathBuildItem.Builder)nonApplicationRootPathBuildItem.routeBuilder().route("dev-ui/json-rpc-ws").handler(recorder.communicationHandler())).build());
        for (DevUIRoutesBuildItem devUIRoutesBuildItem : devUIRoutesBuildItems) {
            Iterator<DevUIRoutesBuildItem> route = devUIRoutesBuildItem.getPath();
            String path = nonApplicationRootPathBuildItem.resolvePath((String)((Object)route));
            Handler uihandler = recorder.uiHandler(devUIRoutesBuildItem.getFinalDestination(), path, devUIRoutesBuildItem.getWebRootConfigurations(), (ShutdownContext)shutdownContext);
            RouteBuildItem.Builder builder = nonApplicationRootPathBuildItem.routeBuilder().route((String)((Object)route)).handler(uihandler);
            if (((String)((Object)route)).endsWith("dev-ui/")) {
                builder = ((NonApplicationRootPathBuildItem.Builder)builder).displayOnNotFoundPage("Dev UI (v2)");
                routeProducer.produce((BuildItem)((NonApplicationRootPathBuildItem.Builder)builder).build());
            }
            routeProducer.produce((BuildItem)((NonApplicationRootPathBuildItem.Builder)nonApplicationRootPathBuildItem.routeBuilder().route(route + SLASH_ALL).handler(uihandler)).build());
        }
        String basepath = nonApplicationRootPathBuildItem.resolvePath(DEVUI);
        Path devUiBasePath = Files.createTempDirectory("quarkus-devui", new FileAttribute[0]);
        recorder.shutdownTask((ShutdownContext)shutdownContext, devUiBasePath.toString());
        for (StaticContentBuildItem staticContentBuildItem : staticContentBuildItems) {
            HashMap<String, String> urlAndPath = new HashMap<String, String>();
            List content = staticContentBuildItem.getContent();
            for (DevUIContent c : content) {
                String parsedContent = Qute.fmt((String)new String(c.getTemplate()), (Map)c.getData());
                Path tempFile = devUiBasePath.resolve(c.getFileName());
                Files.write(tempFile, parsedContent.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                urlAndPath.put(c.getFileName(), tempFile.toString());
            }
            Handler buildTimeStaticHandler = recorder.buildTimeStaticHandler(basepath, urlAndPath);
            routeProducer.produce((BuildItem)((NonApplicationRootPathBuildItem.Builder)nonApplicationRootPathBuildItem.routeBuilder().route("dev-ui/*").handler(buildTimeStaticHandler)).build());
        }
        for (DevUIRoutesBuildItem devUIRoutesBuildItem : devUIRoutesBuildItems) {
            String route = devUIRoutesBuildItem.getPath();
            basepath = nonApplicationRootPathBuildItem.resolvePath(route);
            Handler routerhandler = recorder.vaadinRouterHandler(basepath);
            routeProducer.produce((BuildItem)((NonApplicationRootPathBuildItem.Builder)nonApplicationRootPathBuildItem.routeBuilder().route(route + SLASH_ALL).handler(routerhandler)).build());
        }
        String contextRoot = nonApplicationRootPathBuildItem.getNonApplicationRootPath();
        routeProducer.produce((BuildItem)((NonApplicationRootPathBuildItem.Builder)nonApplicationRootPathBuildItem.routeBuilder().route("_static/*").handler(recorder.mvnpmHandler(contextRoot, mvnpmBuildItem.getMvnpmJars()))).build());
        routeProducer.produce((BuildItem)((NonApplicationRootPathBuildItem.Builder)nonApplicationRootPathBuildItem.routeBuilder().route("dev").handler(recorder.redirect(contextRoot))).build());
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    void additionalBean(BuildProducer<AdditionalBeanBuildItem> additionalBeanProducer, BuildProducer<AdditionalIndexedClassesBuildItem> additionalIndexProducer, List<JsonRPCProvidersBuildItem> jsonRPCProvidersBuildItems) {
        additionalBeanProducer.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(JsonRpcRouter.class).setUnremovable().build());
        for (JsonRPCProvidersBuildItem jsonRPCProvidersBuildItem : jsonRPCProvidersBuildItems) {
            Class c = jsonRPCProvidersBuildItem.getJsonRPCMethodProviderClass();
            additionalIndexProducer.produce((BuildItem)new AdditionalIndexedClassesBuildItem(c.getName()));
            DotName defaultBeanScope = jsonRPCProvidersBuildItem.getDefaultBeanScope() == null ? BuiltinScope.APPLICATION.getName() : jsonRPCProvidersBuildItem.getDefaultBeanScope();
            additionalBeanProducer.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(c).setDefaultScope(defaultBeanScope).setUnremovable().build());
        }
        additionalBeanProducer.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(JsonRpcRouter.class).setDefaultScope(BuiltinScope.APPLICATION.getName()).setUnremovable().build());
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    void findAllJsonRPCMethods(BuildProducer<JsonRPCMethodsBuildItem> jsonRPCMethodsProvider, BuildProducer<BuildTimeConstBuildItem> buildTimeConstProducer, LaunchModeBuildItem launchModeBuildItem, CombinedIndexBuildItem combinedIndexBuildItem, CurateOutcomeBuildItem curateOutcomeBuildItem, List<JsonRPCProvidersBuildItem> jsonRPCProvidersBuildItems) {
        if (launchModeBuildItem.isNotLocalDevModeType()) {
            return;
        }
        IndexView index = combinedIndexBuildItem.getIndex();
        HashMap<String, Map<JsonRpcMethodName, JsonRpcMethod>> extensionMethodsMap = new HashMap<String, Map<JsonRpcMethodName, JsonRpcMethod>>();
        ArrayList<CallSite> requestResponseMethods = new ArrayList<CallSite>();
        ArrayList<CallSite> subscriptionMethods = new ArrayList<CallSite>();
        for (JsonRPCProvidersBuildItem jsonRPCProvidersBuildItem : jsonRPCProvidersBuildItems) {
            Class clazz = jsonRPCProvidersBuildItem.getJsonRPCMethodProviderClass();
            String extension = jsonRPCProvidersBuildItem.getExtensionPathName(curateOutcomeBuildItem);
            Map<JsonRpcMethodName, JsonRpcMethod> jsonRpcMethods = new HashMap();
            if (extensionMethodsMap.containsKey(extension)) {
                jsonRpcMethods = (Map)extensionMethodsMap.get(extension);
            }
            ClassInfo classInfo = index.getClassByName(DotName.createSimple((String)clazz.getName()));
            List methods = classInfo.methods();
            for (MethodInfo method : methods) {
                if (method.name().equals(CONSTRUCTOR) || !Modifier.isPublic(method.flags()) || method.returnType().kind() == Type.Kind.VOID) continue;
                if (method.returnType().name().equals((Object)DotName.createSimple((String)Multi.class.getName()))) {
                    subscriptionMethods.add((CallSite)((Object)(extension + DOT + method.name())));
                } else {
                    requestResponseMethods.add((CallSite)((Object)(extension + DOT + method.name())));
                }
                JsonRpcMethodName jsonRpcMethodName = new JsonRpcMethodName(method.name());
                if (method.parametersCount() > 0) {
                    LinkedHashMap<String, Class> params = new LinkedHashMap<String, Class>();
                    for (int i = 0; i < method.parametersCount(); ++i) {
                        Type parameterType = method.parameterType(i);
                        Class parameterClass = this.toClass(parameterType);
                        String parameterName = method.parameterName(i);
                        params.put(parameterName, parameterClass);
                    }
                    JsonRpcMethod jsonRpcMethod = new JsonRpcMethod(clazz, method.name(), params);
                    jsonRpcMethod.setExplicitlyBlocking(method.hasAnnotation(Blocking.class));
                    jsonRpcMethod.setExplicitlyNonBlocking(method.hasAnnotation(NonBlocking.class));
                    jsonRpcMethods.put(jsonRpcMethodName, jsonRpcMethod);
                    continue;
                }
                JsonRpcMethod jsonRpcMethod = new JsonRpcMethod(clazz, method.name(), null);
                jsonRpcMethod.setExplicitlyBlocking(method.hasAnnotation(Blocking.class));
                jsonRpcMethod.setExplicitlyNonBlocking(method.hasAnnotation(NonBlocking.class));
                jsonRpcMethods.put(jsonRpcMethodName, jsonRpcMethod);
            }
            if (jsonRpcMethods.isEmpty()) continue;
            extensionMethodsMap.put(extension, jsonRpcMethods);
        }
        if (!extensionMethodsMap.isEmpty()) {
            jsonRPCMethodsProvider.produce((BuildItem)new JsonRPCMethodsBuildItem(extensionMethodsMap));
        }
        BuildTimeConstBuildItem methodInfo = new BuildTimeConstBuildItem("devui-jsonrpc");
        if (!subscriptionMethods.isEmpty()) {
            methodInfo.addBuildTimeData("jsonRPCSubscriptions", subscriptionMethods);
        }
        if (!requestResponseMethods.isEmpty()) {
            methodInfo.addBuildTimeData("jsonRPCMethods", requestResponseMethods);
        }
        buildTimeConstProducer.produce((BuildItem)methodInfo);
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    @Record(value=ExecutionTime.STATIC_INIT)
    void createJsonRpcRouter(DevUIRecorder recorder, BeanContainerBuildItem beanContainer, JsonRPCMethodsBuildItem jsonRPCMethodsBuildItem) {
        if (jsonRPCMethodsBuildItem != null) {
            Map<String, Map<JsonRpcMethodName, JsonRpcMethod>> extensionMethodsMap = jsonRPCMethodsBuildItem.getExtensionMethodsMap();
            DevConsoleManager.setGlobal((String)"dev-ui-databind-codec-builder", (Object)JsonMapper.Factory.deploymentLinker().createLinkData((Object)new DevUIDatabindCodec.Factory()));
            recorder.createJsonRpcRouter(beanContainer.getValue(), extensionMethodsMap);
        }
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    void getAllExtensions(List<CardPageBuildItem> cardPageBuildItems, List<MenuPageBuildItem> menuPageBuildItems, List<FooterPageBuildItem> footerPageBuildItems, LaunchModeBuildItem launchModeBuildItem, CurateOutcomeBuildItem curateOutcomeBuildItem, BuildProducer<ExtensionsBuildItem> extensionsProducer, BuildProducer<WebJarBuildItem> webJarBuildProducer, BuildProducer<DevUIWebJarBuildItem> devUIWebJarProducer) {
        if (launchModeBuildItem.isNotLocalDevModeType()) {
            ExtensionsBuildItem emptyExtensionBuildItem = new ExtensionsBuildItem(List.of(), List.of(), List.of(), List.of());
            extensionsProducer.produce((BuildItem)emptyExtensionBuildItem);
            return;
        }
        webJarBuildProducer.produce((BuildItem)WebJarBuildItem.builder().artifactKey(UI_JAR).root("dev-ui/").build());
        devUIWebJarProducer.produce((BuildItem)new DevUIWebJarBuildItem(UI_JAR, DEVUI));
        Map<String, CardPageBuildItem> cardPagesMap = this.getCardPagesMap(curateOutcomeBuildItem, cardPageBuildItems);
        Map<String, MenuPageBuildItem> menuPagesMap = this.getMenuPagesMap(curateOutcomeBuildItem, menuPageBuildItems);
        Map<String, FooterPageBuildItem> footerPagesMap = this.getFooterPagesMap(curateOutcomeBuildItem, footerPageBuildItems);
        try {
            Yaml yaml = new Yaml();
            ArrayList<Extension> activeExtensions = new ArrayList<Extension>();
            ArrayList<Extension> inactiveExtensions = new ArrayList<Extension>();
            ArrayList<Extension> sectionMenuExtensions = new ArrayList<Extension>();
            ArrayList<Extension> footerTabExtensions = new ArrayList<Extension>();
            ClassPathUtils.consumeAsPaths((String)YAML_FILE, p -> {
                try {
                    String extensionYaml;
                    Extension extension = new Extension();
                    try (Scanner scanner = new Scanner(Files.newBufferedReader(p, StandardCharsets.UTF_8));){
                        scanner.useDelimiter("\\A");
                        extensionYaml = scanner.hasNext() ? scanner.next() : null;
                    }
                    if (extensionYaml == null) {
                        return;
                    }
                    Map extensionMap = (Map)yaml.load(extensionYaml);
                    if (extensionMap.containsKey(NAME)) {
                        Page page;
                        Map buildTimeData;
                        Map codestartMap;
                        String namespace = this.getExtensionNamespace(extensionMap);
                        extension.setNamespace(namespace);
                        extension.setName((String)extensionMap.get(NAME));
                        extension.setDescription(extensionMap.getOrDefault(DESCRIPTION, null));
                        String artifactId = extensionMap.getOrDefault(ARTIFACT, null);
                        extension.setArtifact(artifactId);
                        Map metaData = extensionMap.getOrDefault(METADATA, null);
                        extension.setKeywords(metaData.getOrDefault(KEYWORDS, null));
                        extension.setShortName(metaData.getOrDefault(SHORT_NAME, null));
                        if (metaData.containsKey(GUIDE)) {
                            String guide = (String)metaData.get(GUIDE);
                            try {
                                extension.setGuide(new URL(guide));
                            }
                            catch (MalformedURLException mue) {
                                log.warn((Object)("Could not set Guide URL [" + guide + "] for exception [" + namespace + "]"));
                            }
                        }
                        extension.setCategories(metaData.getOrDefault(CATEGORIES, null));
                        extension.setStatus(this.collectionToString(metaData, STATUS));
                        extension.setBuiltWith(metaData.getOrDefault(BUILT_WITH, null));
                        extension.setConfigFilter(metaData.getOrDefault(CONFIG, null));
                        extension.setExtensionDependencies(metaData.getOrDefault(EXTENSION_DEPENDENCIES, null));
                        extension.setUnlisted(String.valueOf(metaData.getOrDefault(UNLISTED, false)));
                        if (metaData.containsKey(CAPABILITIES)) {
                            Map capabilities = (Map)metaData.get(CAPABILITIES);
                            extension.setProvidesCapabilities(capabilities.getOrDefault(PROVIDES, null));
                        }
                        if (metaData.containsKey(CODESTART) && (codestartMap = (Map)metaData.get(metaData)) != null) {
                            Codestart codestart = new Codestart();
                            codestart.setName(codestartMap.getOrDefault(NAME, null));
                            codestart.setLanguages(codestartMap.getOrDefault(LANGUAGES, null));
                            codestart.setArtifact(codestartMap.getOrDefault(ARTIFACT, null));
                            extension.setCodestart(codestart);
                        }
                        if (!cardPagesMap.containsKey(namespace)) {
                            inactiveExtensions.add(extension);
                        } else {
                            CardPageBuildItem cardPageBuildItem = (CardPageBuildItem)cardPagesMap.get(namespace);
                            List cardPageBuilders = cardPageBuildItem.getPages();
                            buildTimeData = cardPageBuildItem.getBuildTimeData();
                            for (PageBuilder pageBuilder : cardPageBuilders) {
                                page = this.buildFinalPage(pageBuilder, extension, buildTimeData);
                                extension.addCardPage(page);
                            }
                            cardPageBuildItem.getOptionalCard().ifPresent(card -> {
                                card.setNamespace(extension.getNamespace());
                                extension.setCard((Card)card);
                            });
                            this.produceResources(artifactId, webJarBuildProducer, devUIWebJarProducer);
                            activeExtensions.add(extension);
                        }
                        if (menuPagesMap.containsKey(namespace)) {
                            MenuPageBuildItem menuPageBuildItem = (MenuPageBuildItem)menuPagesMap.get(namespace);
                            List menuPageBuilders = menuPageBuildItem.getPages();
                            buildTimeData = menuPageBuildItem.getBuildTimeData();
                            for (PageBuilder pageBuilder : menuPageBuilders) {
                                page = this.buildFinalPage(pageBuilder, extension, buildTimeData);
                                extension.addMenuPage(page);
                            }
                            this.produceResources(artifactId, webJarBuildProducer, devUIWebJarProducer);
                            sectionMenuExtensions.add(extension);
                        }
                        if (footerPagesMap.containsKey(namespace)) {
                            FooterPageBuildItem footerPageBuildItem = (FooterPageBuildItem)footerPagesMap.get(namespace);
                            List footerPageBuilders = footerPageBuildItem.getPages();
                            buildTimeData = footerPageBuildItem.getBuildTimeData();
                            for (PageBuilder pageBuilder : footerPageBuilders) {
                                page = this.buildFinalPage(pageBuilder, extension, buildTimeData);
                                extension.addFooterPage(page);
                            }
                            this.produceResources(artifactId, webJarBuildProducer, devUIWebJarProducer);
                            footerTabExtensions.add(extension);
                        }
                    }
                    Collections.sort(activeExtensions, this.sortingComparator);
                    Collections.sort(inactiveExtensions, this.sortingComparator);
                }
                catch (IOException | RuntimeException e) {
                    log.error((Object)("Failed to process extension descriptor " + p.toUri()), (Throwable)e);
                }
            });
            extensionsProducer.produce((BuildItem)new ExtensionsBuildItem(activeExtensions, inactiveExtensions, sectionMenuExtensions, footerTabExtensions));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private String collectionToString(Map<String, Object> metaData, String key) {
        Object value = metaData.getOrDefault(key, null);
        if (value == null) {
            return null;
        }
        if (String.class.isAssignableFrom(value.getClass())) {
            return (String)value;
        }
        if (List.class.isAssignableFrom(value.getClass())) {
            List values = (List)value;
            return values.stream().map(n -> String.valueOf(n)).collect(Collectors.joining(", "));
        }
        return String.valueOf(value);
    }

    private void produceResources(String artifactId, BuildProducer<WebJarBuildItem> webJarBuildProducer, BuildProducer<DevUIWebJarBuildItem> devUIWebJarProducer) {
        GACT gact = this.getGACT(artifactId);
        String namespace = this.getNamespace(gact);
        if (namespace.isEmpty()) {
            namespace = "devui";
        }
        final String buildTimeDataImport = namespace + "-data";
        webJarBuildProducer.produce((BuildItem)WebJarBuildItem.builder().artifactKey(gact).root("dev-ui/").filter(new WebJarResourcesFilter(){

            @Override
            public WebJarResourcesFilter.FilterResult apply(String fileName, InputStream file) throws IOException {
                if (fileName.endsWith(".js")) {
                    String content = new String(file.readAllBytes(), StandardCharsets.UTF_8);
                    content = content.replaceAll("build-time-data", buildTimeDataImport);
                    return new WebJarResourcesFilter.FilterResult(new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8)), true);
                }
                return new WebJarResourcesFilter.FilterResult(file, false);
            }
        }).build());
        devUIWebJarProducer.produce((BuildItem)new DevUIWebJarBuildItem(gact, DEVUI));
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    void createAllRoutes(WebJarResultsBuildItem webJarResultsBuildItem, LaunchModeBuildItem launchModeBuildItem, List<DevUIWebJarBuildItem> devUIWebJarBuiltItems, BuildProducer<DevUIRoutesBuildItem> devUIRoutesProducer) {
        if (launchModeBuildItem.isNotLocalDevModeType()) {
            return;
        }
        for (DevUIWebJarBuildItem devUIWebJarBuiltItem : devUIWebJarBuiltItems) {
            WebJarResultsBuildItem.WebJarResult result = webJarResultsBuildItem.byArtifactKey(devUIWebJarBuiltItem.getArtifactKey());
            if (result == null) continue;
            String namespace = this.getNamespace(devUIWebJarBuiltItem.getArtifactKey());
            devUIRoutesProducer.produce((BuildItem)new DevUIRoutesBuildItem(namespace, devUIWebJarBuiltItem.getPath(), result.getFinalDestination(), result.getWebRootConfigurations()));
        }
    }

    private String getNamespace(GACT artifactKey) {
        Object namespace = artifactKey.getGroupId() + DOT + artifactKey.getArtifactId();
        if (((String)namespace).equals("io.quarkus.quarkus-vertx-http-dev-ui-resources")) {
            namespace = "";
        } else if (((String)namespace).endsWith(DASH_DEPLOYMENT)) {
            int end = ((String)namespace).lastIndexOf("-");
            namespace = ((String)namespace).substring(0, end);
        }
        return namespace;
    }

    private Page buildFinalPage(PageBuilder pageBuilder, Extension extension, Map<String, Object> buildTimeData) {
        pageBuilder.namespace(extension.getNamespace());
        pageBuilder.extension(extension.getName());
        if (pageBuilder.getClass().equals(QuteDataPageBuilder.class)) {
            return this.buildQutePage(pageBuilder, extension, buildTimeData);
        }
        return pageBuilder.build();
    }

    private Page buildQutePage(PageBuilder pageBuilder, Extension extension, Map<String, Object> buildTimeData) {
        try {
            QuteDataPageBuilder quteDataPageBuilder = (QuteDataPageBuilder)pageBuilder;
            String templatePath = quteDataPageBuilder.getTemplatePath();
            ClassPathUtils.consumeAsPaths((String)templatePath, p -> {
                try {
                    String template = Files.readString(p);
                    String fragment = Qute.fmt((String)template, (Map)buildTimeData);
                    pageBuilder.metadata("htmlFragment", fragment);
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            });
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        return pageBuilder.build();
    }

    private GACT getGACT(String artifactKey) {
        String[] split = artifactKey.split(DOUBLE_POINT);
        return new GACT(split[0], split[1] + DASH_DEPLOYMENT, null, JAR);
    }

    private Class toClass(Type type) {
        if (type.kind().equals((Object)Type.Kind.PRIMITIVE)) {
            return JandexReflection.loadRawType((Type)type);
        }
        if (type.kind().equals((Object)Type.Kind.VOID)) {
            throw new RuntimeException("Void method return detected, JsonRPC Method needs to return something.");
        }
        try {
            return this.tccl.loadClass(type.name().toString());
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    private Map<String, CardPageBuildItem> getCardPagesMap(CurateOutcomeBuildItem curateOutcomeBuildItem, List<CardPageBuildItem> pages) {
        HashMap<String, CardPageBuildItem> m = new HashMap<String, CardPageBuildItem>();
        for (CardPageBuildItem pageBuildItem : pages) {
            String name = pageBuildItem.getExtensionPathName(curateOutcomeBuildItem);
            m.put(name, pageBuildItem);
        }
        return m;
    }

    private Map<String, MenuPageBuildItem> getMenuPagesMap(CurateOutcomeBuildItem curateOutcomeBuildItem, List<MenuPageBuildItem> pages) {
        HashMap<String, MenuPageBuildItem> m = new HashMap<String, MenuPageBuildItem>();
        for (MenuPageBuildItem pageBuildItem : pages) {
            m.put(pageBuildItem.getExtensionPathName(curateOutcomeBuildItem), pageBuildItem);
        }
        return m;
    }

    private Map<String, FooterPageBuildItem> getFooterPagesMap(CurateOutcomeBuildItem curateOutcomeBuildItem, List<FooterPageBuildItem> pages) {
        HashMap<String, FooterPageBuildItem> m = new HashMap<String, FooterPageBuildItem>();
        for (FooterPageBuildItem pageBuildItem : pages) {
            m.put(pageBuildItem.getExtensionPathName(curateOutcomeBuildItem), pageBuildItem);
        }
        return m;
    }

    private String getExtensionNamespace(Map<String, Object> extensionMap) {
        String artifactId;
        String groupId;
        String artifact = (String)extensionMap.get(ARTIFACT);
        if (artifact == null) {
            groupId = (String)extensionMap.get("group-id");
            artifactId = (String)extensionMap.get("artifact-id");
            if (artifactId == null || groupId == null) {
                throw new RuntimeException("Failed to locate 'artifact' or 'group-id' and 'artifact-id' among metadata keys " + extensionMap.keySet());
            }
        } else {
            GACTV coords = GACTV.fromString((String)artifact);
            groupId = coords.getGroupId();
            artifactId = coords.getArtifactId();
        }
        return groupId + DOT + artifactId;
    }
}

