/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.deployment;

import io.quarkus.builder.item.MultiBuildItem;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;

public final class HttpAuthMechanismAnnotationBuildItem
extends MultiBuildItem {
    final DotName annotationName;
    final String authMechanismScheme;
    private final Set<DotName> excludedTargetInterfaces;

    public HttpAuthMechanismAnnotationBuildItem(DotName annotationName, String authMechanismScheme) {
        this.annotationName = Objects.requireNonNull(annotationName);
        this.authMechanismScheme = Objects.requireNonNull(authMechanismScheme);
        this.excludedTargetInterfaces = Set.of();
    }

    public HttpAuthMechanismAnnotationBuildItem(DotName annotationName, String authMechanismScheme, DotName ... excludedTargetInterfaces) {
        this.annotationName = Objects.requireNonNull(annotationName);
        this.authMechanismScheme = Objects.requireNonNull(authMechanismScheme);
        this.excludedTargetInterfaces = Set.of(Objects.requireNonNull(excludedTargetInterfaces));
    }

    static Predicate<AnnotationTarget> isExcludedAnnotationTarget(List<HttpAuthMechanismAnnotationBuildItem> items) {
        Set excludedInterfaceNames = items.stream().map(i -> i.excludedTargetInterfaces).flatMap(Collection::stream).collect(Collectors.toSet());
        return annotationTarget -> {
            ClassInfo classInfo;
            if (annotationTarget.kind() == AnnotationTarget.Kind.CLASS) {
                classInfo = annotationTarget.asClass();
            } else if (annotationTarget.kind() == AnnotationTarget.Kind.METHOD && annotationTarget.asMethod().declaringClass() != null) {
                classInfo = annotationTarget.asMethod().declaringClass();
            } else {
                return false;
            }
            return classInfo.interfaceNames().stream().anyMatch(excludedInterfaceNames::contains);
        };
    }
}

