/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.deployment.webjar;

import io.quarkus.builder.item.MultiBuildItem;
import io.quarkus.maven.dependency.GACT;
import io.quarkus.vertx.http.deployment.webjar.WebJarResourcesFilter;

public final class WebJarBuildItem
extends MultiBuildItem {
    private final GACT artifactKey;
    private final String root;
    private final boolean onlyCopyNonArtifactFiles;
    private final boolean useDefaultQuarkusBranding;
    private final WebJarResourcesFilter filter;

    private WebJarBuildItem(Builder builder) {
        this.artifactKey = builder.artifactKey;
        this.root = builder.root;
        this.useDefaultQuarkusBranding = builder.useDefaultQuarkusBranding;
        this.onlyCopyNonArtifactFiles = builder.onlyCopyNonArtifactFiles;
        this.filter = builder.filter;
    }

    public GACT getArtifactKey() {
        return this.artifactKey;
    }

    public String getRoot() {
        return this.root;
    }

    public boolean getUseDefaultQuarkusBranding() {
        return this.useDefaultQuarkusBranding;
    }

    public boolean getOnlyCopyNonArtifactFiles() {
        return this.onlyCopyNonArtifactFiles;
    }

    public WebJarResourcesFilter getFilter() {
        return this.filter;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private GACT artifactKey;
        private String root;
        private WebJarResourcesFilter filter;
        private boolean useDefaultQuarkusBranding = true;
        private boolean onlyCopyNonArtifactFiles = true;

        public Builder artifactKey(GACT artifactKey) {
            this.artifactKey = artifactKey;
            return this;
        }

        public Builder root(String root) {
            this.root = root;
            if (this.root != null && this.root.startsWith("/")) {
                this.root = this.root.substring(1);
            }
            return this;
        }

        public Builder filter(WebJarResourcesFilter filter) {
            this.filter = filter;
            return this;
        }

        public Builder useDefaultQuarkusBranding(boolean useDefaultQuarkusBranding) {
            this.useDefaultQuarkusBranding = useDefaultQuarkusBranding;
            return this;
        }

        public Builder onlyCopyNonArtifactFiles(boolean onlyCopyNonArtifactFiles) {
            this.onlyCopyNonArtifactFiles = onlyCopyNonArtifactFiles;
            return this;
        }

        public WebJarBuildItem build() {
            return new WebJarBuildItem(this);
        }
    }
}

