/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AutoAddScopeBuildItem;
import io.quarkus.arc.deployment.BeanRegistrationPhaseBuildItem;
import io.quarkus.arc.deployment.CurrentContextFactoryBuildItem;
import io.quarkus.arc.deployment.InvokerFactoryBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.processor.AnnotationStore;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BuildExtension;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.InvokerBuilder;
import io.quarkus.arc.processor.InvokerInfo;
import io.quarkus.arc.processor.KotlinUtils;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.GeneratedClassGizmo2Adaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.AnnotationProxyBuildItem;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.CapabilityBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageConfigBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveMethodBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.deployment.pkg.builditem.CompiledJavaVersionBuildItem;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.gizmo.ClassTransformer;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo2.ClassOutput;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.vertx.ConsumeEvent;
import io.quarkus.vertx.core.deployment.CoreVertxBuildItem;
import io.quarkus.vertx.deployment.EventConsumerBusinessMethodItem;
import io.quarkus.vertx.deployment.LocalCodecSelectorTypesBuildItem;
import io.quarkus.vertx.deployment.MessageCodecBuildItem;
import io.quarkus.vertx.deployment.VertxBuildConfig;
import io.quarkus.vertx.deployment.VertxBuildItem;
import io.quarkus.vertx.deployment.VertxConstants;
import io.quarkus.vertx.deployment.spi.EventConsumerInvokerCustomizerBuildItem;
import io.quarkus.vertx.runtime.EventConsumerInfo;
import io.quarkus.vertx.runtime.VertxEventBusConsumerRecorder;
import io.quarkus.vertx.runtime.VertxProducer;
import io.smallrye.common.annotation.Blocking;
import io.smallrye.common.annotation.RunOnVirtualThread;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.core.AbstractVerticle;
import io.vertx.core.Vertx;
import io.vertx.core.impl.VertxImpl;
import io.vertx.mutiny.core.MultiMap;
import io.vertx.mutiny.core.eventbus.Message;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;
import org.objectweb.asm.ClassVisitor;

class VertxProcessor {
    private static final Logger LOGGER = Logger.getLogger((String)VertxProcessor.class.getName());

    VertxProcessor() {
    }

    @BuildStep
    void featureAndCapability(BuildProducer<FeatureBuildItem> feature, BuildProducer<CapabilityBuildItem> capability) {
        feature.produce((BuildItem)new FeatureBuildItem(Feature.VERTX));
    }

    @BuildStep
    AdditionalBeanBuildItem registerBean() {
        return AdditionalBeanBuildItem.unremovableOf(VertxProducer.class);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    VertxBuildItem build(CoreVertxBuildItem vertx, VertxEventBusConsumerRecorder recorder, List<EventConsumerBusinessMethodItem> messageConsumerBusinessMethods, BuildProducer<GeneratedClassBuildItem> generatedClass, BuildProducer<GeneratedResourceBuildItem> generatedResource, AnnotationProxyBuildItem annotationProxy, LaunchModeBuildItem launchMode, ShutdownContextBuildItem shutdown, BuildProducer<ServiceStartBuildItem> serviceStart, List<MessageCodecBuildItem> codecs, LocalCodecSelectorTypesBuildItem localCodecSelectorTypes, RecorderContext recorderContext) {
        ArrayList<EventConsumerInfo> messageConsumerConfigurations = new ArrayList<EventConsumerInfo>();
        GeneratedClassGizmo2Adaptor classOutput = new GeneratedClassGizmo2Adaptor(generatedClass, generatedResource, true);
        for (EventConsumerBusinessMethodItem businessMethod : messageConsumerBusinessMethods) {
            ConsumeEvent annotation = (ConsumeEvent)annotationProxy.builder(businessMethod.getConsumeEvent(), ConsumeEvent.class).withDefaultValue("value", (Object)businessMethod.getBean().getBeanClass().toString()).build((ClassOutput)classOutput);
            messageConsumerConfigurations.add(new EventConsumerInfo(annotation, businessMethod.isBlockingAnnotation(), businessMethod.isRunOnVirtualThreadAnnotation(), businessMethod.isSplitHeadersBodyParams(), recorderContext.newInstance(businessMethod.getInvoker().getClassName())));
        }
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        HashMap codecByClass = new HashMap();
        for (MessageCodecBuildItem messageCodecItem : codecs) {
            codecByClass.put(this.tryLoad(messageCodecItem.getType(), tccl), this.tryLoad(messageCodecItem.getCodec(), tccl));
        }
        ArrayList selectorTypes = new ArrayList();
        for (String name : localCodecSelectorTypes.getTypes()) {
            selectorTypes.add(this.tryLoad(name, tccl));
        }
        recorder.configureVertx(vertx.getVertx(), messageConsumerConfigurations, launchMode.getLaunchMode(), (ShutdownContext)shutdown, codecByClass, selectorTypes);
        serviceStart.produce((BuildItem)new ServiceStartBuildItem("vertx"));
        return new VertxBuildItem((RuntimeValue<Vertx>)recorder.forceStart(vertx.getVertx()));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void currentContextFactory(BuildProducer<CurrentContextFactoryBuildItem> currentContextFactory, VertxBuildConfig buildConfig, VertxEventBusConsumerRecorder recorder) {
        if (buildConfig.customizeArcContext()) {
            currentContextFactory.produce((BuildItem)new CurrentContextFactoryBuildItem(recorder.currentContextFactory()));
        }
    }

    @BuildStep
    public UnremovableBeanBuildItem unremovableBeans() {
        return new UnremovableBeanBuildItem((Predicate)new UnremovableBeanBuildItem.BeanClassAnnotationExclusion(VertxConstants.CONSUME_EVENT));
    }

    @BuildStep
    void collectEventConsumers(BeanRegistrationPhaseBuildItem beanRegistrationPhase, InvokerFactoryBuildItem invokerFactory, List<EventConsumerInvokerCustomizerBuildItem> invokerCustomizers, BuildProducer<EventConsumerBusinessMethodItem> messageConsumerBusinessMethods, BuildProducer<BeanRegistrationPhaseBuildItem.BeanConfiguratorBuildItem> errors) {
        AnnotationStore annotationStore = (AnnotationStore)beanRegistrationPhase.getContext().get(BuildExtension.Key.ANNOTATION_STORE);
        for (BeanInfo bean : beanRegistrationPhase.getContext().beans().classBeans()) {
            for (MethodInfo method : ((AnnotationTarget)bean.getTarget().get()).asClass().methods()) {
                AnnotationInstance consumeEvent;
                if (method.isSynthetic() || (consumeEvent = annotationStore.getAnnotation((AnnotationTarget)method, VertxConstants.CONSUME_EVENT)) == null) continue;
                int parametersCount = method.parametersCount();
                if (KotlinUtils.isKotlinSuspendMethod((MethodInfo)method)) {
                    --parametersCount;
                }
                List params = method.parameterTypes();
                if (parametersCount == 2) {
                    if (!VertxConstants.isMessageHeaders(((Type)params.get(0)).name())) {
                        throw new IllegalStateException(String.format("An event consumer business method with two parameters must have MultiMap as the first parameter: %s [method: %s, bean:%s]", params, method, bean));
                    }
                    if (VertxConstants.isMessage(((Type)params.get(1)).name())) {
                        throw new IllegalStateException(String.format("An event consumer business method with two parameters must not accept io.vertx.core.eventbus.Message or io.vertx.mutiny.core.eventbus.Message: %s [method: %s, bean:%s]", params, method, bean));
                    }
                } else if (parametersCount != 1) {
                    throw new IllegalStateException(String.format("An event consumer business method must accept exactly one parameter: %s [method: %s, bean:%s]", params, method, bean));
                }
                if (method.returnType().kind() != Type.Kind.VOID && VertxConstants.isMessage(((Type)params.get(0)).name()) && !KotlinUtils.isKotlinSuspendMethod((MethodInfo)method)) {
                    throw new IllegalStateException(String.format("An event consumer business method that accepts io.vertx.core.eventbus.Message or io.vertx.mutiny.core.eventbus.Message must return void [method: %s, bean:%s]", method, bean));
                }
                if (method.hasAnnotation(RunOnVirtualThread.class) && consumeEvent.value("ordered") != null && consumeEvent.value("ordered").asBoolean()) {
                    throw new IllegalStateException(String.format("An event consumer business method that cannot use @RunOnVirtualThread and set the ordered attribute to true [method: %s, bean:%s]", method, bean));
                }
                InvokerBuilder builder = invokerFactory.createInvoker(bean, method).withInstanceLookup();
                if (parametersCount != 1 || !method.parameterType(0).name().equals((Object)VertxConstants.MESSAGE)) {
                    if (parametersCount == 1 && method.parameterType(0).name().equals((Object)VertxConstants.MUTINY_MESSAGE)) {
                        builder.withArgumentTransformer(0, Message.class, "newInstance");
                    } else if (parametersCount == 1) {
                        builder.withArgumentTransformer(0, io.vertx.core.eventbus.Message.class, "body");
                    } else if (parametersCount == 2 && method.parameterType(0).name().equals((Object)VertxConstants.MUTINY_MESSAGE_HEADERS)) {
                        builder.withArgumentTransformer(0, MultiMap.class, "newInstance");
                    }
                }
                if (method.returnType().name().equals((Object)VertxConstants.UNI)) {
                    builder.withReturnValueTransformer(Uni.class, "subscribeAsCompletionStage");
                }
                for (EventConsumerInvokerCustomizerBuildItem invokerCustomizer : invokerCustomizers) {
                    invokerCustomizer.getInvokerCustomizer().accept(method, builder);
                }
                InvokerInfo invoker = builder.build();
                messageConsumerBusinessMethods.produce((BuildItem)new EventConsumerBusinessMethodItem(bean, consumeEvent, method.hasAnnotation(Blocking.class), method.hasAnnotation(RunOnVirtualThread.class), parametersCount == 2, invoker));
                LOGGER.debugf("Found event consumer business method %s declared on %s", (Object)method, (Object)bean);
            }
        }
    }

    @BuildStep
    AutoAddScopeBuildItem autoAddScope() {
        return AutoAddScopeBuildItem.builder().containsAnnotations(new DotName[]{VertxConstants.CONSUME_EVENT}).defaultScope(BuiltinScope.SINGLETON).reason("Found event consumer business methods").build();
    }

    @BuildStep
    void registerVerticleClasses(CombinedIndexBuildItem indexBuildItem, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        for (ClassInfo ci : indexBuildItem.getIndex().getAllKnownSubclasses(DotName.createSimple((String)AbstractVerticle.class.getName()))) {
            reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{ci.toString()}).build());
        }
    }

    @BuildStep
    void faultToleranceIntegration(Capabilities capabilities, BuildProducer<ServiceProviderBuildItem> serviceProvider) {
        if (capabilities.isPresent("io.quarkus.smallrye.faulttolerance")) {
            serviceProvider.produce((BuildItem)new ServiceProviderBuildItem("io.smallrye.faulttolerance.core.event.loop.EventLoop", new String[]{"io.smallrye.faulttolerance.vertx.VertxEventLoop"}));
        }
    }

    @BuildStep
    NativeImageConfigBuildItem reinitializeClassesForNetty() {
        NativeImageConfigBuildItem.Builder builder = NativeImageConfigBuildItem.builder();
        builder.addRuntimeInitializedClass("io.vertx.core.http.impl.Http1xServerResponse").addRuntimeInitializedClass("io.vertx.core.parsetools.impl.RecordParserImpl");
        if (QuarkusClassLoader.isClassPresentAtRuntime((String)"io.vertx.ext.web.client.impl.MultipartFormUpload")) {
            builder.addRuntimeInitializedClass("io.vertx.ext.web.client.impl.MultipartFormUpload");
        }
        return builder.build();
    }

    private Class<?> tryLoad(String name, ClassLoader tccl) {
        try {
            return tccl.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Unable to load type: " + name, e);
        }
    }

    @BuildStep
    void registerNativeImageResources(BuildProducer<NativeImageResourceBuildItem> resources) {
        resources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/services/io.vertx.core.spi.VertxServiceProvider"}));
        resources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/services/io.vertx.core.spi.VerticleFactory"}));
    }

    @BuildStep
    void registerReflectivelyAccessedMethods(BuildProducer<ReflectiveMethodBuildItem> reflectiveMethods) {
        reflectiveMethods.produce((BuildItem)new ReflectiveMethodBuildItem("java.lang.Thread$Builder$OfVirtual", "name", new Class[]{String.class, Long.TYPE}));
        reflectiveMethods.produce((BuildItem)new ReflectiveMethodBuildItem("java.lang.Thread$Builder", "factory", new Class[0]));
    }

    @BuildStep
    void simplifyVertxImplGetVirtualThreadFactoryOnJava21(CompiledJavaVersionBuildItem compiledJavaVersion, BuildProducer<BytecodeTransformerBuildItem> bytecodeTransformers) {
        if (compiledJavaVersion.getJavaVersion().isJava21OrHigher() != CompiledJavaVersionBuildItem.JavaVersion.Status.TRUE) {
            return;
        }
        final String className = VertxImpl.class.getName();
        bytecodeTransformers.produce((BuildItem)new BytecodeTransformerBuildItem.Builder().setClassToTransform(className).setCacheable(true).setVisitorFunction((BiFunction)new BiFunction<String, ClassVisitor, ClassVisitor>(){

            @Override
            public ClassVisitor apply(String s, ClassVisitor classVisitor) {
                ClassTransformer transformer = new ClassTransformer(className);
                MethodDescriptor virtualThreadFactoryDescriptor = MethodDescriptor.ofMethod((Object)className, (String)"virtualThreadFactory", ThreadFactory.class, (Object[])new Object[0]);
                transformer.removeMethod(virtualThreadFactoryDescriptor);
                MethodCreator method = (MethodCreator)transformer.addMethod(virtualThreadFactoryDescriptor).setModifiers(10);
                ResultHandle builderOfVirtual = method.invokeStaticMethod(MethodDescriptor.ofMethod(Thread.class, (String)"ofVirtual", (Object)"java.lang.Thread$Builder$OfVirtual", (Object[])new Object[0]), new ResultHandle[0]);
                ResultHandle namePrefix = method.load("vert.x-virtual-thread-");
                ResultHandle startValue = method.load(0L);
                ResultHandle namedBuilder = method.invokeInterfaceMethod(MethodDescriptor.ofMethod((Object)"java.lang.Thread$Builder$OfVirtual", (String)"name", (Object)"java.lang.Thread$Builder$OfVirtual", (Object[])new Object[]{String.class, Long.TYPE}), builderOfVirtual, new ResultHandle[]{namePrefix, startValue});
                ResultHandle factory = method.invokeInterfaceMethod(MethodDescriptor.ofMethod((Object)"java.lang.Thread$Builder", (String)"factory", ThreadFactory.class, (Object[])new Object[0]), namedBuilder, new ResultHandle[0]);
                method.returnValue(factory);
                return transformer.applyTo(classVisitor);
            }
        }).build());
    }
}

