/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.undertow.deployment;

import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithConverter;
import io.smallrye.config.WithDefault;
import jakarta.annotation.Priority;
import java.util.Optional;
import org.eclipse.microprofile.config.spi.Converter;

@ConfigMapping(prefix="quarkus.servlet")
@ConfigRoot(phase=ConfigPhase.BUILD_TIME)
public interface ServletConfig {
    public Optional<@WithConverter(value=ContextPathConverter.class) String> contextPath();

    @WithDefault(value="UTF-8")
    public String defaultCharset();

    @Priority(value=200)
    public static class ContextPathConverter
    implements Converter<String> {
        private static final String SLASH = "/";

        public String convert(String value) throws IllegalArgumentException, NullPointerException {
            if (value == null) {
                return SLASH;
            }
            if (SLASH.equals(value = ((String)value).trim())) {
                return value;
            }
            if (!((String)value).startsWith(SLASH)) {
                value = SLASH + (String)value;
            }
            return value;
        }
    }
}

