/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.security;

import io.quarkus.runtime.LaunchMode;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.runtime.SecurityIdentityAssociation;
import io.quarkus.test.security.DelegateSecurityIdentityAssociation;
import io.smallrye.mutiny.Uni;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Alternative;
import jakarta.inject.Inject;

@Alternative
@Priority(value=3000)
@ApplicationScoped
public class TestIdentityAssociation
extends SecurityIdentityAssociation {
    volatile SecurityIdentity testIdentity;
    volatile boolean isPathBasedIdentity = false;
    @Inject
    DelegateSecurityIdentityAssociation delegate;

    @PostConstruct
    public void check() {
        if (LaunchMode.current() != LaunchMode.TEST) {
            throw new RuntimeException("TestAuthController can only be used in tests");
        }
    }

    public SecurityIdentity getTestIdentity() {
        return this.testIdentity;
    }

    public TestIdentityAssociation setTestIdentity(SecurityIdentity testIdentity) {
        this.testIdentity = testIdentity;
        return this;
    }

    public void setIdentity(SecurityIdentity identity) {
        this.delegate.setIdentity(identity);
    }

    public void setIdentity(Uni<SecurityIdentity> identity) {
        this.delegate.setIdentity(identity);
    }

    public Uni<SecurityIdentity> getDeferredIdentity() {
        if (this.testIdentity == null) {
            return this.delegate.getDeferredIdentity();
        }
        return this.delegate.getDeferredIdentity().onItem().transform(underlying -> underlying.isAnonymous() && !this.isPathBasedIdentity ? this.testIdentity : underlying);
    }

    public SecurityIdentity getIdentity() {
        SecurityIdentity underlying = this.delegate.getIdentity();
        if (underlying.isAnonymous() && this.testIdentity != null && !this.isPathBasedIdentity) {
            return this.testIdentity;
        }
        return this.delegate.getIdentity();
    }

    void setPathBasedIdentity(boolean pathBasedIdentity) {
        this.isPathBasedIdentity = pathBasedIdentity;
    }
}

