/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.openapi.deployment.filter;

import io.quarkus.runtime.configuration.ConfigurationException;
import io.quarkus.smallrye.openapi.common.deployment.SmallRyeOpenApiConfig;
import java.util.HashMap;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.microprofile.openapi.OASFactory;
import org.eclipse.microprofile.openapi.OASFilter;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.security.OAuthFlow;
import org.eclipse.microprofile.openapi.models.security.OAuthFlows;
import org.eclipse.microprofile.openapi.models.security.SecurityScheme;
import org.jboss.logging.Logger;

public class SecurityConfigFilter
implements OASFilter {
    private static final Logger log = Logger.getLogger(SecurityConfigFilter.class);
    private final SmallRyeOpenApiConfig config;

    public SecurityConfigFilter(SmallRyeOpenApiConfig config) {
        this.config = config;
    }

    public void filterOpenAPI(OpenAPI openAPI) {
        if (this.config.securityScheme.isEmpty()) {
            return;
        }
        if (openAPI.getComponents() == null) {
            openAPI.setComponents(OASFactory.createComponents());
        }
        HashMap<String, SecurityScheme> securitySchemes = new HashMap<String, SecurityScheme>();
        Optional.ofNullable(openAPI.getComponents().getSecuritySchemes()).ifPresent(securitySchemes::putAll);
        SmallRyeOpenApiConfig.SecurityScheme securitySchemeOption = (SmallRyeOpenApiConfig.SecurityScheme)this.config.securityScheme.get();
        SecurityScheme securityScheme = OASFactory.createSecurityScheme();
        securityScheme.setDescription(this.config.securitySchemeDescription);
        this.config.getValidSecuritySchemeExtentions().forEach((arg_0, arg_1) -> ((SecurityScheme)securityScheme).addExtension(arg_0, arg_1));
        switch (securitySchemeOption) {
            case apiKey: {
                this.configureApiKeySecurityScheme(securityScheme);
                break;
            }
            case basic: {
                securityScheme.setType(SecurityScheme.Type.HTTP);
                securityScheme.setScheme(this.config.basicSecuritySchemeValue);
                break;
            }
            case jwt: {
                securityScheme.setType(SecurityScheme.Type.HTTP);
                securityScheme.setScheme(this.config.jwtSecuritySchemeValue);
                securityScheme.setBearerFormat(this.config.jwtBearerFormat);
                break;
            }
            case oauth2: {
                securityScheme.setType(SecurityScheme.Type.HTTP);
                securityScheme.setScheme(this.config.oauth2SecuritySchemeValue);
                securityScheme.setBearerFormat(this.config.oauth2BearerFormat);
                break;
            }
            case oidc: {
                securityScheme.setType(SecurityScheme.Type.OPENIDCONNECT);
                securityScheme.setOpenIdConnectUrl((String)this.config.oidcOpenIdConnectUrl.orElse(null));
                break;
            }
            case oauth2Implicit: {
                securityScheme.setType(SecurityScheme.Type.OAUTH2);
                OAuthFlows oAuthFlows = OASFactory.createOAuthFlows();
                OAuthFlow oAuthFlow = OASFactory.createOAuthFlow();
                this.config.oauth2ImplicitAuthorizationUrl.ifPresent(arg_0 -> ((OAuthFlow)oAuthFlow).authorizationUrl(arg_0));
                this.config.oauth2ImplicitRefreshUrl.ifPresent(arg_0 -> ((OAuthFlow)oAuthFlow).refreshUrl(arg_0));
                this.config.oauth2ImplicitTokenUrl.ifPresent(arg_0 -> ((OAuthFlow)oAuthFlow).tokenUrl(arg_0));
                oAuthFlows.setImplicit(oAuthFlow);
                securityScheme.setType(SecurityScheme.Type.OAUTH2);
                securityScheme.setFlows(oAuthFlows);
            }
        }
        securitySchemes.put(this.config.securitySchemeName, securityScheme);
        openAPI.getComponents().setSecuritySchemes(securitySchemes);
        if (securitySchemes.size() > 1) {
            log.warn((Object)("Detected multiple Security Schemes, only one scheme is supported at the moment " + securitySchemes.keySet().toString()));
        }
    }

    void configureApiKeySecurityScheme(SecurityScheme securityScheme) {
        securityScheme.setType(SecurityScheme.Type.APIKEY);
        securityScheme.setName((String)this.config.apiKeyParameterName.orElseThrow(() -> new ConfigurationException("Parameter `name` is required for `apiKey` OpenAPI security scheme")));
        securityScheme.setIn(this.config.apiKeyParameterIn.map(in -> Stream.of(SecurityScheme.In.values()).filter(v -> v.toString().equals(in)).findFirst().orElseThrow(() -> new ConfigurationException("Parameter `in` given for `apiKey` OpenAPI security schema is invalid: [" + in + "]"))).orElseThrow(() -> new ConfigurationException("Parameter `in` is required for `apiKey` OpenAPI security scheme")));
    }
}

